unit UnitProcConfMaForm;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, StdCtrls, CheckLst, UnitClsTbl, Grids;

procedure Welcome(M: TMemo);
procedure LabelMol(L: TLabel; IdA, IdR, Pop, Exp, Pred: integer; w: double = -1);
procedure LabelMol(L: TLabel; PClsD: PTClsData; clstbl: TClsTbl);
procedure ShowCellsStats(M: TMemo; clstbl:TClsTbl);
procedure ShowGeneralStats(M: TMemo; clstbl: TClsTbl);
procedure LoadGrid(FrgCmpSG: TStringGrid; clstbl: TClsTbl);
procedure LoadListBox(LB: TListBox; clstbl: TClsTbl);
procedure LoadChkLstBox(LB: TCheckListBox; clstbl: TClsTbl);
procedure MajorityVote(M: TMemo; clstbl:TClsTbl);

implementation

procedure Welcome(M: TMemo);
begin
     M.Lines.Add('*************************');
     M.Lines.Add('Classification Analyzer  ');
     M.Lines.Add('Université de Strasbourg ');
     M.Lines.Add('Faculté de Chimie        ');
     M.Lines.Add('Laboratoire d''Infochimie');
     M.Lines.Add('2010                     ');
     M.Lines.Add('G. Marcou, V. Solov''ev  ');
     M.Lines.Add('*************************');

end;

procedure LabelMol(L: TLabel; IdA, IdR, Pop, Exp, Pred: integer; w: double = -1);
begin
     L.Caption := 'Looking at Record: '+IntToStr(IdA)+' ( '+IntToStr(IdR)+' of '
     +IntToStr(Pop)+' of Cell['+IntToStr(Exp)+', '+IntToStr(Pred)+'] )';
     if (w>=0) then
        L.Caption:=L.Caption+' Confidence: '+FloatToStrF(w,ffGeneral,4,2);
end;

procedure LabelMol(L: TLabel; PClsD: PTClsData; clstbl: TClsTbl);
begin
     L.Caption := 'Looking at Record: '+IntToStr(PClsD^.Id)+' ( '+IntToStr(clstbl.CurrM-clstbl.GetClsPrds.BMf+1)+
     ' of '+IntToStr(clstbl.GetClsPrds.Pop)+' of Cell['+IntToStr(clstbl.CurrE)+', '+IntToStr(clstbl.CurrP)+'] )';
     if (PClsD^.Confidence[PClsD^.PredID]>=0) then
        L.Caption:=L.Caption+' Confidence: '+FloatToStrF(PClsD^.Confidence[PClsD^.PredID],ffGeneral,4,2);
end;

procedure ShowCellsStats(M: TMemo; clstbl: TClsTbl);
var
   Exp: integer;
   SLROC: TStringList;
begin
     SLROC:=TStringList.Create;
     Exp:=clstbl.CurrE;
     if (clstbl.CurrE<>clstbl.ClsStat.ExpOld) then begin
        M.Lines.Append('--------------------------');
        M.Lines.Append('Recall('+IntToStr(Exp)+')='+FloatToStr(clstbl.ClsStat.Recall(Exp)));
        M.Lines.Append('Precision('+IntToStr(Exp)+')='+FloatToStr(clstbl.ClsStat.Precision(Exp)));
        M.Lines.Append('F-measure('+IntToStr(Exp)+')='+FloatToStr(clstbl.ClsStat.Fmeasure(Exp)));
        M.Lines.Append('MCC('+IntToStr(Exp)+')='+FloatToStr(clstbl.ClsStat.MCC(Exp)));
        M.Lines.Append('ROC AUC('+IntToStr(Exp)+')='+FloatToStr(clstbl.ROC(Exp,SLROC)));
        M.Lines.Append('ROC Curve saved in file: '+ExtractFilePath(clstbl.SDFflenme)+'ROC'+IntToStr(Exp)+'.csv');
        SLROC.SaveToFile(ExtractFilePath(clstbl.SDFflenme)+'ROC'+IntToStr(Exp)+'.csv');
        clstbl.ClsStat.ExpOld:=Exp;
     end;
     FreeAndNil(SLROC);
end;

procedure ShowGeneralStats(M: TMemo; clstbl: TClsTbl);
begin
     M.Lines.Append('--------------------------');
     M.Lines.Add('Accuracy: '+FloatToStr(clstbl.ClsStat.Accuracy));
     M.Lines.Add('Balanced Accuracy: '+FloatToStr(clstbl.ClsStat.BalancedAccuracy));
end;

procedure LoadGrid(FrgCmpSG: TStringGrid; clstbl: TClsTbl);
var
   i, j, m  : Integer;
   iCol     : Integer;
   iRow     : Integer;
begin
     with clstbl do begin
     m := NCls;
     FrgCmpSG.RowCount := m+3;
     FrgCmpSG.ColCount := m+2;
     //FrgCmpSG.Cells[0, 0] := 'v pred.\exp. -->';
     // titles
     for iCol:=1 to m do begin
         iRow := iCol;
         i := iCol-1;
         FrgCmpSG.Cells[iCol, 0] := IntToStr(iCol-1);
         FrgCmpSG.Cells[0, iRow] := IntToStr(iCol-1);
     end;
     FrgCmpSG.Cells[0,FrgCmpSG.RowCount-2] := 'No Pred';
     FrgCmpSG.Cells[0, FrgCmpSG.RowCount-1] := 'exp. TOTAL';
     FrgCmpSG.Cells[FrgCmpSG.ColCount-1, 0] := 'pred. TOTAL';
     // data
     for i:=Low(ClsPrds) to High(ClsPrds)-1 do begin
         iCol:=i+1;
         for j:=Low(ClsPrds) to High(ClsPrds) do begin
             iRow:=j+1;
             FrgCmpSG.Cells[iCol, iRow]:=IntToStr(ClsPrds[i,j].Pop);
             //writeln(IntToStr(ClsPrds[i,j].BM)+' '+IntToStr(iCol)+' '+IntToStr(iRow));
             //writeln(IntToStr(i)+' '+IntToStr(j)+' '+IntToStr(ClsPrds[i,j].Pop)+' '+IntToStr(iCol)+' '+IntToStr(iRow));
         end;
     end;
     // exp. TOTAL sums
     j := m+2;
     for iCol:=1 to m do begin
         i := 0;
         for iRow:=1 to m do i := i+StrToInt(FrgCmpSG.Cells[iCol, iRow]);
         FrgCmpSG.Cells[iCol, j] := IntToStr(i);
     end;
     // pred. TOTAL sums
     j := m+1;
     for iRow:=1 to m do begin
         i := 0;
         for iCol:=1 to m do i := i+StrToInt(FrgCmpSG.Cells[iCol, iRow]);
         FrgCmpSG.Cells[j, iRow] := IntToStr(i);
     end;
     end;
end;  // LoadGrid

procedure LoadListBox(LB: TListBox; clstbl: TClsTbl);
var
   i: integer;
begin
     for i:=0 to clstbl.NPred-1 do LB.Items.Add('Model '+IntToStr(i+1));
end;

procedure LoadChkLstBox(LB: TCheckListBox; clstbl: TClsTbl);
var
   i: integer;
begin
     for i:=0 to clstbl.NPred-1 do begin
         LB.Items.Add('Model '+IntToStr(i+1));
         LB.Checked[i]:=True;
     end;
end;

procedure MajorityVote(M: TMemo; clstbl: TClsTbl);
var
   tmpSL: TStringList;
   i,j: integer;
   pitem: PTClsData;
   voting: array of double;
   v,vmax, vtot: double;
   cls: integer;
begin
     tmpSL:=TStringList.Create;
     tmpSL.Add('#SDF '+clstbl.SDFflenme);
     tmpSL.Add('#Classes '+IntToStr(clstbl.NCls));
     tmpSL.Add('#Predictions 1');
     tmpSL.Add('#Weights 1');
     SetLength(voting,clstbl.NCls);
     for i:=0 to clstbl.Count-1 do begin
         pitem:=clstbl.Items[i];
         for j:=Low(voting) to High(voting) do voting[j]:=0;
         for j:=Low(pitem^.Preds) to High(pitem^.Preds) do
             if (clstbl.GetWeightVal(j)>=1) then
                voting[pitem^.Preds[j]]:=voting[pitem^.Preds[j]]+pitem^.Confidence[j];
         vmax:=voting[0];
         cls:=0;
         vtot:=0;
         for j:=Low(voting) to High(voting) do begin
             if vmax<=voting[j] then begin
                vmax:=voting[j];
                cls:=j;
             end;
             vtot:=vtot+voting[j];
         end;
         v:=0;
         if (vtot<>0) then v:=vmax/vtot;
         tmpSL.Add(IntToStr(pitem^.Id)+' '+IntToStr(pitem^.Exp)+' '+IntToStr(cls)+' '+FloatToStrF(v,ffGeneral,5,2));
     end;
     M.Lines.Add('*********Vote!*********');
     M.Lines.Add('Please check the results, opening the file: '+ExtractFilePath(clstbl.SDFflenme)+'Vote.txt');
     tmpSL.SaveToFile(ExtractFilePath(clstbl.SDFflenme)+'Vote.txt');
     FreeAndNil(tmpSL);
end;


end.

