/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor.tree;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import weka.gui.ensembleLibraryEditor.tree.NumberClassNotFoundException;
import weka.gui.ensembleLibraryEditor.tree.NumberNode;
import weka.gui.ensembleLibraryEditor.tree.PropertyNode;

public class NumberNodeEditor
extends JPanel
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3486848815982334460L;
    private JButton m_IteratorButton;
    private JFormattedTextField m_NumberField;
    private JCheckBox m_SelectedCheckBox;
    private JLabel m_Label;
    private Color textForeground;
    private Color textBackground;
    private NumberNode m_Node;

    public NumberNodeEditor(NumberNode node) {
        this.m_Node = node;
        String name = node.getText();
        Number value = node.getValue();
        int iteratorType = node.getIteratorType();
        boolean showCheckBox = node.getCheckable();
        boolean selected = node.getSelected();
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
        this.setForeground(this.textForeground);
        this.setBackground(this.textBackground);
        Font fontValue = UIManager.getFont("Tree.font");
        if (showCheckBox) {
            this.m_SelectedCheckBox = new JCheckBox();
            this.m_SelectedCheckBox.setSelected(selected);
            this.m_SelectedCheckBox.setForeground(this.textForeground);
            this.m_SelectedCheckBox.setBackground(this.textBackground);
            this.m_SelectedCheckBox.addItemListener(this);
            this.add(this.m_SelectedCheckBox);
        }
        this.m_Label = new JLabel(name);
        if (fontValue != null) {
            this.m_Label.setFont(fontValue);
        }
        this.m_Label.setForeground(this.textForeground);
        this.m_Label.setBackground(this.textBackground);
        this.add(this.m_Label);
        if (iteratorType != 0) {
            this.updateIteratorButton();
            this.m_IteratorButton.setForeground(this.textForeground);
            this.m_IteratorButton.setBackground(this.textBackground);
            this.add(this.m_IteratorButton);
        }
        NumberFormat numberFormat = null;
        try {
            numberFormat = node.getNumberFormat();
        }
        catch (NumberClassNotFoundException e) {
            e.printStackTrace();
        }
        this.m_NumberField = new JFormattedTextField(numberFormat);
        this.m_NumberField.setValue(value);
        this.m_NumberField.setColumns(10);
        this.m_NumberField.setForeground(this.textForeground);
        this.m_NumberField.setBackground(this.textBackground);
        this.m_NumberField.addPropertyChangeListener(this);
        this.add(this.m_NumberField);
        if (!selected && showCheckBox) {
            this.m_Label.setEnabled(false);
            if (this.m_IteratorButton != null) {
                this.m_IteratorButton.setEnabled(false);
            }
            this.m_NumberField.setEnabled(false);
        }
    }

    public void setActionListener(ActionListener actionListener) {
        if (this.m_IteratorButton != null) {
            this.m_IteratorButton.addActionListener(actionListener);
        }
    }

    public void setItemListener(ItemListener itemListener) {
        if (this.m_SelectedCheckBox != null) {
            this.m_SelectedCheckBox.addItemListener(itemListener);
        }
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_NumberField != null) {
            this.m_NumberField.addPropertyChangeListener(propertyChangeListener);
        }
    }

    private void updateIteratorButton() {
        if (this.m_Node.getIteratorType() == 2) {
            this.m_IteratorButton = new JButton("+=");
            this.m_IteratorButton.addActionListener(this);
        } else if (this.m_Node.getIteratorType() == 1) {
            this.m_IteratorButton = new JButton("*=");
            this.m_IteratorButton.addActionListener(this);
        }
        this.m_IteratorButton.repaint();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_Node.getIteratorType() == 2) {
            this.m_Node.setIteratorType(1);
            try {
                if (this.m_Node.getValue().equals(this.m_Node.getOneValue())) {
                    this.m_Node.setValue(this.m_Node.getTwoValue());
                    this.updateIteratorButton();
                }
            }
            catch (NumberClassNotFoundException e1) {
                e1.printStackTrace();
            }
        } else if (this.m_Node.getIteratorType() == 1) {
            this.m_Node.setIteratorType(2);
            try {
                if (this.m_Node.getValue().equals(this.m_Node.getTwoValue())) {
                    this.m_Node.setValue(this.m_Node.getOneValue());
                    this.updateIteratorButton();
                }
            }
            catch (NumberClassNotFoundException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            PropertyNode parent = (PropertyNode)this.m_Node.getParent();
            if (parent.canSelect(this.m_Node)) {
                this.m_Node.setSelected(true);
                this.m_Label.setEnabled(true);
                if (this.m_IteratorButton != null) {
                    this.m_IteratorButton.setEnabled(true);
                }
                this.m_NumberField.setEnabled(true);
            } else {
                this.m_SelectedCheckBox.setSelected(false);
            }
        } else if (e.getStateChange() == 2) {
            PropertyNode parent = (PropertyNode)this.m_Node.getParent();
            if (parent.canDeselect(this.m_Node)) {
                this.m_Node.setSelected(false);
                this.m_Label.setEnabled(false);
                if (this.m_IteratorButton != null) {
                    this.m_IteratorButton.setEnabled(false);
                }
                this.m_NumberField.setEnabled(false);
            } else {
                this.m_SelectedCheckBox.setSelected(true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JFormattedTextField && evt.getPropertyName().equals("value") && ((JFormattedTextField)evt.getSource()).getValue() != null) {
            Number newValue = null;
            Number value = this.m_Node.getValue();
            JFormattedTextField field = (JFormattedTextField)evt.getSource();
            Number fieldValue = (Number)field.getValue();
            if (value instanceof Double) {
                newValue = new Double(NumberNode.roundDouble(fieldValue.doubleValue()));
            } else if (value instanceof Integer) {
                newValue = new Integer(fieldValue.intValue());
            } else if (value instanceof Float) {
                newValue = new Float(NumberNode.roundFloat(fieldValue.floatValue()));
            } else if (value instanceof Long) {
                newValue = new Long(fieldValue.longValue());
            } else {
                try {
                    throw new NumberClassNotFoundException(value.getClass() + " not currently supported.");
                }
                catch (NumberClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            field.setValue(newValue);
            this.m_Node.setValue(newValue);
        }
    }
}

