/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Customizer;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.filechooser.FileFilter;
import weka.core.ClassloaderUtil;
import weka.core.Copyright;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Memory;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.GenericPropertiesCreator;
import weka.gui.HierarchyPropertyParser;
import weka.gui.LookAndFeel;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanConnection;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.LogPanel;
import weka.gui.beans.MetaBean;
import weka.gui.beans.StartUpListener;
import weka.gui.beans.Startable;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;
import weka.gui.beans.xml.XMLBeans;
import weka.gui.visualize.PrintablePanel;

public class KnowledgeFlowApp
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -7064906770289728431L;
    protected static String PROPERTY_FILE = "weka/gui/beans/Beans.props";
    protected static Properties BEAN_PROPERTIES;
    private static ArrayList<Properties> BEAN_PLUGINS_PROPERTIES;
    private static Vector TOOLBARS;
    FontMetrics m_fontM;
    protected static final int NONE = 0;
    protected static final int MOVING = 1;
    protected static final int CONNECTING = 2;
    protected static final int ADDING = 3;
    protected static final int SELECTING = 4;
    private int m_mode = 0;
    protected static final String USERCOMPONENTS_XML_EXTENSION = ".xml";
    private ButtonGroup m_toolBarGroup = new ButtonGroup();
    private Object m_toolBarBean;
    private BeanLayout m_beanLayout = new BeanLayout();
    private JTabbedPane m_toolBars = new JTabbedPane();
    private JToolBar m_pluginsToolBar = null;
    private Box m_pluginsBoxPanel = null;
    private JToolBar m_userToolBar = null;
    private Box m_userBoxPanel = null;
    private Vector m_userComponents = new Vector();
    private boolean m_firstUserComponentOpp = true;
    private JToggleButton m_pointerB;
    private JButton m_saveB;
    private JButton m_loadB;
    private JButton m_stopB;
    private JButton m_helpB;
    private JButton m_newB;
    private BeanInstance m_editElement;
    private EventSetDescriptor m_sourceEventSetDescriptor;
    private int m_oldX;
    private int m_oldY;
    private int m_startX;
    private int m_startY;
    protected JFileChooser m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    protected LogPanel m_logPanel = new LogPanel();
    protected BeanContextSupport m_bcSupport = new BeanContextSupport();
    public static final String FILE_EXTENSION = ".kf";
    public static final String FILE_EXTENSION_XML = ".kfml";
    protected FileFilter m_KfFilter = new ExtensionFileFilter(".kf", "Binary KnowledgeFlow configuration files (*.kf)");
    protected FileFilter m_KOMLFilter = new ExtensionFileFilter(".komlkf", "XML KnowledgeFlow configuration files (*.komlkf)");
    protected FileFilter m_XStreamFilter = new ExtensionFileFilter(".xstreamkf", "XML KnowledgeFlow configuration files (*.xstreamkf)");
    protected FileFilter m_XMLFilter = new ExtensionFileFilter(".kfml", "XML KnowledgeFlow layout files (*.kfml)");
    protected int m_ScrollBarIncrementLayout = 20;
    protected int m_ScrollBarIncrementComponents = 50;
    protected int m_FlowWidth = 1024;
    protected int m_FlowHeight = 768;
    protected String m_PreferredExtension = ".kf";
    protected boolean m_UserComponentsInXML = false;
    protected Environment m_flowEnvironment = new Environment();
    private static KnowledgeFlowApp m_knowledgeFlow;
    private static Memory m_Memory;
    public static Vector s_startupListeners;
    private boolean m_showFileMenu = true;

    public static void loadProperties() {
        if (BEAN_PROPERTIES == null) {
            System.out.println("[KnowledgeFlow] Loading properties and plugins...");
            try {
                BEAN_PROPERTIES = Utils.readProperties(PROPERTY_FILE);
                Enumeration<?> keys = BEAN_PROPERTIES.propertyNames();
                if (!keys.hasMoreElements()) {
                    throw new Exception("Could not read a configuration file for the bean\npanel. An example file is included with the Weka distribution.\nThis file should be named \"" + PROPERTY_FILE + "\" and\n" + "should be placed either in your user home (which is set\n" + "to \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n");
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
            }
            File pluginDir = new File(System.getProperty("user.home") + File.separator + ".knowledgeFlow" + File.separator + "plugins");
            if (pluginDir.exists() && pluginDir.isDirectory()) {
                BEAN_PLUGINS_PROPERTIES = new ArrayList();
                File[] contents = pluginDir.listFiles();
                for (int i = 0; i < contents.length; ++i) {
                    if (!contents[i].isDirectory() || contents[i].listFiles().length <= 0) continue;
                    try {
                        Properties tempP = new Properties();
                        File propFile = new File(contents[i].getPath() + File.separator + "Beans.props");
                        tempP.load(new FileInputStream(propFile));
                        BEAN_PLUGINS_PROPERTIES.add(tempP);
                        File[] anyJars = contents[i].listFiles();
                        for (int j = 0; j < anyJars.length; ++j) {
                            if (!anyJars[j].getPath().endsWith(".jar")) continue;
                            System.out.println("[KnowledgeFlow] Plugins: adding " + anyJars[j].getPath() + " to classpath...");
                            ClassloaderUtil.addFile(anyJars[j].getPath());
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("[KnowledgeFlow] Warning: Unable to load bean properties for plugin directory: " + contents[i].getPath());
                    }
                }
            } else {
                pluginDir.mkdir();
            }
        }
    }

    private static void init() {
        System.out.println("[KnowledgeFlow] Initializing KF...");
        try {
            Vector newV;
            TreeMap<Integer, Vector> wrapList = new TreeMap<Integer, Vector>();
            GenericPropertiesCreator creator = new GenericPropertiesCreator();
            Properties GEOProps = null;
            if (creator.useDynamic()) {
                creator.execute(false);
                GEOProps = creator.getOutputProperties();
            } else {
                GEOProps = Utils.readProperties("weka/gui/GenericObjectEditor.props");
            }
            Enumeration<?> en = GEOProps.propertyNames();
            while (en.hasMoreElements()) {
                String geoKey = (String)en.nextElement();
                String beanCompName = BEAN_PROPERTIES.getProperty(geoKey);
                if (beanCompName == null) continue;
                newV = new Vector();
                String toolBarNameAlias = BEAN_PROPERTIES.getProperty(geoKey + ".alias");
                String toolBarName = toolBarNameAlias != null ? toolBarNameAlias : geoKey.substring(geoKey.lastIndexOf(46) + 1, geoKey.length());
                String order = BEAN_PROPERTIES.getProperty(geoKey + ".order");
                Integer intOrder = order != null ? new Integer(order) : new Integer(0);
                newV.addElement(toolBarName);
                newV.addElement(beanCompName);
                String rootPackage = geoKey.substring(0, geoKey.lastIndexOf(46));
                newV.addElement(rootPackage);
                String wekaAlgs = GEOProps.getProperty(geoKey);
                Hashtable roots = GenericObjectEditor.sortClassesByRoot(wekaAlgs);
                Hashtable<String, HierarchyPropertyParser> hpps = new Hashtable<String, HierarchyPropertyParser>();
                Enumeration enm = roots.keys();
                while (enm.hasMoreElements()) {
                    String root = (String)enm.nextElement();
                    String classes = (String)roots.get(root);
                    HierarchyPropertyParser hpp = new HierarchyPropertyParser();
                    hpp.build(classes, ", ");
                    hpps.put(root, hpp);
                }
                newV.addElement(hpps);
                StringTokenizer st = new StringTokenizer(wekaAlgs, ", ");
                while (st.hasMoreTokens()) {
                    String current = st.nextToken().trim();
                    newV.addElement(current);
                }
                wrapList.put(intOrder, newV);
            }
            for (Integer key : wrapList.keySet()) {
                newV = (Vector)wrapList.get(key);
                if (newV == null) continue;
                TOOLBARS.addElement(newV);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the generic objecte editor. An example file is included with the Weka distribution.\nThis file should be named \"GenericObjectEditor.props\" and\nshould be placed either in your user home (which is set\nto \"" + System.getProperties().getProperty("user.home") + "\")\n" + "or the directory that java was started from\n", "KnowledgeFlow", 0);
        }
        try {
            String standardToolBarNames = BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow.standardToolBars");
            StringTokenizer st = new StringTokenizer(standardToolBarNames, ", ");
            while (st.hasMoreTokens()) {
                String tempBarName = st.nextToken().trim();
                Vector<String> newV = new Vector<String>();
                newV.addElement(tempBarName);
                newV.addElement("null");
                String toolBarContents = BEAN_PROPERTIES.getProperty("weka.gui.beans.KnowledgeFlow." + tempBarName);
                StringTokenizer st2 = new StringTokenizer(toolBarContents, ", ");
                while (st2.hasMoreTokens()) {
                    String tempBeanName = st2.nextToken().trim();
                    newV.addElement(tempBeanName);
                }
                TOOLBARS.addElement(newV);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "KnowledgeFlow", 0);
        }
    }

    public void setEnvironment(Environment env) {
        this.m_flowEnvironment = env;
        this.setEnvironment();
    }

    private void setEnvironment() {
        Vector beans = BeanInstance.getBeanInstances();
        for (int i = 0; i < beans.size(); ++i) {
            Object temp = ((BeanInstance)beans.elementAt(i)).getBean();
            if (!(temp instanceof EnvironmentHandler)) continue;
            ((EnvironmentHandler)temp).setEnvironment(this.m_flowEnvironment);
        }
    }

    public KnowledgeFlowApp(boolean showFileMenu) {
        if (BEAN_PROPERTIES == null) {
            KnowledgeFlowApp.loadProperties();
            KnowledgeFlowApp.init();
        }
        this.m_showFileMenu = showFileMenu;
        JWindow temp = new JWindow();
        temp.setVisible(true);
        temp.getGraphics().setFont(new Font(null, 0, 9));
        this.m_fontM = temp.getGraphics().getFontMetrics();
        temp.setVisible(false);
        try {
            this.m_ScrollBarIncrementLayout = Integer.parseInt(BEAN_PROPERTIES.getProperty("ScrollBarIncrementLayout", "" + this.m_ScrollBarIncrementLayout));
            this.m_ScrollBarIncrementComponents = Integer.parseInt(BEAN_PROPERTIES.getProperty("ScrollBarIncrementComponents", "" + this.m_ScrollBarIncrementComponents));
            this.m_FlowWidth = Integer.parseInt(BEAN_PROPERTIES.getProperty("FlowWidth", "" + this.m_FlowWidth));
            this.m_FlowHeight = Integer.parseInt(BEAN_PROPERTIES.getProperty("FlowHeight", "" + this.m_FlowHeight));
            this.m_PreferredExtension = BEAN_PROPERTIES.getProperty("PreferredExtension", this.m_PreferredExtension);
            this.m_UserComponentsInXML = Boolean.valueOf(BEAN_PROPERTIES.getProperty("UserComponentsInXML", "" + this.m_UserComponentsInXML));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_KfFilter);
        if (KOML.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        if (XStream.isPresent()) {
            this.m_FileChooser.addChoosableFileFilter(this.m_XStreamFilter);
        }
        this.m_FileChooser.addChoosableFileFilter(this.m_XMLFilter);
        if (this.m_PreferredExtension.equals(FILE_EXTENSION_XML)) {
            this.m_FileChooser.setFileFilter(this.m_XMLFilter);
        } else if (KOML.isPresent() && this.m_PreferredExtension.equals(".komlkf")) {
            this.m_FileChooser.setFileFilter(this.m_KOMLFilter);
        } else if (XStream.isPresent() && this.m_PreferredExtension.equals(".xstreamkf")) {
            this.m_FileChooser.setFileFilter(this.m_XStreamFilter);
        } else {
            this.m_FileChooser.setFileFilter(this.m_KfFilter);
        }
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_bcSupport.setDesignTime(true);
        this.m_beanLayout.setLayout(null);
        this.m_beanLayout.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (KnowledgeFlowApp.this.m_toolBarBean == null && (me.getModifiers() & 0x10) == 16 && KnowledgeFlowApp.this.m_mode == 0) {
                    BeanInstance bi = BeanInstance.findInstance(me.getPoint());
                    JComponent bc = null;
                    if (bi != null) {
                        bc = (JComponent)bi.getBean();
                    }
                    if (bc != null && bc instanceof Visible) {
                        KnowledgeFlowApp.this.m_editElement = bi;
                        KnowledgeFlowApp.this.m_oldX = me.getX();
                        KnowledgeFlowApp.this.m_oldY = me.getY();
                        KnowledgeFlowApp.this.m_mode = 1;
                    }
                    if (KnowledgeFlowApp.this.m_mode != 1) {
                        KnowledgeFlowApp.this.m_mode = 4;
                        KnowledgeFlowApp.this.m_oldX = me.getX();
                        KnowledgeFlowApp.this.m_oldY = me.getY();
                        KnowledgeFlowApp.this.m_startX = KnowledgeFlowApp.this.m_oldX;
                        KnowledgeFlowApp.this.m_startY = KnowledgeFlowApp.this.m_oldY;
                        Graphics2D gx = (Graphics2D)KnowledgeFlowApp.this.m_beanLayout.getGraphics();
                        gx.setXORMode(Color.white);
                        gx.dispose();
                        KnowledgeFlowApp.this.m_mode = 4;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (KnowledgeFlowApp.this.m_editElement != null && KnowledgeFlowApp.this.m_mode == 1) {
                    KnowledgeFlowApp.this.m_editElement = null;
                    KnowledgeFlowApp.this.revalidate();
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_mode = 0;
                }
                if (KnowledgeFlowApp.this.m_mode == 4) {
                    KnowledgeFlowApp.this.revalidate();
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_mode = 0;
                    KnowledgeFlowApp.this.checkSubFlow(KnowledgeFlowApp.this.m_startX, KnowledgeFlowApp.this.m_startY, me.getX(), me.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                BeanInstance bi;
                block22: {
                    bi = BeanInstance.findInstance(me.getPoint());
                    if (KnowledgeFlowApp.this.m_mode == 3 || KnowledgeFlowApp.this.m_mode == 0) {
                        if (bi != null) {
                            JComponent bc = (JComponent)bi.getBean();
                            if (me.getClickCount() == 2 && !(bc instanceof MetaBean)) {
                                try {
                                    Class<?> custClass = Introspector.getBeanInfo(bc.getClass()).getBeanDescriptor().getCustomizerClass();
                                    if (custClass == null) break block22;
                                    if (bc instanceof BeanCommon) {
                                        if (!((BeanCommon)((Object)bc)).isBusy()) {
                                            KnowledgeFlowApp.this.popupCustomizer(custClass, bc);
                                        }
                                        break block22;
                                    }
                                    KnowledgeFlowApp.this.popupCustomizer(custClass, bc);
                                }
                                catch (IntrospectionException ex) {
                                    ex.printStackTrace();
                                }
                            } else if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                                KnowledgeFlowApp.this.doPopup(me.getPoint(), bi, me.getX(), me.getY());
                            }
                        } else if ((me.getModifiers() & 0x10) != 16 || me.isAltDown()) {
                            int delta = 10;
                            KnowledgeFlowApp.this.deleteConnectionPopup(BeanConnection.getClosestConnections(new Point(me.getX(), me.getY()), delta), me.getX(), me.getY());
                        } else if (KnowledgeFlowApp.this.m_toolBarBean != null) {
                            KnowledgeFlowApp.this.addComponent(me.getX(), me.getY());
                        }
                    }
                }
                if (KnowledgeFlowApp.this.m_mode == 2) {
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    Vector beanInstances = BeanInstance.getBeanInstances();
                    for (int i = 0; i < beanInstances.size(); ++i) {
                        JComponent bean = (JComponent)((BeanInstance)beanInstances.elementAt(i)).getBean();
                        if (!(bean instanceof Visible)) continue;
                        ((Visible)((Object)bean)).getVisual().setDisplayConnectors(false);
                    }
                    if (bi != null) {
                        boolean doConnection = false;
                        if (!(bi.getBean() instanceof BeanCommon)) {
                            doConnection = true;
                        } else if (((BeanCommon)bi.getBean()).connectionAllowed(KnowledgeFlowApp.this.m_sourceEventSetDescriptor)) {
                            doConnection = true;
                        }
                        if (doConnection) {
                            if (bi.getBean() instanceof MetaBean) {
                                BeanConnection.doMetaConnection(KnowledgeFlowApp.this.m_editElement, bi, KnowledgeFlowApp.this.m_sourceEventSetDescriptor, KnowledgeFlowApp.this.m_beanLayout);
                            } else {
                                BeanConnection bc = new BeanConnection(KnowledgeFlowApp.this.m_editElement, bi, KnowledgeFlowApp.this.m_sourceEventSetDescriptor);
                            }
                        }
                        KnowledgeFlowApp.this.m_beanLayout.repaint();
                    }
                    KnowledgeFlowApp.this.m_mode = 0;
                    KnowledgeFlowApp.this.m_editElement = null;
                    KnowledgeFlowApp.this.m_sourceEventSetDescriptor = null;
                }
            }
        });
        this.m_beanLayout.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                if (KnowledgeFlowApp.this.m_editElement != null && KnowledgeFlowApp.this.m_mode == 1) {
                    ImageIcon ic = ((Visible)KnowledgeFlowApp.this.m_editElement.getBean()).getVisual().getStaticIcon();
                    int width = ic.getIconWidth() / 2;
                    int height = ic.getIconHeight() / 2;
                    KnowledgeFlowApp.this.m_editElement.setXY(KnowledgeFlowApp.this.m_oldX - width, KnowledgeFlowApp.this.m_oldY - height);
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_oldX = me.getX();
                    KnowledgeFlowApp.this.m_oldY = me.getY();
                }
                if (KnowledgeFlowApp.this.m_mode == 4) {
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_oldX = me.getX();
                    KnowledgeFlowApp.this.m_oldY = me.getY();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (KnowledgeFlowApp.this.m_mode == 2) {
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.m_oldX = e.getX();
                    KnowledgeFlowApp.this.m_oldY = e.getY();
                }
            }
        });
        String date = new SimpleDateFormat("EEEE, d MMMM yyyy").format(new Date());
        this.m_logPanel.logMessage("Weka Knowledge Flow was written by Mark Hall");
        this.m_logPanel.logMessage("Weka Knowledge Flow");
        this.m_logPanel.logMessage("(c) 2002-" + Copyright.getToYear() + " " + Copyright.getOwner() + ", " + Copyright.getAddress());
        this.m_logPanel.logMessage("web: " + Copyright.getURL());
        this.m_logPanel.logMessage(date);
        this.m_logPanel.statusMessage("[KnowledgeFlow]|Welcome to the Weka Knowledge Flow");
        this.m_logPanel.getStatusTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (KnowledgeFlowApp.this.m_logPanel.getStatusTable().rowAtPoint(e.getPoint()) == 0 && ((e.getModifiers() & 0x10) != 16 || e.isAltDown())) {
                    System.gc();
                    Runtime currR = Runtime.getRuntime();
                    long freeM = currR.freeMemory();
                    long totalM = currR.totalMemory();
                    long maxM = currR.maxMemory();
                    KnowledgeFlowApp.this.m_logPanel.logMessage("[KnowledgeFlow] Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                    KnowledgeFlowApp.this.m_logPanel.statusMessage("[KnowledgeFlow]|Memory (free/total/max.) in bytes: " + String.format("%,d", freeM) + " / " + String.format("%,d", totalM) + " / " + String.format("%,d", maxM));
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setLayout(new BorderLayout());
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Knowledge Flow Layout"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JScrollPane js = new JScrollPane(this.m_beanLayout);
        p1.add((Component)js, "Center");
        js.getVerticalScrollBar().setUnitIncrement(this.m_ScrollBarIncrementLayout);
        js.getHorizontalScrollBar().setUnitIncrement(this.m_ScrollBarIncrementLayout);
        this.setLayout(new BorderLayout());
        this.add((Component)p1, "Center");
        this.m_beanLayout.setSize(this.m_FlowWidth, this.m_FlowHeight);
        Dimension d = this.m_beanLayout.getPreferredSize();
        this.m_beanLayout.setMinimumSize(d);
        this.m_beanLayout.setMaximumSize(d);
        this.m_beanLayout.setPreferredSize(d);
        Dimension d2 = new Dimension(100, 170);
        this.m_logPanel.setPreferredSize(d2);
        this.m_logPanel.setMinimumSize(d2);
        this.add((Component)this.m_logPanel, "South");
        this.setUpToolBars();
        this.loadUserComponents();
    }

    private Image loadImage(String path) {
        Image pic = null;
        URL imageURL = this.getClass().getClassLoader().getResource(path);
        if (imageURL != null) {
            pic = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        return pic;
    }

    private void setUpToolBars() {
        int i;
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new BorderLayout());
        if (this.m_showFileMenu) {
            JToolBar fixedTools = new JToolBar();
            fixedTools.setOrientation(1);
            this.m_saveB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Save24.gif")));
            this.m_saveB.setToolTipText("Save layout");
            this.m_loadB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Open24.gif")));
            this.m_loadB.setToolTipText("Load layout");
            this.m_newB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/New24.gif")));
            this.m_newB.setToolTipText("Clear the layout");
            fixedTools.add(this.m_newB);
            fixedTools.add(this.m_saveB);
            fixedTools.add(this.m_loadB);
            this.m_saveB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.saveLayout();
                }
            });
            this.m_loadB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.m_flowEnvironment = new Environment();
                    KnowledgeFlowApp.this.loadLayout();
                }
            });
            this.m_newB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    KnowledgeFlowApp.this.clearLayout();
                }
            });
            fixedTools.setFloatable(false);
            toolBarPanel.add((Component)fixedTools, "West");
        }
        this.m_stopB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Stop24.gif")));
        this.m_helpB = new JButton(new ImageIcon(this.loadImage("weka/gui/beans/icons/Help24.gif")));
        this.m_stopB.setToolTipText("Stop all execution");
        this.m_helpB.setToolTipText("Display help");
        Image tempI = this.loadImage("weka/gui/beans/icons/Pointer.gif");
        this.m_pointerB = new JToggleButton(new ImageIcon(tempI));
        this.m_pointerB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KnowledgeFlowApp.this.m_toolBarBean = null;
                KnowledgeFlowApp.this.m_mode = 0;
                KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.m_toolBarGroup.add(this.m_pointerB);
        JToolBar fixedTools2 = new JToolBar();
        fixedTools2.setOrientation(1);
        fixedTools2.setFloatable(false);
        fixedTools2.add(this.m_pointerB);
        fixedTools2.add(this.m_helpB);
        fixedTools2.add(this.m_stopB);
        this.m_helpB.setSize(this.m_pointerB.getSize().width, this.m_pointerB.getSize().height);
        toolBarPanel.add((Component)fixedTools2, "East");
        this.m_stopB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KnowledgeFlowApp.this.m_logPanel.statusMessage("[KnowledgeFlow]|Attempting to stop all components...");
                KnowledgeFlowApp.this.stopFlow();
                KnowledgeFlowApp.this.m_logPanel.statusMessage("[KnowledgeFlow]|OK.");
            }
        });
        this.m_helpB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KnowledgeFlowApp.this.popupHelp();
            }
        });
        boolean STANDARD_TOOLBAR = false;
        boolean WEKAWRAPPER_TOOLBAR = true;
        boolean toolBarType = false;
        for (i = 0; i < TOOLBARS.size(); ++i) {
            JPanel tempBean;
            Hashtable hpps;
            HierarchyPropertyParser hpp;
            String rootPackage;
            String tempBeanCompName;
            Box singletonHolderPanel;
            String tempBarName;
            Vector tempBarSpecs;
            block18: {
                tempBarSpecs = (Vector)TOOLBARS.elementAt(i);
                tempBarName = (String)tempBarSpecs.elementAt(0);
                singletonHolderPanel = null;
                tempBeanCompName = (String)tempBarSpecs.elementAt(1);
                rootPackage = "";
                hpp = null;
                hpps = null;
                if (tempBeanCompName.compareTo("null") != 0) {
                    tempBean = null;
                    toolBarType = true;
                    rootPackage = (String)tempBarSpecs.elementAt(2);
                    hpps = (Hashtable)tempBarSpecs.elementAt(3);
                    try {
                        Beans.instantiate(this.getClass().getClassLoader(), tempBeanCompName);
                        break block18;
                    }
                    catch (Exception ex) {
                        System.err.println("[KnowledgeFlow] Failed to instantiate: " + tempBeanCompName);
                        break;
                    }
                }
                toolBarType = false;
            }
            JToolBar tempToolBar = new JToolBar();
            int z = 2;
            if (toolBarType) {
                Enumeration enm = hpps.keys();
                while (enm.hasMoreElements()) {
                    String root = (String)enm.nextElement();
                    String userPrefix = "";
                    hpp = (HierarchyPropertyParser)hpps.get(root);
                    if (!hpp.goTo(rootPackage)) {
                        System.out.println("[KnowledgeFlow] Processing user package... ");
                        userPrefix = root + ".";
                    }
                    String[] primaryPackages = hpp.childrenValues();
                    for (int kk = 0; kk < primaryPackages.length; ++kk) {
                        hpp.goToChild(primaryPackages[kk]);
                        if (hpp.isLeafReached()) {
                            String algName;
                            if (singletonHolderPanel == null) {
                                singletonHolderPanel = Box.createHorizontalBox();
                                singletonHolderPanel.setBorder(BorderFactory.createTitledBorder(tempBarName));
                            }
                            if ((tempBean = this.instantiateToolBarBean(true, tempBeanCompName, algName = hpp.fullValue())) != null) {
                                singletonHolderPanel.add(tempBean);
                            }
                            hpp.goToParent();
                            continue;
                        }
                        Box holderPanel = Box.createHorizontalBox();
                        holderPanel.setBorder(BorderFactory.createTitledBorder(userPrefix + primaryPackages[kk]));
                        this.processPackage(holderPanel, tempBeanCompName, hpp);
                        tempToolBar.add(holderPanel);
                    }
                    if (singletonHolderPanel == null) continue;
                    tempToolBar.add(singletonHolderPanel);
                    singletonHolderPanel = null;
                }
            } else {
                Box holderPanel = Box.createHorizontalBox();
                holderPanel.setBorder(BorderFactory.createTitledBorder(tempBarName));
                for (int j = z; j < tempBarSpecs.size(); ++j) {
                    tempBean = null;
                    tempBean = this.instantiateToolBarBean(toolBarType, tempBeanCompName = (String)tempBarSpecs.elementAt(j), "");
                    if (tempBean == null) continue;
                    holderPanel.add(tempBean);
                }
                tempToolBar.add(holderPanel);
            }
            JScrollPane tempJScrollPane = this.createScrollPaneForToolBar(tempToolBar);
            this.m_toolBars.addTab(tempBarName, null, tempJScrollPane, tempBarName);
        }
        if (BEAN_PLUGINS_PROPERTIES != null && BEAN_PLUGINS_PROPERTIES.size() > 0) {
            for (i = 0; i < BEAN_PLUGINS_PROPERTIES.size(); ++i) {
                Properties tempP = BEAN_PLUGINS_PROPERTIES.get(i);
                JPanel tempBean = null;
                String components = tempP.getProperty("weka.gui.beans.KnowledgeFlow.Plugins");
                StringTokenizer st2 = new StringTokenizer(components, ", ");
                while (st2.hasMoreTokens()) {
                    String tempBeanCompName = st2.nextToken().trim();
                    tempBean = this.instantiateToolBarBean(false, tempBeanCompName, "");
                    if (this.m_pluginsToolBar == null) {
                        this.setUpPluginsToolBar();
                    }
                    this.m_pluginsBoxPanel.add(tempBean);
                }
            }
        }
        toolBarPanel.add((Component)this.m_toolBars, "Center");
        this.add((Component)toolBarPanel, "North");
    }

    private void stopFlow() {
        Vector components = BeanInstance.getBeanInstances();
        for (int i = 0; i < components.size(); ++i) {
            Object temp = ((BeanInstance)components.elementAt(i)).getBean();
            if (!(temp instanceof BeanCommon)) continue;
            ((BeanCommon)temp).stop();
        }
    }

    private JScrollPane createScrollPaneForToolBar(JToolBar tb) {
        JScrollPane tempJScrollPane = new JScrollPane(tb, 21, 32);
        Dimension d = tb.getPreferredSize();
        tempJScrollPane.setMinimumSize(new Dimension((int)d.getWidth(), (int)(d.getHeight() + 15.0)));
        tempJScrollPane.setPreferredSize(new Dimension((int)d.getWidth(), (int)(d.getHeight() + 15.0)));
        tempJScrollPane.getHorizontalScrollBar().setUnitIncrement(this.m_ScrollBarIncrementComponents);
        return tempJScrollPane;
    }

    private void processPackage(JComponent holderPanel, String tempBeanCompName, HierarchyPropertyParser hpp) {
        if (hpp.isLeafReached()) {
            String algName = hpp.fullValue();
            JPanel tempBean = this.instantiateToolBarBean(true, tempBeanCompName, algName);
            if (tempBean != null) {
                holderPanel.add(tempBean);
            }
            hpp.goToParent();
            return;
        }
        String[] children = hpp.childrenValues();
        for (int i = 0; i < children.length; ++i) {
            hpp.goToChild(children[i]);
            this.processPackage(holderPanel, tempBeanCompName, hpp);
        }
        hpp.goToParent();
    }

    private JPanel instantiateToolBarBean(boolean wekawrapper, String tempBeanCompName, String algName) {
        Object tempBean;
        if (wekawrapper) {
            try {
                tempBean = Beans.instantiate(this.getClass().getClassLoader(), tempBeanCompName);
            }
            catch (Exception ex) {
                System.err.println("[KnowledgeFlow] Failed to instantiate :" + tempBeanCompName + "KnowledgeFlowApp.instantiateToolBarBean()");
                return null;
            }
            if (tempBean instanceof WekaWrapper) {
                Class<?> c = null;
                try {
                    c = Class.forName(algName);
                }
                catch (Exception ex) {
                    System.err.println("[KnowledgeFlow] Can't find class called: " + algName);
                    return null;
                }
                try {
                    Object o = c.newInstance();
                    ((WekaWrapper)tempBean).setWrappedAlgorithm(o);
                }
                catch (Exception ex) {
                    System.err.println("[KnowledgeFlow] Failed to configure " + tempBeanCompName + " with " + algName);
                    return null;
                }
            }
        } else {
            try {
                tempBean = Beans.instantiate(this.getClass().getClassLoader(), tempBeanCompName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("[KnowledgeFlow] Failed to instantiate :" + tempBeanCompName + "KnowledgeFlowApp.setUpToolBars()");
                return null;
            }
        }
        if (tempBean instanceof BeanContextChild) {
            this.m_bcSupport.add(tempBean);
        }
        if (tempBean instanceof Visible) {
            ((Visible)tempBean).getVisual().scale(3);
        }
        return this.makeHolderPanelForToolBarBean(tempBeanCompName, tempBean, wekawrapper, algName, false);
    }

    private JPanel instantiateToolBarMetaBean(MetaBean bean) {
        bean.getVisual().removePropertyChangeListener(this);
        bean.removePropertyChangeListenersSubFlow(this);
        MetaBean copy = null;
        try {
            SerializedObject so = new SerializedObject(bean);
            copy = (MetaBean)so.getObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        bean.getVisual().addPropertyChangeListener(this);
        bean.addPropertyChangeListenersSubFlow(this);
        String displayName = "";
        if (copy instanceof Visible) {
            ((Visible)copy).getVisual().scale(3);
            displayName = ((Visible)copy).getVisual().getText();
        }
        return this.makeHolderPanelForToolBarBean(displayName, copy, false, null, true);
    }

    private JPanel makeHolderPanelForToolBarBean(final String tempName, Object tempBean, boolean wekawrapper, String algName, final boolean metabean) {
        JToggleButton tempButton;
        final JPanel tempP = new JPanel();
        JLabel tempL = new JLabel();
        tempL.setFont(new Font(null, 0, 9));
        String labelName = wekawrapper ? algName : tempName;
        labelName = labelName.substring(labelName.lastIndexOf(46) + 1, labelName.length());
        tempL.setText(" " + labelName + " ");
        tempL.setHorizontalAlignment(0);
        tempP.setLayout(new BorderLayout());
        if (tempBean instanceof Visible) {
            BeanVisual bv = ((Visible)tempBean).getVisual();
            tempButton = new JToggleButton(bv.getStaticIcon());
            int width = bv.getStaticIcon().getIconWidth();
            int height = bv.getStaticIcon().getIconHeight();
            JPanel labelPanel = this.multiLineLabelPanel(labelName, width);
            tempP.add((Component)labelPanel, "South");
        } else {
            tempButton = new JToggleButton();
            tempP.add((Component)tempL, "South");
        }
        tempP.add((Component)tempButton, "North");
        this.m_toolBarGroup.add(tempButton);
        final Object tempBN = tempBean;
        final JToggleButton fButton = tempButton;
        tempButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean changeCursor = true;
                try {
                    KnowledgeFlowApp.this.m_toolBarBean = null;
                    if (metabean) {
                        if ((e.getModifiers() & 1) != 0) {
                            changeCursor = false;
                            KnowledgeFlowApp.this.m_toolBarGroup.remove(fButton);
                            KnowledgeFlowApp.this.m_userBoxPanel.remove(tempP);
                            KnowledgeFlowApp.this.m_userBoxPanel.revalidate();
                            KnowledgeFlowApp.this.m_userComponents.remove(tempBN);
                            if (KnowledgeFlowApp.this.m_firstUserComponentOpp) {
                                KnowledgeFlowApp.this.installWindowListenerForSavingUserBeans();
                                KnowledgeFlowApp.this.m_firstUserComponentOpp = false;
                            }
                            if (KnowledgeFlowApp.this.m_userComponents.size() == 0) {
                                KnowledgeFlowApp.this.m_toolBars.removeTabAt(KnowledgeFlowApp.this.m_toolBars.getTabCount() - 1);
                                KnowledgeFlowApp.this.m_userToolBar = null;
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                        } else {
                            SerializedObject so = new SerializedObject(tempBN);
                            MetaBean copy = (MetaBean)so.getObject();
                            copy.addPropertyChangeListenersSubFlow(KnowledgeFlowApp.this);
                            KnowledgeFlowApp.this.m_toolBarBean = copy;
                        }
                    } else {
                        KnowledgeFlowApp.this.m_toolBarBean = Beans.instantiate(this.getClass().getClassLoader(), tempName);
                    }
                    if (KnowledgeFlowApp.this.m_toolBarBean instanceof WekaWrapper) {
                        Object wrappedAlg = ((WekaWrapper)tempBN).getWrappedAlgorithm();
                        ((WekaWrapper)KnowledgeFlowApp.this.m_toolBarBean).setWrappedAlgorithm(wrappedAlg.getClass().newInstance());
                    }
                    if (changeCursor) {
                        KnowledgeFlowApp.this.setCursor(Cursor.getPredefinedCursor(1));
                        KnowledgeFlowApp.this.m_mode = 3;
                    }
                }
                catch (Exception ex) {
                    System.err.println("[KnowledgeFlow] Problem adding bean to data flow layout");
                    ex.printStackTrace();
                }
                KnowledgeFlowApp.this.notifyIsDirty();
            }
        });
        if (tempBean instanceof MetaBean) {
            tempButton.setToolTipText("Hold down shift and click to remove");
            this.m_userComponents.add(tempBean);
        } else {
            String summary = KnowledgeFlowApp.getGlobalInfo(tempBean);
            if (summary != null) {
                int ci = summary.indexOf(46);
                if (ci != -1) {
                    summary = summary.substring(0, ci + 1);
                }
                tempButton.setToolTipText(summary);
            }
        }
        return tempP;
    }

    private JPanel multiLineLabelPanel(String sourceL, int splitWidth) {
        JPanel jp = new JPanel();
        Vector<String> v = new Vector<String>();
        int labelWidth = this.m_fontM.stringWidth(sourceL);
        if (labelWidth < splitWidth) {
            v.addElement(sourceL);
        } else {
            int mid = sourceL.length() / 2;
            int closest = sourceL.length();
            int closestI = -1;
            for (int i = 0; i < sourceL.length(); ++i) {
                if (sourceL.charAt(i) >= 'a' || Math.abs(mid - i) >= closest) continue;
                closest = Math.abs(mid - i);
                closestI = i;
            }
            if (closestI != -1) {
                String left = sourceL.substring(0, closestI);
                String right = sourceL.substring(closestI, sourceL.length());
                if (left.length() > 1 && right.length() > 1) {
                    v.addElement(left);
                    v.addElement(right);
                } else {
                    v.addElement(sourceL);
                }
            } else {
                v.addElement(sourceL);
            }
        }
        jp.setLayout(new GridLayout(v.size(), 1));
        for (int i = 0; i < v.size(); ++i) {
            JLabel temp = new JLabel();
            temp.setFont(new Font(null, 0, 9));
            temp.setText(" " + (String)v.elementAt(i) + " ");
            temp.setHorizontalAlignment(0);
            jp.add(temp);
        }
        return jp;
    }

    private void setUpUserToolBar() {
        this.m_userBoxPanel = Box.createHorizontalBox();
        this.m_userBoxPanel.setBorder(BorderFactory.createTitledBorder("User"));
        this.m_userToolBar = new JToolBar();
        this.m_userToolBar.add(this.m_userBoxPanel);
        JScrollPane tempJScrollPane = this.createScrollPaneForToolBar(this.m_userToolBar);
        this.m_toolBars.addTab("User", null, tempJScrollPane, "User created components");
    }

    private void setUpPluginsToolBar() {
        this.m_pluginsBoxPanel = Box.createHorizontalBox();
        this.m_pluginsBoxPanel.setBorder(BorderFactory.createTitledBorder("Plugins"));
        this.m_pluginsToolBar = new JToolBar();
        this.m_pluginsToolBar.add(this.m_pluginsBoxPanel);
        JScrollPane tempJScrollPane = this.createScrollPaneForToolBar(this.m_pluginsToolBar);
        this.m_toolBars.addTab("Plugins", null, tempJScrollPane, "Plugin components");
    }

    private void popupHelp() {
        final JButton tempB = this.m_helpB;
        try {
            String line;
            tempB.setEnabled(false);
            InputStream inR = this.getClass().getClassLoader().getResourceAsStream("weka/gui/beans/README_KnowledgeFlow");
            StringBuffer helpHolder = new StringBuffer();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inR));
            while ((line = lnr.readLine()) != null) {
                helpHolder.append(line + "\n");
            }
            lnr.close();
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            JTextArea ta = new JTextArea(helpHolder.toString());
            ta.setFont(new Font("Monospaced", 0, 12));
            ta.setEditable(false);
            JScrollPane sp = new JScrollPane(ta);
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    tempB.setEnabled(true);
                    jf.dispose();
                }
            });
            jf.setSize(600, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            tempB.setEnabled(true);
        }
    }

    public void clearLayout() {
        this.stopFlow();
        BeanInstance.reset(this.m_beanLayout);
        BeanConnection.reset();
        this.m_beanLayout.revalidate();
        this.m_beanLayout.repaint();
        this.m_logPanel.clearStatus();
        this.m_logPanel.statusMessage("[KnowledgeFlow]|Welcome to the Weka Knowledge Flow");
    }

    private void doPopup(Point pt, final BeanInstance bi, int x, int y) {
        final JComponent bc = (JComponent)bi.getBean();
        final int xx = x;
        final int yy = y;
        int menuItemCount = 0;
        PopupMenu beanContextMenu = new PopupMenu();
        MenuItem edit = new MenuItem("Edit:");
        edit.setEnabled(false);
        beanContextMenu.insert(edit, menuItemCount);
        ++menuItemCount;
        if (bc instanceof MetaBean) {
            MenuItem ungroupItem = new MenuItem("Ungroup");
            ungroupItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i;
                    bi.removeBean(KnowledgeFlowApp.this.m_beanLayout);
                    Vector group = ((MetaBean)bc).getBeansInSubFlow();
                    Vector associatedConnections = ((MetaBean)bc).getAssociatedConnections();
                    ((MetaBean)bc).restoreBeans();
                    for (i = 0; i < group.size(); ++i) {
                        BeanInstance tbi = (BeanInstance)group.elementAt(i);
                        KnowledgeFlowApp.this.addComponent(tbi, false);
                        tbi.addBean(KnowledgeFlowApp.this.m_beanLayout);
                    }
                    for (i = 0; i < associatedConnections.size(); ++i) {
                        BeanConnection tbc = (BeanConnection)associatedConnections.elementAt(i);
                        tbc.setHidden(false);
                    }
                    KnowledgeFlowApp.this.m_beanLayout.repaint();
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            });
            beanContextMenu.add(ungroupItem);
            ++menuItemCount;
            MenuItem addToUserTabItem = new MenuItem("Add to user tab");
            addToUserTabItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KnowledgeFlowApp.this.addToUserToolBar((MetaBean)bi.getBean(), true);
                    KnowledgeFlowApp.this.notifyIsDirty();
                }
            });
            beanContextMenu.add(addToUserTabItem);
            ++menuItemCount;
        }
        MenuItem deleteItem = new MenuItem("Delete");
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanConnection.removeConnections(bi);
                bi.removeBean(KnowledgeFlowApp.this.m_beanLayout);
                if (bc instanceof BeanCommon) {
                    String key = ((BeanCommon)((Object)bc)).getCustomName() + "$" + bc.hashCode();
                    KnowledgeFlowApp.this.m_logPanel.statusMessage(key + "|remove");
                }
                KnowledgeFlowApp.this.revalidate();
                KnowledgeFlowApp.this.notifyIsDirty();
            }
        });
        if (bc instanceof BeanCommon && ((BeanCommon)((Object)bc)).isBusy()) {
            deleteItem.setEnabled(false);
        }
        beanContextMenu.add(deleteItem);
        ++menuItemCount;
        if (bc instanceof BeanCommon) {
            MenuItem nameItem = new MenuItem("Set name");
            nameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String oldName = ((BeanCommon)((Object)bc)).getCustomName();
                    String name = JOptionPane.showInputDialog(KnowledgeFlowApp.this, "Enter a name for this component", oldName);
                    if (name != null) {
                        ((BeanCommon)((Object)bc)).setCustomName(name);
                    }
                }
            });
            if (bc instanceof BeanCommon && ((BeanCommon)((Object)bc)).isBusy()) {
                nameItem.setEnabled(false);
            }
            beanContextMenu.add(nameItem);
            ++menuItemCount;
        }
        try {
            Vector compInfo = new Vector(1);
            Vector associatedBeans = null;
            Vector outputBeans = null;
            Vector compInfoOutputs = null;
            if (bc instanceof MetaBean) {
                compInfo = ((MetaBean)bc).getBeanInfoSubFlow();
                associatedBeans = ((MetaBean)bc).getBeansInSubFlow();
                outputBeans = ((MetaBean)bc).getBeansInOutputs();
                compInfoOutputs = ((MetaBean)bc).getBeanInfoOutputs();
            } else {
                compInfo.add(Introspector.getBeanInfo(bc.getClass()));
                compInfoOutputs = compInfo;
            }
            final Vector tempAssociatedBeans = associatedBeans;
            if (compInfo == null) {
                System.err.println("[KnowledgeFlow] Error in doPopup()");
            } else {
                for (int zz = 0; zz < compInfo.size(); ++zz) {
                    final int tt = zz;
                    final Class<?> custClass = ((BeanInfo)compInfo.elementAt(zz)).getBeanDescriptor().getCustomizerClass();
                    if (custClass != null) {
                        MenuItem custItem = null;
                        boolean customizationEnabled = true;
                        if (!(bc instanceof MetaBean)) {
                            custItem = new MenuItem("Configure...");
                            if (bc instanceof BeanCommon) {
                                customizationEnabled = !((BeanCommon)((Object)bc)).isBusy();
                            }
                        } else {
                            String custName = custClass.getName();
                            BeanInstance tbi = (BeanInstance)associatedBeans.elementAt(zz);
                            if (tbi.getBean() instanceof BeanCommon) {
                                custName = ((BeanCommon)tbi.getBean()).getCustomName();
                            } else {
                                custName = tbi.getBean() instanceof WekaWrapper ? ((WekaWrapper)tbi.getBean()).getWrappedAlgorithm().getClass().getName() : custName.substring(0, custName.indexOf("Customizer"));
                                custName = custName.substring(custName.lastIndexOf(46) + 1, custName.length());
                            }
                            custItem = new MenuItem("Configure: " + custName);
                            if (tbi.getBean() instanceof BeanCommon) {
                                customizationEnabled = !((BeanCommon)tbi.getBean()).isBusy();
                            }
                        }
                        custItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (bc instanceof MetaBean) {
                                    KnowledgeFlowApp.this.popupCustomizer(custClass, (JComponent)((BeanInstance)tempAssociatedBeans.elementAt(tt)).getBean());
                                } else {
                                    KnowledgeFlowApp.this.popupCustomizer(custClass, bc);
                                }
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                        });
                        custItem.setEnabled(customizationEnabled);
                        beanContextMenu.add(custItem);
                        ++menuItemCount;
                        continue;
                    }
                    System.err.println("[KnowledgeFlow] No customizer class");
                }
                Vector<EventSetDescriptor[]> esdV = new Vector<EventSetDescriptor[]>();
                for (int i = 0; i < compInfo.size(); ++i) {
                    EventSetDescriptor[] temp = ((BeanInfo)compInfo.elementAt(i)).getEventSetDescriptors();
                    if (temp == null || temp.length <= 0) continue;
                    esdV.add(temp);
                }
                if (esdV.size() > 0) {
                    MenuItem connections = new MenuItem("Connections:");
                    connections.setEnabled(false);
                    beanContextMenu.insert(connections, menuItemCount);
                    ++menuItemCount;
                }
                final Vector finalOutputs = associatedBeans;
                for (int j = 0; j < esdV.size(); ++j) {
                    final int fj = j;
                    String sourceBeanName = "";
                    if (bc instanceof MetaBean) {
                        Object sourceBean = ((BeanInstance)associatedBeans.elementAt(j)).getBean();
                        if (sourceBean instanceof BeanCommon) {
                            sourceBeanName = ((BeanCommon)sourceBean).getCustomName();
                        } else {
                            sourceBeanName = sourceBean instanceof WekaWrapper ? ((WekaWrapper)sourceBean).getWrappedAlgorithm().getClass().getName() : sourceBean.getClass().getName();
                            sourceBeanName = sourceBeanName.substring(sourceBeanName.lastIndexOf(46) + 1, sourceBeanName.length());
                        }
                        sourceBeanName = sourceBeanName + ": ";
                    }
                    EventSetDescriptor[] esds = (EventSetDescriptor[])esdV.elementAt(j);
                    for (int i = 0; i < esds.length; ++i) {
                        MenuItem evntItem = new MenuItem(sourceBeanName + esds[i].getName());
                        final EventSetDescriptor esd = esds[i];
                        boolean ok = true;
                        if (bc instanceof EventConstraints) {
                            ok = ((EventConstraints)((Object)bc)).eventGeneratable(esd.getName());
                        }
                        if (ok) {
                            evntItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    KnowledgeFlowApp.this.connectComponents(esd, bc instanceof MetaBean ? (BeanInstance)finalOutputs.elementAt(fj) : bi, xx, yy);
                                    KnowledgeFlowApp.this.notifyIsDirty();
                                }
                            });
                        } else {
                            evntItem.setEnabled(false);
                        }
                        beanContextMenu.add(evntItem);
                        ++menuItemCount;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
        if (bc instanceof UserRequestAcceptor || bc instanceof Startable) {
            String tempS;
            Enumeration req = null;
            if (bc instanceof UserRequestAcceptor) {
                req = ((UserRequestAcceptor)((Object)bc)).enumerateRequests();
            }
            if (bc instanceof Startable || req != null && req.hasMoreElements()) {
                MenuItem actions2 = new MenuItem("Actions:");
                actions2.setEnabled(false);
                beanContextMenu.insert(actions2, menuItemCount);
                ++menuItemCount;
            }
            if (bc instanceof Startable) {
                tempS = ((Startable)((Object)bc)).getStartMessage();
                this.insertUserOrStartableMenuItem(bc, true, tempS, beanContextMenu);
            }
            while (req != null && req.hasMoreElements()) {
                tempS = (String)req.nextElement();
                this.insertUserOrStartableMenuItem(bc, false, tempS, beanContextMenu);
                ++menuItemCount;
            }
        }
        if (menuItemCount > 0) {
            this.m_beanLayout.add(beanContextMenu);
            beanContextMenu.show(this.m_beanLayout, x, y);
        }
    }

    private void insertUserOrStartableMenuItem(final JComponent bc, final boolean startable, String tempS, PopupMenu beanContextMenu) {
        boolean disabled = false;
        boolean confirmRequest = false;
        if (tempS.charAt(0) == '$') {
            tempS = tempS.substring(1, tempS.length());
            disabled = true;
        }
        if (tempS.charAt(0) == '?') {
            tempS = tempS.substring(1, tempS.length());
            confirmRequest = true;
        }
        final String tempS2 = tempS;
        MenuItem custItem = new MenuItem(tempS2);
        if (confirmRequest) {
            custItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(KnowledgeFlowApp.this, tempS2, "Confirm action", 0);
                    if (result == 0) {
                        Thread startPointThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    if (startable) {
                                        ((Startable)((Object)bc)).start();
                                    } else if (bc instanceof UserRequestAcceptor) {
                                        ((UserRequestAcceptor)((Object)bc)).performRequest(tempS2);
                                    }
                                    KnowledgeFlowApp.this.notifyIsDirty();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        };
                        startPointThread.setPriority(1);
                        startPointThread.start();
                    }
                }
            });
        } else {
            custItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread startPointThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                if (startable) {
                                    ((Startable)((Object)bc)).start();
                                } else if (bc instanceof UserRequestAcceptor) {
                                    ((UserRequestAcceptor)((Object)bc)).performRequest(tempS2);
                                }
                                KnowledgeFlowApp.this.notifyIsDirty();
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    };
                    startPointThread.setPriority(1);
                    startPointThread.start();
                }
            });
        }
        if (disabled) {
            custItem.setEnabled(false);
        }
        beanContextMenu.add(custItem);
    }

    private void popupCustomizer(Class custClass, JComponent bc) {
        try {
            final Object customizer = custClass.newInstance();
            if (customizer instanceof EnvironmentHandler) {
                ((EnvironmentHandler)customizer).setEnvironment(this.m_flowEnvironment);
            }
            ((Customizer)customizer).setObject(bc);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)((JComponent)customizer), "Center");
            if (customizer instanceof CustomizerCloseRequester) {
                ((CustomizerCloseRequester)customizer).setParentFrame(jf);
            }
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (customizer instanceof CustomizerClosingListener) {
                        ((CustomizerClosingListener)customizer).customizerClosing();
                    }
                    jf.dispose();
                }
            });
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addToUserToolBar(MetaBean bean, boolean installListener) {
        BeanConnection tempC;
        int j;
        Serializable temp;
        int i;
        if (this.m_userToolBar == null) {
            this.setUpUserToolBar();
        }
        Vector<BeanConnection> tempRemovedConnections = new Vector<BeanConnection>();
        Vector allConnections = BeanConnection.getConnections();
        Vector inputs = bean.getInputs();
        Vector outputs = bean.getOutputs();
        Vector allComps = bean.getSubFlow();
        for (i = 0; i < inputs.size(); ++i) {
            temp = (BeanInstance)inputs.elementAt(i);
            for (j = 0; j < allConnections.size(); ++j) {
                tempC = (BeanConnection)allConnections.elementAt(j);
                if (tempC.getTarget() == temp) {
                    tempRemovedConnections.add(tempC);
                }
                if (tempC.getSource() != temp || bean.subFlowContains(tempC.getTarget())) continue;
                tempRemovedConnections.add(tempC);
            }
        }
        for (i = 0; i < outputs.size(); ++i) {
            temp = (BeanInstance)outputs.elementAt(i);
            for (j = 0; j < allConnections.size(); ++j) {
                tempC = (BeanConnection)allConnections.elementAt(j);
                if (tempC.getSource() != temp) continue;
                tempRemovedConnections.add(tempC);
            }
        }
        for (i = 0; i < tempRemovedConnections.size(); ++i) {
            temp = (BeanConnection)tempRemovedConnections.elementAt(i);
            ((BeanConnection)temp).remove();
        }
        JPanel tempUser = this.instantiateToolBarMetaBean(bean);
        this.m_userBoxPanel.add(tempUser);
        if (installListener && this.m_firstUserComponentOpp) {
            try {
                this.installWindowListenerForSavingUserBeans();
                this.m_firstUserComponentOpp = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (int i2 = 0; i2 < tempRemovedConnections.size(); ++i2) {
            BeanConnection temp2 = (BeanConnection)tempRemovedConnections.elementAt(i2);
            BeanConnection newC = new BeanConnection(temp2.getSource(), temp2.getTarget(), temp2.getSourceEventSetDescriptor());
        }
    }

    private void deleteConnectionPopup(Vector closestConnections, int x, int y) {
        if (closestConnections.size() > 0) {
            int menuItemCount = 0;
            PopupMenu deleteConnectionMenu = new PopupMenu();
            MenuItem deleteConnection = new MenuItem("Delete Connection:");
            deleteConnection.setEnabled(false);
            deleteConnectionMenu.insert(deleteConnection, menuItemCount);
            ++menuItemCount;
            for (int i = 0; i < closestConnections.size(); ++i) {
                final BeanConnection bc = (BeanConnection)closestConnections.elementAt(i);
                String connName = bc.getSourceEventSetDescriptor().getName();
                String targetName = "";
                if (bc.getTarget().getBean() instanceof BeanCommon) {
                    targetName = ((BeanCommon)bc.getTarget().getBean()).getCustomName();
                } else {
                    targetName = bc.getTarget().getBean().getClass().getName();
                    targetName = targetName.substring(targetName.lastIndexOf(46) + 1, targetName.length());
                }
                MenuItem deleteItem = new MenuItem(connName + "-->" + targetName);
                deleteItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        bc.remove();
                        KnowledgeFlowApp.this.m_beanLayout.revalidate();
                        KnowledgeFlowApp.this.m_beanLayout.repaint();
                        KnowledgeFlowApp.this.notifyIsDirty();
                    }
                });
                deleteConnectionMenu.add(deleteItem);
                ++menuItemCount;
            }
            this.m_beanLayout.add(deleteConnectionMenu);
            deleteConnectionMenu.show(this.m_beanLayout, x, y);
        }
    }

    private void connectComponents(EventSetDescriptor esd, BeanInstance bi, int x, int y) {
        this.m_sourceEventSetDescriptor = esd;
        Class<?> listenerClass = esd.getListenerType();
        JComponent source = (JComponent)bi.getBean();
        int targetCount = 0;
        Vector beanInstances = BeanInstance.getBeanInstances();
        for (int i = 0; i < beanInstances.size(); ++i) {
            JComponent bean = (JComponent)((BeanInstance)beanInstances.elementAt(i)).getBean();
            boolean connectable = false;
            boolean canContinue = false;
            if (bean != source) {
                if (bean instanceof MetaBean) {
                    if (((MetaBean)bean).canAcceptConnection(listenerClass)) {
                        canContinue = true;
                    }
                } else if (listenerClass.isInstance(bean) && bean != source) {
                    canContinue = true;
                }
            }
            if (!canContinue) continue;
            if (!(bean instanceof BeanCommon)) {
                connectable = true;
            } else if (((BeanCommon)((Object)bean)).connectionAllowed(esd)) {
                connectable = true;
            }
            if (!connectable || !(bean instanceof Visible)) continue;
            ++targetCount;
            ((Visible)((Object)bean)).getVisual().setDisplayConnectors(true);
        }
        if (targetCount > 0) {
            if (source instanceof Visible) {
                ((Visible)((Object)source)).getVisual().setDisplayConnectors(true);
            }
            this.m_editElement = bi;
            Point closest = ((Visible)((Object)source)).getVisual().getClosestConnectorPoint(new Point(x, y));
            this.m_startX = (int)closest.getX();
            this.m_startY = (int)closest.getY();
            this.m_oldX = this.m_startX;
            this.m_oldY = this.m_startY;
            Graphics2D gx = (Graphics2D)this.m_beanLayout.getGraphics();
            gx.setXORMode(Color.white);
            gx.drawLine(this.m_startX, this.m_startY, this.m_startX, this.m_startY);
            gx.dispose();
            this.m_mode = 2;
        }
    }

    private void addComponent(BeanInstance comp, boolean repaint) {
        if (comp.getBean() instanceof Visible) {
            ((Visible)comp.getBean()).getVisual().addPropertyChangeListener(this);
        }
        if (comp.getBean() instanceof BeanCommon) {
            ((BeanCommon)comp.getBean()).setLog(this.m_logPanel);
        }
        if (comp.getBean() instanceof MetaBean) {
            int i;
            Vector list = ((MetaBean)comp.getBean()).getInputs();
            for (i = 0; i < list.size(); ++i) {
                ((BeanInstance)list.get(i)).setX(comp.getX());
                ((BeanInstance)list.get(i)).setY(comp.getY());
            }
            list = ((MetaBean)comp.getBean()).getOutputs();
            for (i = 0; i < list.size(); ++i) {
                ((BeanInstance)list.get(i)).setX(comp.getX());
                ((BeanInstance)list.get(i)).setY(comp.getY());
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (repaint) {
            this.m_beanLayout.repaint();
        }
        this.m_pointerB.setSelected(true);
        this.m_mode = 0;
    }

    private void addComponent(int x, int y) {
        if (this.m_toolBarBean instanceof MetaBean) {
            Vector associatedConnections = ((MetaBean)this.m_toolBarBean).getAssociatedConnections();
            BeanConnection.getConnections().addAll(associatedConnections);
        }
        if (this.m_toolBarBean instanceof BeanContextChild) {
            this.m_bcSupport.add(this.m_toolBarBean);
        }
        BeanInstance bi = new BeanInstance((JComponent)this.m_beanLayout, this.m_toolBarBean, x, y);
        this.m_toolBarBean = null;
        this.addComponent(bi, true);
    }

    private void checkSubFlow(int startX, int startY, int endX, int endY) {
        BeanInstance temp;
        int i;
        Rectangle r = new Rectangle(startX < endX ? startX : endX, startY < endY ? startY : endY, Math.abs(startX - endX), Math.abs(startY - endY));
        Vector selected = BeanInstance.findInstances(r);
        Vector inputs = BeanConnection.inputs(selected);
        Vector outputs = BeanConnection.outputs(selected);
        if (inputs.size() == 0 || outputs.size() == 0) {
            return;
        }
        for (i = 0; i < selected.size(); ++i) {
            temp = (BeanInstance)selected.elementAt(i);
            if (!(temp.getBean() instanceof MetaBean)) continue;
            return;
        }
        for (i = 0; i < selected.size(); ++i) {
            temp = (BeanInstance)selected.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true);
        }
        for (i = 0; i < inputs.size(); ++i) {
            temp = (BeanInstance)inputs.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true, Color.red);
        }
        for (i = 0; i < outputs.size(); ++i) {
            temp = (BeanInstance)outputs.elementAt(i);
            if (!(temp.getBean() instanceof Visible)) continue;
            ((Visible)temp.getBean()).getVisual().setDisplayConnectors(true, Color.green);
        }
        BufferedImage subFlowPreview = null;
        try {
            subFlowPreview = KnowledgeFlowApp.createImage(this.m_beanLayout, r);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        int result = JOptionPane.showConfirmDialog(this, "Group this sub-flow?", "Group Components", 0);
        if (result == 0) {
            Vector associatedConnections = BeanConnection.associatedConnections(selected);
            String name = JOptionPane.showInputDialog(this, "Enter a name for this group", "MyGroup");
            if (name != null) {
                Serializable temp2;
                int i2;
                MetaBean group = new MetaBean();
                group.setSubFlow(selected);
                group.setAssociatedConnections(associatedConnections);
                group.setInputs(inputs);
                group.setOutputs(outputs);
                group.setSubFlowPreview(new ImageIcon(subFlowPreview));
                if (name.length() > 0) {
                    group.setCustomName(name);
                }
                if (group instanceof BeanContextChild) {
                    this.m_bcSupport.add(group);
                }
                BeanInstance bi = new BeanInstance((JComponent)this.m_beanLayout, group, (int)r.getX() + (int)(r.getWidth() / 2.0), (int)r.getY() + (int)(r.getHeight() / 2.0));
                for (i2 = 0; i2 < selected.size(); ++i2) {
                    temp2 = (BeanInstance)selected.elementAt(i2);
                    ((BeanInstance)temp2).removeBean(this.m_beanLayout);
                    if (!(((BeanInstance)temp2).getBean() instanceof Visible)) continue;
                    ((Visible)((BeanInstance)temp2).getBean()).getVisual().removePropertyChangeListener(this);
                }
                for (i2 = 0; i2 < associatedConnections.size(); ++i2) {
                    temp2 = (BeanConnection)associatedConnections.elementAt(i2);
                    ((BeanConnection)temp2).setHidden(true);
                }
                group.shiftBeans(bi, true);
                this.addComponent(bi, true);
            }
        }
        for (int i3 = 0; i3 < selected.size(); ++i3) {
            BeanInstance temp3 = (BeanInstance)selected.elementAt(i3);
            if (!(temp3.getBean() instanceof Visible)) continue;
            ((Visible)temp3.getBean()).getVisual().setDisplayConnectors(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.revalidate();
        this.m_beanLayout.repaint();
    }

    private void loadLayout() {
        this.m_loadB.setEnabled(false);
        this.m_saveB.setEnabled(false);
        int returnVal = this.m_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.stopFlow();
            File oFile = this.m_FileChooser.getSelectedFile();
            this.m_flowEnvironment.addVariable("Internal.knowledgeflow.directory", oFile.getParent());
            if (this.m_FileChooser.getFileFilter() == this.m_KfFilter) {
                if (!oFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) {
                    oFile = new File(oFile.getParent(), oFile.getName() + FILE_EXTENSION);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
                if (!oFile.getName().toLowerCase().endsWith(".komlkf")) {
                    oFile = new File(oFile.getParent(), oFile.getName() + ".koml" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter) {
                if (!oFile.getName().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                    oFile = new File(oFile.getParent(), oFile.getName() + FILE_EXTENSION_XML);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XStreamFilter && !oFile.getName().toLowerCase().endsWith(".xstreamkf")) {
                oFile = new File(oFile.getParent(), oFile.getName() + ".xstream" + "kf");
            }
            try {
                Vector beans = new Vector();
                Vector connections = new Vector();
                if (KOML.isPresent() && oFile.getAbsolutePath().toLowerCase().endsWith(".komlkf")) {
                    Vector v = (Vector)KOML.read(oFile.getAbsolutePath());
                    beans = (Vector)v.get(0);
                    connections = (Vector)v.get(1);
                } else if (XStream.isPresent() && oFile.getAbsolutePath().toLowerCase().endsWith(".xstreamkf")) {
                    Vector v = (Vector)XStream.read(oFile.getAbsolutePath());
                    beans = (Vector)v.get(0);
                    connections = (Vector)v.get(1);
                } else if (oFile.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                    XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport);
                    Vector v = (Vector)xml.read(oFile);
                    beans = (Vector)v.get(0);
                    connections = (Vector)v.get(1);
                } else {
                    FileInputStream is = new FileInputStream(oFile);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    beans = (Vector)ois.readObject();
                    connections = (Vector)ois.readObject();
                    ois.close();
                }
                this.integrateFlow(beans, connections);
                this.setEnvironment();
                this.m_logPanel.clearStatus();
                this.m_logPanel.statusMessage("[KnowledgeFlow]|Flow loaded.");
            }
            catch (Exception ex) {
                this.m_logPanel.statusMessage("[KnowledgeFlow]|Unable to load flow (see log).");
                this.m_logPanel.logMessage("[KnowledgeFlow] Unable to load flow (" + ex.getMessage() + ").");
                ex.printStackTrace();
            }
        }
        this.m_loadB.setEnabled(true);
        this.m_saveB.setEnabled(true);
    }

    private void integrateFlow(Vector beans, Vector connections) {
        Color bckC = this.getBackground();
        this.m_bcSupport = new BeanContextSupport();
        this.m_bcSupport.setDesignTime(true);
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)beans.elementAt(i);
            if (tempB.getBean() instanceof Visible) {
                ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                ((Visible)tempB.getBean()).getVisual().setBackground(bckC);
                ((JComponent)tempB.getBean()).setBackground(bckC);
            }
            if (tempB.getBean() instanceof BeanCommon) {
                ((BeanCommon)tempB.getBean()).setLog(this.m_logPanel);
            }
            if (!(tempB.getBean() instanceof BeanContextChild)) continue;
            this.m_bcSupport.add(tempB.getBean());
        }
        BeanInstance.setBeanInstances(beans, this.m_beanLayout);
        BeanConnection.setConnections(connections);
        this.m_beanLayout.revalidate();
        this.m_beanLayout.repaint();
    }

    public void setFlow(Vector v) throws Exception {
        this.clearLayout();
        SerializedObject so = new SerializedObject(v);
        Vector copy = (Vector)so.getObject();
        Vector beans = (Vector)copy.elementAt(0);
        Vector connections = (Vector)copy.elementAt(1);
        this.m_flowEnvironment = new Environment();
        this.integrateFlow(beans, connections);
    }

    public Vector getFlow() throws Exception {
        Vector<Vector> v = new Vector<Vector>();
        Vector beans = BeanInstance.getBeanInstances();
        Vector connections = BeanConnection.getConnections();
        this.detachFromLayout(beans);
        v.add(beans);
        v.add(connections);
        SerializedObject so = new SerializedObject(v);
        Vector copy = (Vector)so.getObject();
        this.integrateFlow(beans, connections);
        return copy;
    }

    protected static BufferedImage createImage(JComponent component, Rectangle region) throws IOException {
        boolean opaqueValue = component.isOpaque();
        component.setOpaque(true);
        BufferedImage image = new BufferedImage(region.width, region.height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.translate(-region.getX(), -region.getY());
        component.paint(g2d);
        g2d.dispose();
        component.setOpaque(opaqueValue);
        return image;
    }

    private void detachFromLayout(Vector beans) {
        for (int i = 0; i < beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)beans.elementAt(i);
            if (!(tempB.getBean() instanceof Visible)) continue;
            ((Visible)tempB.getBean()).getVisual().removePropertyChangeListener(this);
            if (tempB.getBean() instanceof MetaBean) {
                ((MetaBean)tempB.getBean()).removePropertyChangeListenersSubFlow(this);
            }
            ((Visible)tempB.getBean()).getVisual().setBackground(Color.white);
            ((JComponent)tempB.getBean()).setBackground(Color.white);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLayout() {
        int returnVal = this.m_FileChooser.showSaveDialog(this);
        Color bckC = this.getBackground();
        if (returnVal == 0) {
            Vector beans = BeanInstance.getBeanInstances();
            this.detachFromLayout(beans);
            File sFile = this.m_FileChooser.getSelectedFile();
            if (this.m_FileChooser.getFileFilter() == this.m_KfFilter) {
                if (!sFile.getName().toLowerCase().endsWith(FILE_EXTENSION)) {
                    sFile = new File(sFile.getParent(), sFile.getName() + FILE_EXTENSION);
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_KOMLFilter) {
                if (!sFile.getName().toLowerCase().endsWith(".komlkf")) {
                    sFile = new File(sFile.getParent(), sFile.getName() + ".koml" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XStreamFilter) {
                if (!sFile.getName().toLowerCase().endsWith(".xstreamkf")) {
                    sFile = new File(sFile.getParent(), sFile.getName() + ".xstream" + "kf");
                }
            } else if (this.m_FileChooser.getFileFilter() == this.m_XMLFilter && !sFile.getName().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                sFile = new File(sFile.getParent(), sFile.getName() + FILE_EXTENSION_XML);
            }
            try {
                Vector<Vector> v;
                if (KOML.isPresent() && sFile.getAbsolutePath().toLowerCase().endsWith(".komlkf")) {
                    v = new Vector<Vector>();
                    v.setSize(2);
                    v.set(0, beans);
                    v.set(1, BeanConnection.getConnections());
                    KOML.write(sFile.getAbsolutePath(), v);
                } else if (XStream.isPresent() && sFile.getAbsolutePath().toLowerCase().endsWith(".xstreamkf")) {
                    v = new Vector();
                    v.setSize(2);
                    v.set(0, beans);
                    v.set(1, BeanConnection.getConnections());
                    XStream.write(sFile.getAbsolutePath(), v);
                } else if (sFile.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                    v = new Vector();
                    v.setSize(2);
                    v.set(0, beans);
                    v.set(1, BeanConnection.getConnections());
                    XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport);
                    xml.write(sFile, v);
                } else {
                    FileOutputStream os = new FileOutputStream(sFile);
                    ObjectOutputStream oos = new ObjectOutputStream(os);
                    oos.writeObject(beans);
                    oos.writeObject(BeanConnection.getConnections());
                    oos.flush();
                    oos.close();
                }
                this.m_logPanel.statusMessage("[KnowledgeFlow]|Flow saved.");
                this.m_flowEnvironment.addVariable("Internal.knowledgeflow.directory", sFile.getParent());
                this.setEnvironment();
            }
            catch (Exception ex) {
                this.m_logPanel.statusMessage("[KnowledgeFlow]|Unable to save flow (see log).");
                this.m_logPanel.logMessage("[KnowledgeFlow] Unable to save flow (" + ex.getMessage() + ").");
                ex.printStackTrace();
            }
            finally {
                for (int i = 0; i < beans.size(); ++i) {
                    BeanInstance tempB = (BeanInstance)beans.elementAt(i);
                    if (!(tempB.getBean() instanceof Visible)) continue;
                    ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                    if (tempB.getBean() instanceof MetaBean) {
                        ((MetaBean)tempB.getBean()).addPropertyChangeListenersSubFlow(this);
                    }
                    ((Visible)tempB.getBean()).getVisual().setBackground(bckC);
                    ((JComponent)tempB.getBean()).setBackground(bckC);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLayout(OutputStream out) {
        BeanInstance tempB;
        Vector beans = BeanInstance.getBeanInstances();
        for (int i = 0; i < beans.size(); ++i) {
            tempB = (BeanInstance)beans.elementAt(i);
            if (!(tempB.getBean() instanceof Visible)) continue;
            ((Visible)tempB.getBean()).getVisual().removePropertyChangeListener(this);
            if (!(tempB.getBean() instanceof MetaBean)) continue;
            ((MetaBean)tempB.getBean()).removePropertyChangeListenersSubFlow(this);
        }
        try {
            Vector<Vector> v = new Vector<Vector>();
            v.setSize(2);
            v.set(0, beans);
            v.set(1, BeanConnection.getConnections());
            XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport);
            xml.write(out, v);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            for (int i = 0; i < beans.size(); ++i) {
                tempB = (BeanInstance)beans.elementAt(i);
                if (!(tempB.getBean() instanceof Visible)) continue;
                ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                if (!(tempB.getBean() instanceof MetaBean)) continue;
                ((MetaBean)tempB.getBean()).addPropertyChangeListenersSubFlow(this);
            }
        }
    }

    private void loadUserComponents() {
        File sFile;
        Vector tempV = null;
        String ext = "";
        if (this.m_UserComponentsInXML) {
            ext = USERCOMPONENTS_XML_EXTENSION;
        }
        if ((sFile = new File(System.getProperty("user.home") + File.separator + ".knowledgeFlow" + File.separator + "userComponents" + ext)).exists()) {
            try {
                if (this.m_UserComponentsInXML) {
                    XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport, 1);
                    tempV = (Vector)xml.read(sFile);
                } else {
                    FileInputStream is = new FileInputStream(sFile);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    tempV = (Vector)ois.readObject();
                    ois.close();
                }
            }
            catch (Exception ex) {
                System.err.println("[KnowledgeFlow] Problem reading user components.");
                ex.printStackTrace();
                return;
            }
            if (tempV.size() > 0) {
                for (int i = 0; i < tempV.size(); ++i) {
                    MetaBean tempB = (MetaBean)tempV.elementAt(i);
                    this.addToUserToolBar(tempB, false);
                }
            }
        }
    }

    private void installWindowListenerForSavingUserBeans() {
        ((Window)this.getTopLevelAncestor()).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.out.println("[KnowledgeFlow] Saving user components....");
                File sFile = new File(System.getProperty("user.home") + File.separator + ".knowledgeFlow");
                if (!sFile.exists()) {
                    if (!sFile.mkdir()) {
                        System.err.println("[KnowledgeFlow] Unable to create .knowledgeFlow directory in your HOME.");
                    } else {
                        sFile = new File(sFile.toString() + File.separator + "plugins");
                        sFile.mkdir();
                    }
                }
                try {
                    String ext = "";
                    if (KnowledgeFlowApp.this.m_UserComponentsInXML) {
                        ext = KnowledgeFlowApp.USERCOMPONENTS_XML_EXTENSION;
                    }
                    File sFile2 = new File(sFile.getAbsolutePath() + File.separator + "userComponents" + ext);
                    if (KnowledgeFlowApp.this.m_UserComponentsInXML) {
                        XMLBeans xml = new XMLBeans(KnowledgeFlowApp.this.m_beanLayout, KnowledgeFlowApp.this.m_bcSupport, 1);
                        xml.write(sFile2, (Object)KnowledgeFlowApp.this.m_userComponents);
                    } else {
                        FileOutputStream os = new FileOutputStream(sFile2);
                        ObjectOutputStream oos = new ObjectOutputStream(os);
                        oos.writeObject(KnowledgeFlowApp.this.m_userComponents);
                        oos.flush();
                        oos.close();
                    }
                }
                catch (Exception ex) {
                    System.err.println("[KnowledgeFlow] Unable to save user components");
                    ex.printStackTrace();
                }
            }
        });
    }

    public static String getGlobalInfo(Object tempBean) {
        String gi = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(tempBean.getClass());
            MethodDescriptor[] methods = bi.getMethodDescriptors();
            for (int i = 0; i < methods.length; ++i) {
                String globalInfo;
                String name = methods[i].getDisplayName();
                Method meth = methods[i].getMethod();
                if (!name.equals("globalInfo") || !meth.getReturnType().equals(String.class)) continue;
                Object[] args = new Object[]{};
                gi = globalInfo = (String)meth.invoke(tempBean, args);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return gi;
    }

    public static void createSingleton(String[] args) {
        int i;
        String fileName = null;
        boolean showFileMenu = true;
        if (args != null && args.length > 0) {
            for (i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("file=")) {
                    fileName = arg.substring("file=".length());
                    continue;
                }
                if (!arg.startsWith("showFileMenu=")) continue;
                showFileMenu = Boolean.parseBoolean(arg.substring("showFileMenu=".length()));
            }
        }
        if (m_knowledgeFlow == null) {
            m_knowledgeFlow = new KnowledgeFlowApp(showFileMenu);
        }
        for (i = 0; i < s_startupListeners.size(); ++i) {
            ((StartUpListener)s_startupListeners.elementAt(i)).startUpComplete();
        }
        if (fileName != null) {
            m_knowledgeFlow.loadInitialLayout(fileName);
        }
    }

    public static KnowledgeFlowApp getSingleton() {
        return m_knowledgeFlow;
    }

    public static void addStartupListener(StartUpListener s) {
        s_startupListeners.add(s);
    }

    private void loadInitialLayout(String fileName) {
        File oFile = new File(fileName);
        if (oFile.exists() && oFile.isFile()) {
            this.m_FileChooser.setSelectedFile(oFile);
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                String extension = fileName.substring(index);
                if (FILE_EXTENSION_XML.equalsIgnoreCase(extension)) {
                    this.m_FileChooser.setFileFilter(KnowledgeFlowApp.m_knowledgeFlow.m_XMLFilter);
                } else if (FILE_EXTENSION.equalsIgnoreCase(extension)) {
                    this.m_FileChooser.setFileFilter(KnowledgeFlowApp.m_knowledgeFlow.m_KfFilter);
                }
            }
        } else {
            System.err.println("[KnowledgeFlow] File '" + fileName + "' does not exists.");
        }
        try {
            Vector beans = new Vector();
            Vector connections = new Vector();
            if (KOML.isPresent() && oFile.getAbsolutePath().toLowerCase().endsWith(".koml")) {
                Vector v = (Vector)KOML.read(oFile.getAbsolutePath());
                beans = (Vector)v.get(0);
                connections = (Vector)v.get(1);
            } else if (oFile.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION_XML)) {
                XMLBeans xml = new XMLBeans(this.m_beanLayout, this.m_bcSupport);
                Vector v = (Vector)xml.read(oFile);
                beans = (Vector)v.get(0);
                connections = (Vector)v.get(1);
            } else {
                FileInputStream is = new FileInputStream(oFile);
                ObjectInputStream ois = new ObjectInputStream(is);
                beans = (Vector)ois.readObject();
                connections = (Vector)ois.readObject();
                ois.close();
            }
            Color bckC = this.getBackground();
            this.m_bcSupport = new BeanContextSupport();
            this.m_bcSupport.setDesignTime(true);
            for (int i = 0; i < beans.size(); ++i) {
                BeanInstance tempB = (BeanInstance)beans.elementAt(i);
                if (tempB.getBean() instanceof Visible) {
                    ((Visible)tempB.getBean()).getVisual().addPropertyChangeListener(this);
                    ((Visible)tempB.getBean()).getVisual().setBackground(bckC);
                    ((JComponent)tempB.getBean()).setBackground(bckC);
                }
                if (tempB.getBean() instanceof BeanCommon) {
                    ((BeanCommon)tempB.getBean()).setLog(this.m_logPanel);
                }
                if (!(tempB.getBean() instanceof BeanContextChild)) continue;
                this.m_bcSupport.add(tempB.getBean());
            }
            BeanInstance.setBeanInstances(beans, this.m_beanLayout);
            BeanConnection.setConnections(connections);
            this.m_beanLayout.revalidate();
            this.m_beanLayout.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void notifyIsDirty() {
        this.firePropertyChange("PROP_DIRTY", null, null);
    }

    public static void main(String[] args) {
        LookAndFeel.setLookAndFeel();
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            m_knowledgeFlow = new KnowledgeFlowApp(true);
            jf.getContentPane().add((Component)m_knowledgeFlow, "Center");
            jf.setDefaultCloseOperation(3);
            jf.setSize(1000, 750);
            jf.setVisible(true);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                23.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jf.dispose();
                                m_knowledgeFlow = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\n[KnowledgeFlow] displayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    static {
        TOOLBARS = new Vector();
        m_Memory = new Memory(true);
        s_startupListeners = new Vector();
    }

    protected class BeanLayout
    extends PrintablePanel {
        private static final long serialVersionUID = -146377012429662757L;

        protected BeanLayout() {
        }

        @Override
        public void paintComponent(Graphics gx) {
            super.paintComponent(gx);
            BeanInstance.paintLabels(gx);
            BeanConnection.paintConnections(gx);
            if (KnowledgeFlowApp.this.m_mode == 2) {
                gx.drawLine(KnowledgeFlowApp.this.m_startX, KnowledgeFlowApp.this.m_startY, KnowledgeFlowApp.this.m_oldX, KnowledgeFlowApp.this.m_oldY);
            } else if (KnowledgeFlowApp.this.m_mode == 4) {
                gx.drawRect(KnowledgeFlowApp.this.m_startX < KnowledgeFlowApp.this.m_oldX ? KnowledgeFlowApp.this.m_startX : KnowledgeFlowApp.this.m_oldX, KnowledgeFlowApp.this.m_startY < KnowledgeFlowApp.this.m_oldY ? KnowledgeFlowApp.this.m_startY : KnowledgeFlowApp.this.m_oldY, Math.abs(KnowledgeFlowApp.this.m_oldX - KnowledgeFlowApp.this.m_startX), Math.abs(KnowledgeFlowApp.this.m_oldY - KnowledgeFlowApp.this.m_startY));
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Vector comps = BeanInstance.getBeanInstances();
            for (int i = 0; i < comps.size(); ++i) {
                BeanInstance bi = (BeanInstance)comps.elementAt(i);
                JComponent c = (JComponent)bi.getBean();
                Dimension d = c.getPreferredSize();
                c.setBounds(bi.getX(), bi.getY(), d.width, d.height);
                c.revalidate();
            }
        }
    }
}

