/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.rules.Rule;
import weka.classifiers.rules.RuleStats;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class FURIA
extends AbstractClassifier
implements OptionHandler,
AdditionalMeasureProducer,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6589312996832147161L;
    private static double MAX_DL_SURPLUS = 64.0;
    private Attribute m_Class;
    private FastVector m_Ruleset;
    private FastVector m_Distributions;
    private int m_Optimizations = 2;
    private Random m_Random = null;
    private double m_Total = 0.0;
    private long m_Seed = 1L;
    private int m_Folds = 3;
    private double m_MinNo = 2.0;
    private boolean m_Debug = false;
    private boolean m_CheckErr = true;
    private double[] aprioriDistribution;
    private FastVector m_RulesetStats;
    private int m_uncovAction = 0;
    private static final int UNCOVACTION_STRETCH = 0;
    private static final int UNCOVACTION_APRIORI = 1;
    private static final int UNCOVACTION_REJECT = 2;
    private static final Tag[] TAGS_UNCOVACTION = new Tag[]{new Tag(0, "Apply rule stretching (standard)"), new Tag(1, "Vote for the most frequent class"), new Tag(2, "Reject the decision and abstain")};
    private int m_tNorm = 0;
    private static final int TNORM_PROD = 0;
    private static final int TNORM_MIN = 1;
    private static final Tag[] TAGS_TNORM = new Tag[]{new Tag(0, "Product T-Norm (standard)"), new Tag(1, "Minimum T-Norm")};

    public String globalInfo() {
        return "FURIA: Fuzzy Unordered Rule Induction Algorithm\n\nDetails please see:\n\n" + this.getTechnicalInformation().toString() + "\n\n";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jens Christian Huehn and Eyke Huellermeier");
        result.setValue(TechnicalInformation.Field.TITLE, "FURIA: An Algorithm for Unordered Fuzzy Rule Induction");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Data Mining and Knowledge Discovery");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tSet number of folds for REP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        newVector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        newVector.addElement(new Option("\tSet the number of runs of\n\toptimizations. (Default: 2)", "O", 1, "-O <number of runs>"));
        newVector.addElement(new Option("\tSet whether turn on the\n\tdebug mode (Default: false)", "D", 0, "-D"));
        newVector.addElement(new Option("\tThe seed of randomization\n\t(Default: 1)", "S", 1, "-S <seed>"));
        newVector.addElement(new Option("\tWhether NOT check the error rate>=0.5\n\tin stopping criteria \t(default: check)", "E", 0, "-E"));
        newVector.addElement(new Option("\tThe action performed for uncovered instances.\n\t(default: use stretching)", "s", 1, "-s"));
        newVector.addElement(new Option("\tThe T-norm used as fuzzy AND-operator.\n\t(default: Product T-norm)", "p", 1, "-p"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString = Utils.getOption('F', options);
        this.m_Folds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String minNoString = Utils.getOption('N', options);
        this.m_MinNo = minNoString.length() != 0 ? Double.parseDouble(minNoString) : 2.0;
        String seedString = Utils.getOption('S', options);
        this.m_Seed = seedString.length() != 0 ? Long.parseLong(seedString) : 1L;
        String runString = Utils.getOption('O', options);
        this.m_Optimizations = runString.length() != 0 ? Integer.parseInt(runString) : 2;
        String tNormString = Utils.getOption('p', options);
        this.m_tNorm = tNormString.length() != 0 ? Integer.parseInt(tNormString) : 0;
        String uncovActionString = Utils.getOption('s', options);
        this.m_uncovAction = uncovActionString.length() != 0 ? Integer.parseInt(uncovActionString) : 0;
        this.m_Debug = Utils.getFlag('D', options);
        this.m_CheckErr = !Utils.getFlag('E', options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[14];
        int current = 0;
        options[current++] = "-F";
        options[current++] = "" + this.m_Folds;
        options[current++] = "-N";
        options[current++] = "" + this.m_MinNo;
        options[current++] = "-O";
        options[current++] = "" + this.m_Optimizations;
        options[current++] = "-S";
        options[current++] = "" + this.m_Seed;
        options[current++] = "-p";
        options[current++] = "" + this.m_tNorm;
        options[current++] = "-s";
        options[current++] = "" + this.m_uncovAction;
        if (this.m_Debug) {
            options[current++] = "-D";
        }
        if (!this.m_CheckErr) {
            options[current++] = "-E";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.m_Ruleset.size();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (FURIA)");
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int fold) {
        this.m_Folds = fold;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(long s) {
        this.m_Seed = s;
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String optimizationsTipText() {
        return "The number of optimization runs.";
    }

    public void setOptimizations(int run) {
        this.m_Optimizations = run;
    }

    public int getOptimizations() {
        return this.m_Optimizations;
    }

    @Override
    public String debugTipText() {
        return "Whether debug information is output to the console.";
    }

    @Override
    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    @Override
    public boolean getDebug() {
        return this.m_Debug;
    }

    public String checkErrorRateTipText() {
        return "Whether check for error rate >= 1/2 is included in stopping criterion.";
    }

    public void setCheckErrorRate(boolean d) {
        this.m_CheckErr = d;
    }

    public boolean getCheckErrorRate() {
        return this.m_CheckErr;
    }

    public String uncovActionTipText() {
        return "Selet the action that is performed for uncovered instances.";
    }

    public SelectedTag getUncovAction() {
        return new SelectedTag(this.m_uncovAction, TAGS_UNCOVACTION);
    }

    public void setUncovAction(SelectedTag newUncovAction) {
        if (newUncovAction.getTags() == TAGS_UNCOVACTION) {
            this.m_uncovAction = newUncovAction.getSelectedTag().getID();
        }
    }

    public String TNormTipText() {
        return "Choose the T-Norm that is used as fuzzy AND-operator.";
    }

    public SelectedTag getTNorm() {
        return new SelectedTag(this.m_tNorm, TAGS_TNORM);
    }

    public void setTNorm(SelectedTag newTNorm) {
        if (newTNorm.getTags() == TAGS_TNORM) {
            this.m_tNorm = newTNorm.getSelectedTag().getID();
        }
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public RuleStats getRuleStats(int pos) {
        return (RuleStats)this.m_RulesetStats.elementAt(pos);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(this.m_Folds);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        int j;
        int z;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.aprioriDistribution = new double[instances.classAttribute().numValues()];
        boolean allWeightsAreOne = true;
        for (int i = 0; i < instances.numInstances(); ++i) {
            int n = (int)instances.instance(i).classValue();
            this.aprioriDistribution[n] = this.aprioriDistribution[n] + instances.instance(i).weight();
            if (!allWeightsAreOne || instances.instance(i).weight() == 1.0) continue;
            allWeightsAreOne = false;
            break;
        }
        this.m_Random = instances.getRandomNumberGenerator(this.m_Seed);
        this.m_Total = RuleStats.numAllConditions(instances);
        if (this.m_Debug) {
            System.err.println("Number of all possible conditions = " + this.m_Total);
        }
        Instances data = new Instances(instances);
        this.m_Class = data.classAttribute();
        this.m_Ruleset = new FastVector();
        this.m_RulesetStats = new FastVector();
        this.m_Distributions = new FastVector();
        for (int y = 0; y < data.numClasses(); ++y) {
            double classIndex = y;
            if (this.m_Debug) {
                int ci = (int)classIndex;
                System.err.println("\n\nClass " + this.m_Class.value(ci) + "(" + ci + "): " + this.aprioriDistribution[y] + "instances\n" + "=====================================\n");
            }
            if (Utils.eq(this.aprioriDistribution[y], 0.0)) continue;
            double expFPRate = this.aprioriDistribution[y] / Utils.sum(this.aprioriDistribution);
            double classYWeights = 0.0;
            double totalWeights = 0.0;
            for (int j2 = 0; j2 < data.numInstances(); ++j2) {
                Instance datum = data.instance(j2);
                totalWeights += datum.weight();
                if ((int)datum.classValue() != y) continue;
                classYWeights += datum.weight();
            }
            if (!(classYWeights > 0.0)) continue;
            double defDL = RuleStats.dataDL(expFPRate, 0.0, totalWeights, 0.0, classYWeights);
            if (Double.isNaN(defDL) || Double.isInfinite(defDL)) {
                throw new Exception("Should never happen: defDL NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("The default DL = " + defDL);
            }
            this.rulesetForOneClass(expFPRate, data, classIndex, defDL);
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            for (j = 0; j < rule.m_Antds.size(); ++j) {
                Antd outerAntd = (Antd)rule.m_Antds.elementAt(j);
                for (int k = j + 1; k < rule.m_Antds.size(); ++k) {
                    Antd innerAntd = (Antd)rule.m_Antds.elementAt(k);
                    if (outerAntd.att.index() != innerAntd.att.index() || outerAntd.value != innerAntd.value) continue;
                    rule.m_Antds.setElementAt(rule.m_Antds.elementAt(k), j);
                    rule.m_Antds.removeElementAt(k--);
                }
            }
        }
        for (z = 0; z < this.m_RulesetStats.size(); ++z) {
            RuleStats oneClass = (RuleStats)this.m_RulesetStats.elementAt(z);
            for (int xyz = 0; xyz < oneClass.getRulesetSize(); ++xyz) {
                RipperRule rule = (RipperRule)oneClass.getRuleset().elementAt(xyz);
                rule.fuzzify(data, allWeightsAreOne);
                double[] classDist = oneClass.getDistributions(xyz);
                if (Utils.sum(classDist) > 0.0) {
                    Utils.normalize(classDist);
                }
                if (classDist == null) continue;
                this.m_Distributions.addElement(classDist);
            }
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            for (j = 0; j < rule.m_Antds.size(); ++j) {
                Antd antd = (Antd)rule.m_Antds.elementAt(j);
                if (!(antd instanceof NumericAntd)) continue;
                NumericAntd numAntd = (NumericAntd)antd;
                if (numAntd.fuzzyYet) continue;
                for (int i = 0; i < data.numInstances(); ++i) {
                    if ((numAntd.value != 1.0 || !(numAntd.splitPoint > data.instance(i).value(numAntd.att.index())) || !(numAntd.supportBound < data.instance(i).value(numAntd.att.index())) && numAntd.fuzzyYet) && (numAntd.value != 0.0 || !(numAntd.splitPoint < data.instance(i).value(numAntd.att.index())) || !(numAntd.supportBound > data.instance(i).value(numAntd.att.index())) && numAntd.fuzzyYet)) continue;
                    numAntd.supportBound = data.instance(i).value(numAntd.att.index());
                    numAntd.fuzzyYet = true;
                }
            }
        }
        for (z = 0; z < this.m_Ruleset.size(); ++z) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(z);
            rule.calculateConfidences(data);
        }
    }

    @Override
    public double[] distributionForInstance(Instance datum) throws Exception {
        int i;
        double[] rulesCoveringForEachClass = new double[datum.numClasses()];
        for (int i2 = 0; i2 < this.m_Ruleset.size(); ++i2) {
            RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(i2);
            if (!rule.hasAntds() || !rule.covers(datum)) continue;
            int n = (int)rule.m_Consequent;
            rulesCoveringForEachClass[n] = rulesCoveringForEachClass[n] + rule.coverageDegree(datum) * rule.getConfidence();
        }
        if (Utils.sum(rulesCoveringForEachClass) == 0.0) {
            if (this.m_uncovAction == 1) {
                rulesCoveringForEachClass = this.aprioriDistribution;
                if (Utils.sum(rulesCoveringForEachClass) > 0.0) {
                    Utils.normalize(rulesCoveringForEachClass);
                }
                return rulesCoveringForEachClass;
            }
            if (this.m_uncovAction == 2) {
                return rulesCoveringForEachClass;
            }
            FastVector origRuleset = this.m_Ruleset.copyElements();
            rulesCoveringForEachClass = new double[rulesCoveringForEachClass.length];
            for (int i3 = 0; i3 < this.m_Ruleset.size(); ++i3) {
                int j;
                RipperRule rule = (RipperRule)this.m_Ruleset.elementAt(i3);
                double numAntdsBefore = rule.m_Antds.size();
                int firstAntdToDelete = Integer.MAX_VALUE;
                for (j = 0; j < rule.m_Antds.size(); ++j) {
                    if (((Antd)rule.m_Antds.elementAt(j)).covers(datum) != 0.0) continue;
                    firstAntdToDelete = j;
                    break;
                }
                for (j = firstAntdToDelete; j < rule.m_Antds.size(); ++j) {
                    rule.m_Antds.removeElementAt(j--);
                }
                double numAntdsAfter = rule.m_Antds.size();
                if (!rule.hasAntds()) continue;
                double secondWeight = (numAntdsAfter + 1.0) / (numAntdsBefore + 2.0);
                if (!(rule.getConfidence() * secondWeight * rule.coverageDegree(datum) >= rulesCoveringForEachClass[(int)rule.getConsequent()])) continue;
                rulesCoveringForEachClass[(int)rule.getConsequent()] = rule.getConfidence() * secondWeight * rule.coverageDegree(datum);
            }
            this.m_Ruleset = origRuleset;
        }
        double[] maxClasses = new double[rulesCoveringForEachClass.length];
        for (i = 0; i < rulesCoveringForEachClass.length; ++i) {
            if (rulesCoveringForEachClass[Utils.maxIndex(rulesCoveringForEachClass)] != rulesCoveringForEachClass[i] || !(rulesCoveringForEachClass[i] > 0.0)) continue;
            maxClasses[i] = 1.0;
        }
        if (Utils.sum(maxClasses) > 0.0) {
            for (i = 0; i < maxClasses.length; ++i) {
                if (!(maxClasses[i] > 0.0) || this.aprioriDistribution[i] == rulesCoveringForEachClass[Utils.maxIndex(rulesCoveringForEachClass)]) continue;
                int n = i;
                rulesCoveringForEachClass[n] = rulesCoveringForEachClass[n] - 1.0E-5;
            }
        }
        if (Utils.sum(rulesCoveringForEachClass) == 0.0) {
            rulesCoveringForEachClass = this.aprioriDistribution;
        }
        if (Utils.sum(rulesCoveringForEachClass) > 0.0) {
            Utils.normalize(rulesCoveringForEachClass);
        }
        return rulesCoveringForEachClass;
    }

    protected Instances rulesetForOneClass(double expFPRate, Instances data, double classIndex, double defDL) throws Exception {
        double[] rst;
        boolean defHasPositive;
        Instances newData = data;
        boolean stop = false;
        FastVector ruleset = new FastVector();
        double dl = defDL;
        double minDL = defDL;
        RuleStats rstats = null;
        boolean hasPositive = defHasPositive = true;
        if (this.m_Debug) {
            System.err.println("\n*** Building stage ***");
        }
        while (!stop && hasPositive) {
            RipperRule oneRule = new RipperRule();
            oneRule.setConsequent(classIndex);
            if (this.m_Debug) {
                System.err.println("\nNo pruning: growing a rule ...");
            }
            oneRule.grow(newData);
            if (this.m_Debug) {
                System.err.println("No pruning: one rule found:\n" + oneRule.toString(this.m_Class));
            }
            if (rstats == null) {
                rstats = new RuleStats();
                rstats.setNumAllConds(this.m_Total);
                rstats.setData(newData);
            }
            rstats.addAndUpdate(oneRule);
            int last = rstats.getRuleset().size() - 1;
            if (Double.isNaN(dl += rstats.relativeDL(last, expFPRate, this.m_CheckErr)) || Double.isInfinite(dl)) {
                throw new Exception("Should never happen: dl in building stage NaN or infinite!");
            }
            if (this.m_Debug) {
                System.err.println("Before optimization(" + last + "): the dl = " + dl + " | best: " + minDL);
            }
            if (dl < minDL) {
                minDL = dl;
            }
            rst = rstats.getSimpleStats(last);
            if (this.m_Debug) {
                System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
            }
            if (!(stop = this.checkStop(rst, minDL, dl))) {
                ruleset.addElement(oneRule);
                newData = rstats.getFiltered(last)[1];
                hasPositive = Utils.gr(rst[5], 0.0);
                if (!this.m_Debug) continue;
                System.err.println("One rule added: has positive? " + hasPositive);
                continue;
            }
            if (this.m_Debug) {
                System.err.println("Quit rule");
            }
            rstats.removeLast();
        }
        RuleStats finalRulesetStat = null;
        for (int z = 0; z < this.m_Optimizations; ++z) {
            if (this.m_Debug) {
                System.err.println("\n*** Optimization: run #" + z + " ***");
            }
            newData = data;
            finalRulesetStat = new RuleStats();
            finalRulesetStat.setData(newData);
            finalRulesetStat.setNumAllConds(this.m_Total);
            int position = 0;
            stop = false;
            boolean isResidual = false;
            hasPositive = defHasPositive;
            dl = minDL = defDL;
            while (!stop && hasPositive) {
                RipperRule finalRule;
                isResidual = position >= ruleset.size();
                newData = RuleStats.stratify(newData, this.m_Folds, this.m_Random);
                Instances[] part = RuleStats.partition(newData, this.m_Folds);
                Instances growData = part[0];
                Instances pruneData = part[1];
                if (this.m_Debug) {
                    System.err.println("\nRule #" + position + "| isResidual?" + isResidual + "| data size: " + newData.sumOfWeights());
                }
                if (isResidual) {
                    RipperRule newRule = new RipperRule();
                    newRule.setConsequent(classIndex);
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning a new rule ...");
                    }
                    newRule.grow(newData);
                    finalRule = newRule;
                    if (this.m_Debug) {
                        System.err.println("\nNew rule found: " + newRule.toString(this.m_Class));
                    }
                } else {
                    RipperRule oldRule = (RipperRule)ruleset.elementAt(position);
                    boolean covers = false;
                    for (int i = 0; i < newData.numInstances(); ++i) {
                        if (!oldRule.covers(newData.instance(i))) continue;
                        covers = true;
                        break;
                    }
                    if (!covers) {
                        finalRulesetStat.addAndUpdate(oldRule);
                        ++position;
                        continue;
                    }
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning Replace ...");
                    }
                    RipperRule replace = new RipperRule();
                    replace.setConsequent(classIndex);
                    replace.grow(growData);
                    pruneData = RuleStats.rmCoveredBySuccessives(pruneData, ruleset, position);
                    replace.prune(pruneData, true);
                    if (this.m_Debug) {
                        System.err.println("\nGrowing and pruning Revision ...");
                    }
                    RipperRule revision = (RipperRule)oldRule.copy();
                    Instances newGrowData = new Instances(growData, 0);
                    for (int b = 0; b < growData.numInstances(); ++b) {
                        Instance inst = growData.instance(b);
                        if (!revision.covers(inst)) continue;
                        newGrowData.add(inst);
                    }
                    revision.grow(newGrowData);
                    revision.prune(pruneData, true);
                    double[][] prevRuleStats = new double[position][6];
                    for (int c = 0; c < position; ++c) {
                        prevRuleStats[c] = finalRulesetStat.getSimpleStats(c);
                    }
                    FastVector<RipperRule> tempRules = ruleset.copyElements();
                    tempRules.setElementAt(replace, position);
                    RuleStats repStat = new RuleStats(data, tempRules);
                    repStat.setNumAllConds(this.m_Total);
                    repStat.countData(position, newData, prevRuleStats);
                    rst = repStat.getSimpleStats(position);
                    if (this.m_Debug) {
                        System.err.println("Replace rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                    }
                    double repDL = repStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("\nReplace: " + replace.toString(this.m_Class) + " |dl = " + repDL);
                    }
                    if (Double.isNaN(repDL) || Double.isInfinite(repDL)) {
                        throw new Exception("Should never happen: repDLin optmz. stage NaN or infinite!");
                    }
                    tempRules.setElementAt(revision, position);
                    RuleStats revStat = new RuleStats(data, tempRules);
                    revStat.setNumAllConds(this.m_Total);
                    revStat.countData(position, newData, prevRuleStats);
                    double revDL = revStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("Revision: " + revision.toString(this.m_Class) + " |dl = " + revDL);
                    }
                    if (Double.isNaN(revDL) || Double.isInfinite(revDL)) {
                        throw new Exception("Should never happen: revDLin optmz. stage NaN or infinite!");
                    }
                    rstats = new RuleStats(data, ruleset);
                    rstats.setNumAllConds(this.m_Total);
                    rstats.countData(position, newData, prevRuleStats);
                    double oldDL = rstats.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (Double.isNaN(oldDL) || Double.isInfinite(oldDL)) {
                        throw new Exception("Should never happen: oldDLin optmz. stage NaN or infinite!");
                    }
                    if (this.m_Debug) {
                        System.err.println("Old rule: " + oldRule.toString(this.m_Class) + " |dl = " + oldDL);
                    }
                    if (this.m_Debug) {
                        System.err.println("\nrepDL: " + repDL + "\nrevDL: " + revDL + "\noldDL: " + oldDL);
                    }
                    finalRule = oldDL <= revDL && oldDL <= repDL ? oldRule : (revDL <= repDL ? revision : replace);
                }
                finalRulesetStat.addAndUpdate(finalRule);
                rst = finalRulesetStat.getSimpleStats(position);
                if (isResidual) {
                    dl += finalRulesetStat.relativeDL(position, expFPRate, this.m_CheckErr);
                    if (this.m_Debug) {
                        System.err.println("After optimization: the dl=" + dl + " | best: " + minDL);
                    }
                    if (dl < minDL) {
                        minDL = dl;
                    }
                    if (!(stop = this.checkStop(rst, minDL, dl))) {
                        ruleset.addElement(finalRule);
                    } else {
                        finalRulesetStat.removeLast();
                        --position;
                    }
                } else {
                    ruleset.setElementAt(finalRule, position);
                }
                if (this.m_Debug) {
                    System.err.println("The rule covers: " + rst[0] + " | pos = " + rst[2] + " | neg = " + rst[4] + "\nThe rule doesn't cover: " + rst[1] + " | pos = " + rst[5]);
                    System.err.println("\nRuleset so far: ");
                    for (int x = 0; x < ruleset.size(); ++x) {
                        System.err.println(x + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
                    }
                    System.err.println();
                }
                if (finalRulesetStat.getRulesetSize() > 0) {
                    newData = finalRulesetStat.getFiltered(position)[1];
                }
                hasPositive = Utils.gr(rst[5], 0.0);
                ++position;
            }
            if (ruleset.size() > position + 1) {
                for (int k = position + 1; k < ruleset.size(); ++k) {
                    finalRulesetStat.addAndUpdate((Rule)ruleset.elementAt(k));
                }
            }
            if (this.m_Debug) {
                System.err.println("\nDeleting rules to decrease DL of the whole ruleset ...");
            }
            finalRulesetStat.reduceDL(expFPRate, this.m_CheckErr);
            if (this.m_Debug) {
                int del = ruleset.size() - finalRulesetStat.getRulesetSize();
                System.err.println(del + " rules are deleted" + " after DL reduction procedure");
            }
            ruleset = finalRulesetStat.getRuleset();
            rstats = finalRulesetStat;
        }
        if (this.m_Debug) {
            System.err.println("\nFinal ruleset: ");
            for (int x = 0; x < ruleset.size(); ++x) {
                System.err.println(x + ": " + ((RipperRule)ruleset.elementAt(x)).toString(this.m_Class));
            }
            System.err.println();
        }
        this.m_Ruleset.appendElements(ruleset);
        this.m_RulesetStats.addElement(rstats);
        return null;
    }

    private boolean checkStop(double[] rst, double minDL, double dl) {
        if (dl > minDL + MAX_DL_SURPLUS) {
            if (this.m_Debug) {
                System.err.println("DL too large: " + dl + " | " + minDL);
            }
            return true;
        }
        if (!Utils.gr(rst[2], 0.0)) {
            if (this.m_Debug) {
                System.err.println("Too few positives.");
            }
            return true;
        }
        if (rst[4] / rst[0] >= 0.5) {
            if (this.m_CheckErr) {
                if (this.m_Debug) {
                    System.err.println("Error too large: " + rst[4] + "/" + rst[0]);
                }
                return true;
            }
            return false;
        }
        if (this.m_Debug) {
            System.err.println("Continue.");
        }
        return false;
    }

    public String toString() {
        if (this.m_Ruleset == null) {
            return "FURIA: No model built yet.";
        }
        StringBuffer sb = new StringBuffer("FURIA rules:\n===========\n\n");
        for (int j = 0; j < this.m_RulesetStats.size(); ++j) {
            RuleStats rs = (RuleStats)this.m_RulesetStats.elementAt(j);
            FastVector rules = rs.getRuleset();
            for (int k = 0; k < rules.size(); ++k) {
                sb.append(((RipperRule)rules.elementAt(k)).toString(this.m_Class) + " (CF = " + (double)Math.round(100.0 * ((RipperRule)rules.elementAt(k)).getConfidence()) / 100.0 + ")\n");
            }
        }
        if (this.m_Debug) {
            System.err.println("Inside m_Ruleset");
            for (int i = 0; i < this.m_Ruleset.size(); ++i) {
                System.err.println(((RipperRule)this.m_Ruleset.elementAt(i)).toString(this.m_Class));
            }
        }
        sb.append("\nNumber of Rules : " + this.m_Ruleset.size() + "\n");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        FURIA.runClassifier(new FURIA(), args);
    }

    @Override
    public String getRevision() {
        return "$Revision: 5964 $";
    }

    public class RipperRule
    extends Rule {
        static final long serialVersionUID = -2410020717305262952L;
        double m_Consequent = -1.0;
        public FastVector m_Antds = new FastVector();

        public void setConsequent(double cl) {
            this.m_Consequent = cl;
        }

        @Override
        public double getConsequent() {
            return this.m_Consequent;
        }

        @Override
        public Object copy() {
            RipperRule copy = new RipperRule();
            copy.setConsequent(this.getConsequent());
            copy.m_Antds = this.m_Antds.copyElements();
            return copy;
        }

        public double coverageDegree(Instance datum) {
            double coverage = 1.0;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (FURIA.this.m_tNorm == 0) {
                    if (antd instanceof NumericAntd) {
                        coverage *= ((NumericAntd)antd).covers(datum);
                        continue;
                    }
                    coverage *= antd.covers(datum);
                    continue;
                }
                coverage = antd instanceof NumericAntd ? Math.min(coverage, ((NumericAntd)antd).covers(datum)) : Math.min(coverage, antd.covers(datum));
            }
            return coverage;
        }

        @Override
        public boolean covers(Instance datum) {
            return this.coverageDegree(datum) != 0.0;
        }

        @Override
        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        @Override
        public double size() {
            return this.m_Antds.size();
        }

        private double computeDefAccu(Instances data) {
            double defAccu = 0.0;
            for (int i = 0; i < data.numInstances(); ++i) {
                Instance inst = data.instance(i);
                if ((int)inst.classValue() != (int)this.m_Consequent) continue;
                defAccu += inst.weight();
            }
            return defAccu;
        }

        @Override
        public void grow(Instances data) throws Exception {
            if (this.m_Consequent == -1.0) {
                throw new Exception(" Consequent not set yet.");
            }
            Instances growData = data;
            double sumOfWeights = growData.sumOfWeights();
            if (!Utils.gr(sumOfWeights, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(growData);
            double defAcRt = (defAccu + 1.0) / (sumOfWeights + 1.0);
            boolean[] used = new boolean[growData.numAttributes()];
            for (int k = 0; k < used.length; ++k) {
                used[k] = false;
            }
            int numUnused = used.length;
            for (int j = 0; j < this.m_Antds.size(); ++j) {
                Antd antdj = (Antd)this.m_Antds.elementAt(j);
                if (antdj.getAttr().isNumeric()) continue;
                used[antdj.getAttr().index()] = true;
                --numUnused;
            }
            while (Utils.gr(growData.numInstances(), 0.0) && numUnused > 0 && Utils.sm(defAcRt, 1.0)) {
                double maxInfoGain = 0.0;
                Antd oneAntd = null;
                Instances coverData = null;
                Enumeration enumAttr = growData.enumerateAttributes();
                while (enumAttr.hasMoreElements()) {
                    Instances coveredData;
                    Attribute att = (Attribute)enumAttr.nextElement();
                    if (FURIA.this.m_Debug) {
                        System.err.println("\nOne condition: size = " + growData.sumOfWeights());
                    }
                    Antd antd = null;
                    antd = att.isNumeric() ? new NumericAntd(att) : new NominalAntd(att);
                    if (used[att.index()] || (coveredData = this.computeInfoGain(growData, defAcRt, antd)) == null) continue;
                    double infoGain = antd.getMaxInfoGain();
                    if (FURIA.this.m_Debug) {
                        System.err.println("Test of '" + antd.toString() + "': infoGain = " + infoGain + " | Accuracy = " + antd.getAccuRate() + "=" + antd.getAccu() + "/" + antd.getCover() + " def. accuracy: " + defAcRt);
                    }
                    if (!(infoGain > maxInfoGain)) continue;
                    oneAntd = antd;
                    coverData = coveredData;
                    maxInfoGain = infoGain;
                }
                if (oneAntd == null || Utils.sm(oneAntd.getAccu(), FURIA.this.m_MinNo)) break;
                if (!oneAntd.getAttr().isNumeric()) {
                    used[oneAntd.getAttr().index()] = true;
                    --numUnused;
                }
                this.m_Antds.addElement(oneAntd);
                growData = coverData;
                defAcRt = oneAntd.getAccuRate();
            }
        }

        private Instances computeInfoGain(Instances instances, double defAcRt, Antd antd) {
            Instances data = instances;
            Instances[] splitData = antd.splitData(data, defAcRt, this.m_Consequent);
            if (splitData != null) {
                return splitData[(int)antd.getAttrValue()];
            }
            return null;
        }

        public void prune(Instances pruneData, boolean useWhole) {
            int size;
            Instances data = pruneData;
            double total = data.sumOfWeights();
            if (!Utils.gr(total, 0.0)) {
                return;
            }
            double defAccu = this.computeDefAccu(data);
            if (FURIA.this.m_Debug) {
                System.err.println("Pruning with " + defAccu + " positive data out of " + total + " instances");
            }
            if ((size = this.m_Antds.size()) == 0) {
                return;
            }
            double[] worthRt = new double[size];
            double[] coverage = new double[size];
            double[] worthValue = new double[size];
            for (int w = 0; w < size; ++w) {
                worthValue[w] = 0.0;
                coverage[w] = 0.0;
                worthRt[w] = 0.0;
            }
            double tn = 0.0;
            for (int x = 0; x < size; ++x) {
                Antd antd = (Antd)this.m_Antds.elementAt(x);
                Instances newData = data;
                data = new Instances(newData, 0);
                for (int y = 0; y < newData.numInstances(); ++y) {
                    Instance ins = newData.instance(y);
                    if (antd.covers(ins) > 0.0) {
                        int n = x;
                        coverage[n] = coverage[n] + ins.weight();
                        data.add(ins);
                        if ((int)ins.classValue() != (int)this.m_Consequent) continue;
                        int n2 = x;
                        worthValue[n2] = worthValue[n2] + ins.weight();
                        continue;
                    }
                    if (!useWhole || (int)ins.classValue() == (int)this.m_Consequent) continue;
                    tn += ins.weight();
                }
                if (useWhole) {
                    int n = x;
                    worthValue[n] = worthValue[n] + tn;
                    worthRt[x] = worthValue[x] / total;
                    continue;
                }
                worthRt[x] = (worthValue[x] + 1.0) / (coverage[x] + 2.0);
            }
            double maxValue = (defAccu + 1.0) / (total + 2.0);
            int maxIndex = -1;
            for (int i = 0; i < worthValue.length; ++i) {
                if (FURIA.this.m_Debug) {
                    double denom = useWhole ? total : coverage[i];
                    System.err.println(i + "(useAccuray? " + !useWhole + "): " + worthRt[i] + "=" + worthValue[i] + "/" + denom);
                }
                if (!(worthRt[i] > maxValue)) continue;
                maxValue = worthRt[i];
                maxIndex = i;
            }
            if (maxIndex == -1) {
                return;
            }
            for (int z = size - 1; z > maxIndex; --z) {
                this.m_Antds.removeElementAt(z);
            }
        }

        public String toString(Attribute classAttr) {
            StringBuffer text = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int j = 0; j < this.m_Antds.size() - 1; ++j) {
                    text.append("(" + ((Antd)this.m_Antds.elementAt(j)).toString() + ") and ");
                }
                text.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            text.append(" => " + classAttr.name() + "=" + classAttr.value((int)this.m_Consequent));
            return text.toString();
        }

        public void fuzzify(Instances data, boolean allWeightsAreOne) {
            if (this.m_Antds == null) {
                return;
            }
            int numNumericAntds = 0;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                if (!(this.m_Antds.elementAt(i) instanceof NumericAntd)) continue;
                ++numNumericAntds;
            }
            if (numNumericAntds == 0) {
                return;
            }
            double maxPurity = Double.NEGATIVE_INFINITY;
            boolean[] finishedAntecedents = new boolean[this.m_Antds.size()];
            for (int numFinishedAntecedents = 0; numFinishedAntecedents < this.m_Antds.size(); ++numFinishedAntecedents) {
                double maxPurityOfAllAntecedents = Double.NEGATIVE_INFINITY;
                int bestAntecedentsIndex = -1;
                double bestSupportBoundForAllAntecedents = Double.NaN;
                Instances relevantData = new Instances(data, 0);
                for (int j = 0; j < this.m_Antds.size(); ++j) {
                    if (finishedAntecedents[j]) continue;
                    relevantData = new Instances(data);
                    for (int k = 0; k < this.m_Antds.size(); ++k) {
                        if (k == j) continue;
                        Antd exclusionAntd = (Antd)this.m_Antds.elementAt(k);
                        for (int y = 0; y < relevantData.numInstances(); ++y) {
                            if (exclusionAntd.covers(relevantData.instance(y)) != 0.0) continue;
                            relevantData.delete(y--);
                        }
                    }
                    if (relevantData.attribute(((Antd)this.m_Antds.elementAt((int)j)).att.index()).isNumeric() && relevantData.numInstances() > 0) {
                        double purity;
                        double coverValue;
                        double[] coverArray;
                        double[] accuArray;
                        int k;
                        NumericAntd currentAntd = (NumericAntd)((NumericAntd)this.m_Antds.elementAt(j)).copy();
                        currentAntd.fuzzyYet = true;
                        relevantData.deleteWithMissing(currentAntd.att.index());
                        double sumOfWeights = relevantData.sumOfWeights();
                        if (!Utils.gr(sumOfWeights, 0.0)) {
                            return;
                        }
                        relevantData.sort(currentAntd.att.index());
                        double maxPurityForThisAntecedent = 0.0;
                        double bestFoundSupportBound = Double.NaN;
                        double lastAccu = 0.0;
                        double lastCover = 0.0;
                        if (currentAntd.value == 0.0) {
                            for (k = 1; !(k >= relevantData.numInstances() || (lastAccu + (double)(relevantData.numInstances() - k - 1)) / (lastCover + (double)(relevantData.numInstances() - k - 1)) < maxPurityForThisAntecedent && allWeightsAreOne); ++k) {
                                if (!(currentAntd.splitPoint < relevantData.instance(k).value(currentAntd.att.index())) || relevantData.instance(k).value(currentAntd.att.index()) == relevantData.instance(k - 1).value(currentAntd.att.index())) continue;
                                currentAntd.supportBound = relevantData.instance(k).value(currentAntd.att.index());
                                accuArray = new double[relevantData.numInstances()];
                                coverArray = new double[relevantData.numInstances()];
                                for (int i = 0; i < relevantData.numInstances(); ++i) {
                                    coverArray[i] = relevantData.instance(i).weight();
                                    coverValue = currentAntd.covers(relevantData.instance(i));
                                    if (!(coverArray[i] >= coverValue * relevantData.instance(i).weight())) continue;
                                    coverArray[i] = coverValue * relevantData.instance(i).weight();
                                    if (relevantData.instance(i).classValue() != this.m_Consequent) continue;
                                    accuArray[i] = coverValue * relevantData.instance(i).weight();
                                }
                                purity = Utils.sum(accuArray) / Utils.sum(coverArray);
                                if (purity >= maxPurityForThisAntecedent) {
                                    maxPurityForThisAntecedent = purity;
                                    bestFoundSupportBound = currentAntd.supportBound;
                                }
                                lastAccu = Utils.sum(accuArray);
                                lastCover = Utils.sum(coverArray);
                            }
                        } else {
                            for (k = relevantData.numInstances() - 2; !(k < 0 || (lastAccu + (double)k) / (lastCover + (double)k) < maxPurityForThisAntecedent && allWeightsAreOne); --k) {
                                if (!(currentAntd.splitPoint > relevantData.instance(k).value(currentAntd.att.index())) || relevantData.instance(k).value(currentAntd.att.index()) == relevantData.instance(k + 1).value(currentAntd.att.index())) continue;
                                currentAntd.supportBound = relevantData.instance(k).value(currentAntd.att.index());
                                accuArray = new double[relevantData.numInstances()];
                                coverArray = new double[relevantData.numInstances()];
                                for (int i = 0; i < relevantData.numInstances(); ++i) {
                                    coverArray[i] = relevantData.instance(i).weight();
                                    coverValue = currentAntd.covers(relevantData.instance(i));
                                    if (!(coverArray[i] >= coverValue * relevantData.instance(i).weight())) continue;
                                    coverArray[i] = coverValue * relevantData.instance(i).weight();
                                    if (relevantData.instance(i).classValue() != this.m_Consequent) continue;
                                    accuArray[i] = coverValue * relevantData.instance(i).weight();
                                }
                                purity = Utils.sum(accuArray) / Utils.sum(coverArray);
                                if (purity >= maxPurityForThisAntecedent) {
                                    maxPurityForThisAntecedent = purity;
                                    bestFoundSupportBound = currentAntd.supportBound;
                                }
                                lastAccu = Utils.sum(accuArray);
                                lastCover = Utils.sum(coverArray);
                            }
                        }
                        if (!(maxPurityForThisAntecedent > maxPurityOfAllAntecedents)) continue;
                        bestAntecedentsIndex = j;
                        bestSupportBoundForAllAntecedents = bestFoundSupportBound;
                        maxPurityOfAllAntecedents = maxPurityForThisAntecedent;
                        continue;
                    }
                    finishedAntecedents[j] = true;
                    ++numFinishedAntecedents;
                }
                if (maxPurity <= maxPurityOfAllAntecedents) {
                    if (Double.isNaN(bestSupportBoundForAllAntecedents)) {
                        ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).supportBound = ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).splitPoint;
                    } else {
                        ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).supportBound = bestSupportBoundForAllAntecedents;
                        ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).fuzzyYet = true;
                    }
                    maxPurity = maxPurityOfAllAntecedents;
                }
                finishedAntecedents[bestAntecedentsIndex] = true;
            }
        }

        public void calculateConfidences(Instances data) {
            RipperRule tempRule = (RipperRule)this.copy();
            while (tempRule.hasAntds()) {
                double acc = 0.0;
                double cov = 0.0;
                for (int i = 0; i < data.numInstances(); ++i) {
                    double membershipValue = tempRule.coverageDegree(data.instance(i)) * data.instance(i).weight();
                    cov += membershipValue;
                    if (this.m_Consequent != data.instance(i).classValue()) continue;
                    acc += membershipValue;
                }
                double m = 2.0;
                ((Antd)this.m_Antds.elementAt((int)((int)tempRule.size() - 1))).m_confidence = (acc + m * (FURIA.this.aprioriDistribution[(int)this.m_Consequent] / Utils.sum(FURIA.this.aprioriDistribution))) / (cov + m);
                tempRule.m_Antds.removeElementAt(tempRule.m_Antds.size() - 1);
            }
        }

        public double getConfidence() {
            if (!this.hasAntds()) {
                return Double.NaN;
            }
            return ((Antd)this.m_Antds.lastElement()).m_confidence;
        }

        @Override
        public String getRevision() {
            return "1.0";
        }
    }

    protected class NominalAntd
    extends Antd {
        static final long serialVersionUID = -9102297038837585135L;
        private double[] accurate;
        private double[] coverage;

        public NominalAntd(Attribute a) {
            super(a);
            int bag = this.att.numValues();
            this.accurate = new double[bag];
            this.coverage = new double[bag];
        }

        @Override
        public Object copy() {
            NominalAntd antec = new NominalAntd(this.getAttr());
            antec.m_confidence = this.m_confidence;
            antec.value = this.value;
            return antec;
        }

        @Override
        public Instances[] splitData(Instances data, double defAcRt, double cl) {
            int x;
            int bag = this.att.numValues();
            Instances[] splitData = new Instances[bag];
            for (x = 0; x < bag; ++x) {
                splitData[x] = new Instances(data, data.numInstances());
                this.accurate[x] = 0.0;
                this.coverage[x] = 0.0;
            }
            for (x = 0; x < data.numInstances(); ++x) {
                Instance inst = data.instance(x);
                if (inst.isMissing(this.att)) continue;
                int v = (int)inst.value(this.att);
                splitData[v].add(inst);
                int n = v;
                this.coverage[n] = this.coverage[n] + inst.weight();
                if ((int)inst.classValue() != (int)cl) continue;
                int n2 = v;
                this.accurate[n2] = this.accurate[n2] + inst.weight();
            }
            for (x = 0; x < bag; ++x) {
                double p = this.accurate[x] + 1.0;
                double t = this.coverage[x] + 1.0;
                double infoGain = this.accurate[x] * (Utils.log2(p / t) - Utils.log2(defAcRt));
                if (!(infoGain > this.maxInfoGain)) continue;
                this.maxInfoGain = infoGain;
                this.cover = this.coverage[x];
                this.accu = this.accurate[x];
                this.accuRate = p / t;
                this.value = x;
            }
            return splitData;
        }

        @Override
        public double covers(Instance inst) {
            double isCover = 0.0;
            if (!inst.isMissing(this.att) && (int)inst.value(this.att) == (int)this.value) {
                isCover = 1.0;
            }
            return isCover;
        }

        @Override
        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }
    }

    public class NumericAntd
    extends Antd {
        static final long serialVersionUID = 5699457269983735442L;
        public double splitPoint;
        public double supportBound;
        public boolean fuzzyYet;

        public NumericAntd(Attribute a) {
            super(a);
            this.fuzzyYet = false;
            this.splitPoint = Double.NaN;
            this.supportBound = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        @Override
        public Object copy() {
            NumericAntd na = new NumericAntd(this.getAttr());
            na.m_confidence = this.m_confidence;
            na.value = this.value;
            na.splitPoint = this.splitPoint;
            na.supportBound = this.supportBound;
            na.fuzzyYet = this.fuzzyYet;
            return na;
        }

        @Override
        public Instances[] splitData(Instances insts, double defAcRt, double cl) {
            Instance inst;
            Instances data = insts;
            int total = data.numInstances();
            int split = 1;
            int prev = 0;
            int finalSplit = split;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double fstCover = 0.0;
            double sndCover = 0.0;
            double fstAccu = 0.0;
            double sndAccu = 0.0;
            data.sort(this.att);
            for (int x = 0; x < data.numInstances(); ++x) {
                inst = data.instance(x);
                if (inst.isMissing(this.att)) {
                    total = x;
                    break;
                }
                sndCover += inst.weight();
                if (!Utils.eq(inst.classValue(), cl)) continue;
                sndAccu += inst.weight();
            }
            if (total == 0) {
                return null;
            }
            this.splitPoint = data.instance(total - 1).value(this.att);
            while (split <= total) {
                if (split == total || data.instance(split).value(this.att) > data.instance(prev).value(this.att)) {
                    double coverage;
                    double accurate;
                    double accRate;
                    double infoGain;
                    boolean isFirst;
                    double sndInfoGain;
                    for (int y = prev; y < split; ++y) {
                        inst = data.instance(y);
                        fstCover += inst.weight();
                        if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                        fstAccu += inst.weight();
                    }
                    double fstAccuRate = (fstAccu + 1.0) / (fstCover + 1.0);
                    double sndAccuRate = (sndAccu + 1.0) / (sndCover + 1.0);
                    double fstInfoGain = fstAccu * (Utils.log2(fstAccuRate) - Utils.log2(defAcRt));
                    if (fstInfoGain > (sndInfoGain = sndAccu * (Utils.log2(sndAccuRate) - Utils.log2(defAcRt)))) {
                        isFirst = true;
                        infoGain = fstInfoGain;
                        accRate = fstAccuRate;
                        accurate = fstAccu;
                        coverage = fstCover;
                    } else {
                        isFirst = false;
                        infoGain = sndInfoGain;
                        accRate = sndAccuRate;
                        accurate = sndAccu;
                        coverage = sndCover;
                    }
                    if (infoGain > this.maxInfoGain) {
                        this.splitPoint = data.instance(prev).value(this.att);
                        this.value = isFirst ? 0.0 : 1.0;
                        this.accuRate = accRate;
                        this.accu = accurate;
                        this.cover = coverage;
                        this.maxInfoGain = infoGain;
                        finalSplit = isFirst ? split : prev;
                    }
                    for (int y = prev; y < split; ++y) {
                        Instance inst2 = data.instance(y);
                        sndCover -= inst2.weight();
                        if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                        sndAccu -= inst2.weight();
                    }
                    prev = split;
                }
                ++split;
            }
            Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit)};
            return splitData;
        }

        @Override
        public double covers(Instance inst) {
            double isCover = 0.0;
            if (!inst.isMissing(this.att)) {
                if ((int)this.value == 0) {
                    if (inst.value(this.att) <= this.splitPoint) {
                        isCover = 1.0;
                    } else if (this.fuzzyYet && inst.value(this.att) > this.splitPoint && inst.value(this.att) < this.supportBound) {
                        isCover = 1.0 - (inst.value(this.att) - this.splitPoint) / (this.supportBound - this.splitPoint);
                    }
                } else if (inst.value(this.att) >= this.splitPoint) {
                    isCover = 1.0;
                } else if (this.fuzzyYet && inst.value(this.att) < this.splitPoint && inst.value(this.att) > this.supportBound) {
                    isCover = 1.0 - (this.splitPoint - inst.value(this.att)) / (this.splitPoint - this.supportBound);
                }
            }
            return isCover;
        }

        @Override
        public String toString() {
            if (this.value == 0.0) {
                if (this.fuzzyYet) {
                    return this.att.name() + " in [-inf, -inf, " + Utils.doubleToString(this.splitPoint, 6) + ", " + Utils.doubleToString(this.supportBound, 6) + "]";
                }
                return this.att.name() + " in [-inf, " + Utils.doubleToString(this.splitPoint, 6) + "]";
            }
            if (this.fuzzyYet) {
                return this.att.name() + " in [" + Utils.doubleToString(this.supportBound, 6) + ", " + Utils.doubleToString(this.splitPoint, 6) + ", inf, inf]";
            }
            return this.att.name() + " in [" + Utils.doubleToString(this.splitPoint, 6) + ", inf]";
        }
    }

    protected abstract class Antd
    implements WeightedInstancesHandler,
    Copyable,
    Serializable {
        public Attribute att;
        public double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;
        double weightOfTheRuleWhenItIsPrunedAfterThisAntecedent = 0.0;
        public double m_confidence = 0.0;

        public Antd(Attribute a) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract double covers(Instance var1);

        public abstract String toString();

        @Override
        public abstract Object copy();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }
    }
}

