/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.util.Arrays;
import java.util.Comparator;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class MultiDimensionalSort
implements RevisionHandler {
    public static void multiDimensionalSort(Object[] a, Comparator[] c) {
        MultiDimensionalSort.multiDimensionalSort(a, 0, a.length, c);
    }

    public static void multiDimensionalSort(Object[] a, int fromIndex, int toIndex, Comparator[] c) throws IllegalArgumentException {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal range: fromIndex can be at most toIndex");
        }
        MultiDimensionalSort.multiDimensionalSort(a, fromIndex, toIndex, c, 0);
    }

    private static void multiDimensionalSort(Object[] a, int fromIndex, int toIndex, Comparator[] c, int depth) {
        if (depth == c.length) {
            return;
        }
        Comparator comp = c[depth];
        Arrays.sort(a, fromIndex, toIndex, comp);
        int mark = fromIndex;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (comp.compare(a[i - 1], a[i]) == 0) continue;
            MultiDimensionalSort.multiDimensionalSort(a, mark, i, c, depth + 1);
            mark = i;
        }
        MultiDimensionalSort.multiDimensionalSort(a, mark, toIndex, c, depth + 1);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }
}

