/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Coordinates
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 2319016195345994738L;
    private int[] m_coord;
    private int m_hashCode;

    public Coordinates(Instance instance) {
        double[] values = instance.toDoubleArray();
        int classIndex = instance.classIndex();
        this.m_coord = classIndex == -1 ? new int[values.length] : new int[values.length - 1];
        this.m_hashCode = 0;
        int factor = 1;
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i == classIndex) continue;
            this.m_coord[j] = (int)values[i];
            if (i > 0 && i - 1 != classIndex) {
                factor *= instance.attribute(i - 1).numValues();
            } else if (i - 1 == classIndex && classIndex != -1 && classIndex != 0) {
                factor *= instance.attribute(i - 2).numValues();
            }
            this.m_hashCode += this.m_coord[j] * factor;
            ++j;
        }
    }

    public double getValue(int index) {
        return this.m_coord[index];
    }

    public void getValues(double[] values) {
        for (int i = 0; i < this.m_coord.length; ++i) {
            values[i] = this.m_coord[i];
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Coordinates)) {
            return false;
        }
        Coordinates cc = (Coordinates)o;
        if (this.m_coord.length != cc.m_coord.length || this.m_hashCode != cc.m_hashCode) {
            return false;
        }
        for (int i = 0; i < this.m_coord.length; ++i) {
            if (this.m_coord[i] == cc.m_coord[i]) continue;
            return false;
        }
        return true;
    }

    public boolean strictlySmaller(Coordinates cc) throws IllegalArgumentException {
        int i;
        if (cc.m_coord.length != this.m_coord.length) {
            throw new IllegalArgumentException("Coordinates are not from the same space");
        }
        for (i = 0; i < this.m_coord.length && cc.m_coord[i] == this.m_coord[i]; ++i) {
        }
        if (i == this.m_coord.length) {
            return false;
        }
        while (i < this.m_coord.length) {
            if (this.m_coord[i] > cc.m_coord[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean smallerOrEqual(Coordinates cc) throws IllegalArgumentException {
        if (cc.m_coord.length != this.m_coord.length) {
            throw new IllegalArgumentException("Coordinates are not from the same space");
        }
        for (int i = 0; i < this.m_coord.length; ++i) {
            if (this.m_coord[i] <= cc.m_coord[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public int dimension() {
        return this.m_coord.length;
    }

    public String toString() {
        String s = "(";
        for (int i = 0; i < this.m_coord.length - 1; ++i) {
            s = s + this.m_coord[i] + ",";
        }
        return s + this.m_coord[this.m_coord.length - 1] + ")";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }
}

