/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableDistributionGenerator;
import weka.core.Option;
import weka.core.Utils;

public class MixedGaussianGenerator
extends RandomizableDistributionGenerator
implements NumericAttributeGenerator {
    private static final long serialVersionUID = 1516470615315381362L;
    protected double m_Distance = 3.0;
    protected boolean m_DistanceAbsolute = false;

    @Override
    public String globalInfo() {
        return "A mixed Gaussian artificial data generator.\n\nThis generator only has two Gaussians, each sitting 3 standard deviations (by default) away from the mean of the main distribution.  Each model has half of the probability.  The idea is that the two sub-models form a boundary either side of the main distribution.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        result.addElement(new Option("\tSets the difference between the mean and what will be used\n\ton the lower and higher distributions for the generator.\t(default: 3)", "di", 1, "-di <distance>"));
        result.addElement(new Option("\tIf set, the generator will use the absolute value of the\n\tdifference. If not set, it will multiply the difference by\n\tthe standard deviation.", "da", 0, "-da"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setDistanceAbsolute(Utils.getFlag("da", options));
        String tmpStr = Utils.getOption("di", options);
        if (tmpStr.length() != 0) {
            this.setDistance(Double.parseDouble(tmpStr));
        } else {
            this.setDistance(3.0);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getDistanceAbsolute()) {
            result.add("-da");
        }
        result.add("-di");
        result.add("" + this.m_Distance);
        return result.toArray(new String[result.size()]);
    }

    public double getDistance() {
        return this.m_Distance;
    }

    public void setDistance(double diff) {
        this.m_Distance = diff;
    }

    public String distanceTipText() {
        return "The difference between the main distribution and the models.";
    }

    public boolean getDistanceAbsolute() {
        return this.m_DistanceAbsolute;
    }

    public void setDistanceAbsolute(boolean newdiff) {
        this.m_DistanceAbsolute = newdiff;
    }

    public String distanceAbsoluteTipText() {
        return "If true, then the distance is absolute.";
    }

    @Override
    public double generate() {
        double difference = this.m_Distance;
        if (!this.m_DistanceAbsolute) {
            difference = this.m_StandardDeviation * this.m_Distance;
        }
        if (this.m_Random.nextBoolean()) {
            double gaussian = this.m_Random.nextGaussian();
            double value = this.m_Mean - difference + gaussian * this.m_StandardDeviation;
            return value;
        }
        double gaussian = this.m_Random.nextGaussian();
        double value = this.m_Mean + difference + gaussian * this.m_StandardDeviation;
        return value;
    }

    @Override
    public double getProbabilityOf(double valuex) {
        double difference = this.m_Distance;
        if (!this.m_DistanceAbsolute) {
            difference = this.m_StandardDeviation * this.m_Distance;
        }
        double prob1 = 0.5 * this.getProbability(valuex, this.m_Mean - difference, this.m_StandardDeviation);
        double prob2 = 0.5 * this.getProbability(valuex, this.m_Mean + difference, this.m_StandardDeviation);
        return prob1 + prob2;
    }

    public double getProbability(double valuex, double mean, double stddev) {
        double twopisqrt = Math.sqrt(Math.PI * 2);
        double left = 1.0 / (stddev * twopisqrt);
        double diffsquared = Math.pow(valuex - mean, 2.0);
        double bottomright = 2.0 * Math.pow(stddev, 2.0);
        double brackets = -1.0 * (diffsquared / bottomright);
        double probx = left * Math.exp(brackets);
        return probx;
    }

    @Override
    public double getLogProbabilityOf(double valuex) {
        return Math.log(this.getProbabilityOf(valuex));
    }
}

