/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Arrays;
import weka.classifiers.meta.generators.InstanceHandler;
import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class DiscreteUniformGenerator
extends RandomizableGenerator
implements InstanceHandler,
NumericAttributeGenerator {
    private static final long serialVersionUID = 3639933602298510366L;
    protected double[] m_Probabilities;

    @Override
    public String globalInfo() {
        return "An artificial data generator that uses discrete buckets for values.\n\nIn this discrete uniform generator, all buckets are given the same probability, regardless of how many values fall into each bucket.  This is not to be confused with the discrete generator which gives every bucket a probability based on how full the bucket is.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildGenerator(Instances someinstances) throws Exception {
        this.getCapabilities().testWithFail(someinstances);
        someinstances = new Instances(someinstances);
        someinstances.deleteWithMissing(0);
        double[] values = new double[someinstances.numInstances()];
        for (int i = 0; i < someinstances.numInstances(); ++i) {
            Instance aninst = someinstances.instance(i);
            values[i] = aninst.value(0);
        }
        Arrays.sort(values);
        double count = 1.0;
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == values[i - 1]) continue;
            count += 1.0;
        }
        double[] allvals = new double[(int)count];
        int position = 0;
        allvals[0] = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i] == values[i - 1]) continue;
            allvals[++position] = values[i];
        }
        this.m_Probabilities = allvals;
    }

    @Override
    public double generate() {
        double gap;
        double aprob = this.m_Random.nextDouble();
        int position = (int)(aprob / (gap = 1.0 / (double)this.m_Probabilities.length));
        if (position < 0) {
            position = 0;
        }
        if (position > this.m_Probabilities.length - 1) {
            position = this.m_Probabilities.length - 1;
        }
        return this.m_Probabilities[position];
    }

    @Override
    public double getProbabilityOf(double valuex) {
        for (int i = 0; i < this.m_Probabilities.length; ++i) {
            if (valuex != this.m_Probabilities[i]) continue;
            return 1.0 / ((double)this.m_Probabilities.length + 1.0);
        }
        return 1.0 / ((double)this.m_Probabilities.length + 1.0);
    }

    @Override
    public double getLogProbabilityOf(double valuex) {
        return Math.log(this.getProbabilityOf(valuex));
    }
}

