/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class LBR
extends AbstractClassifier
implements TechnicalInformationHandler {
    static final long serialVersionUID = 5648559277738985156L;
    protected int[][][] m_Counts;
    protected int[][][] m_tCounts;
    protected int[] m_Priors;
    protected int[] m_tPriors;
    protected int m_numAtts;
    protected int m_numClasses;
    protected int m_numInsts;
    protected Instances m_Instances = null;
    protected int m_Errors;
    protected boolean[] m_ErrorFlags;
    protected ArrayList leftHand = new ArrayList();
    protected static final double SIGNLOWER = 0.05;
    protected boolean[] m_subOldErrorFlags;
    protected int m_RemainderErrors = 0;
    protected int m_Number = 0;
    protected int m_NumberOfInstances = 0;
    protected boolean m_NCV = false;
    protected Indexes m_subInstances;
    protected Indexes tempSubInstances;
    protected double[] posteriorsArray;
    protected int bestCnt;
    protected int tempCnt;
    protected int forCnt;
    protected int whileCnt;

    public String globalInfo() {
        return "Lazy Bayesian Rules Classifier. The naive Bayesian classifier provides a simple and effective approach to classifier learning, but its attribute independence assumption is often violated in the real world. Lazy Bayesian Rules selectively relaxes the independence assumption, achieving lower error rates over a range of learning tasks. LBR defers processing to classification time, making it a highly efficient and accurate classification algorithm when small numbers of objects are to be classified.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Zijian Zheng and G. Webb");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.TITLE, "Lazy Learning of Bayesian Rules");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "4");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "53-84");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        int attIndex;
        this.bestCnt = 0;
        this.tempCnt = 0;
        this.forCnt = 0;
        this.whileCnt = 0;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_numAtts = instances.numAttributes();
        this.m_numClasses = instances.numClasses();
        this.m_numInsts = instances.numInstances();
        this.m_Counts = new int[this.m_numClasses][this.m_numAtts][0];
        this.m_Priors = new int[this.m_numClasses];
        this.m_tCounts = new int[this.m_numClasses][this.m_numAtts][0];
        this.m_tPriors = new int[this.m_numClasses];
        this.m_subOldErrorFlags = new boolean[this.m_numInsts + 1];
        this.m_Instances = instances;
        this.m_subInstances = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        this.tempSubInstances = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        this.posteriorsArray = new double[this.m_numClasses];
        for (attIndex = 0; attIndex < this.m_numAtts; ++attIndex) {
            Attribute attribute = instances.attribute(attIndex);
            for (int j = 0; j < this.m_numClasses; ++j) {
                this.m_Counts[j][attIndex] = new int[attribute.numValues()];
                this.m_tCounts[j][attIndex] = new int[attribute.numValues()];
            }
        }
        for (int i = 0; i < this.m_numInsts; ++i) {
            Instance instance = instances.instance(i);
            int classValue = (int)instance.classValue();
            int[][] countsPointer = this.m_tCounts[classValue];
            for (attIndex = 0; attIndex < this.m_numAtts; ++attIndex) {
                int[] nArray = countsPointer[attIndex];
                int n = (int)instance.value(attIndex);
                nArray[n] = nArray[n] + 1;
            }
            int n = classValue;
            this.m_tPriors[n] = this.m_tPriors[n] + 1;
        }
        this.m_ErrorFlags = new boolean[this.m_numInsts];
        this.m_Errors = this.leaveOneOut(this.m_subInstances, this.m_tCounts, this.m_tPriors, this.m_ErrorFlags);
        if (this.m_Number == 0) {
            this.m_NumberOfInstances = this.m_Instances.numInstances();
        } else {
            System.out.println(" ");
            System.out.println("N-Fold Cross Validation: ");
            this.m_NCV = true;
        }
    }

    @Override
    public double[] distributionForInstance(Instance testInstance) throws Exception {
        int subAttrIndex = 0;
        int subInstIndex = 0;
        int tempInstIndex = 0;
        int subLocalErrors = 0;
        int tempErrorsBest = 0;
        boolean[] tempErrorFlagBest = null;
        int[] tempD_subsetBestInsts = null;
        int[] tempD_subsetBestAtts = null;
        Indexes subInstances = new Indexes(this.m_numInsts, this.m_numAtts, true, this.m_Instances.classIndex());
        boolean[] subLocalErrorFlags = new boolean[subInstances.getNumInstances() + 1];
        int localErrors = this.m_Errors;
        boolean[] localErrorFlags = (boolean[])this.m_ErrorFlags.clone();
        int errorsNewNotOld = 0;
        int errorsOldNotNew = 0;
        this.leftHand.clear();
        while (localErrors >= 5) {
            int attributeBest = -1;
            ++this.whileCnt;
            tempErrorsBest = subInstances.getNumInstancesSet() + 1;
            subInstances.setSequentialDataset(true);
            for (int attr = 0; attr < subInstances.m_NumSeqAttsSet; ++attr) {
                ++this.forCnt;
                subAttrIndex = subInstances.m_SequentialAttIndexes[attr];
                this.m_RemainderErrors = 0;
                for (int i = 0; i < this.m_numInsts; ++i) {
                    this.m_subOldErrorFlags[i] = true;
                }
                this.tempSubInstances.resetDatasetBasedOn(subInstances);
                for (int inst = 0; inst < subInstances.m_NumSeqInstsSet; ++inst) {
                    subInstIndex = subInstances.m_SequentialInstIndexes[inst];
                    if (this.m_Instances.instance(subInstIndex).value(subAttrIndex) == testInstance.value(subAttrIndex)) {
                        this.tempSubInstances.setInstanceIndex(subInstIndex, true);
                        if (localErrorFlags[subInstIndex]) continue;
                        this.m_subOldErrorFlags[subInstIndex] = false;
                        continue;
                    }
                    if (localErrorFlags[subInstIndex]) continue;
                    ++this.m_RemainderErrors;
                }
                if (this.tempSubInstances.m_NumInstsSet >= subInstances.m_NumInstsSet) continue;
                this.tempSubInstances.setAttIndex(subAttrIndex, false);
                this.localNaiveBayes(this.tempSubInstances);
                subLocalErrors = this.leaveOneOut(this.tempSubInstances, this.m_Counts, this.m_Priors, subLocalErrorFlags);
                errorsNewNotOld = 0;
                errorsOldNotNew = 0;
                this.tempSubInstances.setSequentialDataset(true);
                for (int t_inst = 0; t_inst < this.tempSubInstances.m_NumSeqInstsSet; ++t_inst) {
                    tempInstIndex = this.tempSubInstances.m_SequentialInstIndexes[t_inst];
                    if (!subLocalErrorFlags[tempInstIndex]) {
                        if (!this.m_subOldErrorFlags[tempInstIndex]) continue;
                        ++errorsNewNotOld;
                        continue;
                    }
                    if (this.m_subOldErrorFlags[tempInstIndex]) continue;
                    ++errorsOldNotNew;
                }
                int tempErrors = subLocalErrors + this.m_RemainderErrors;
                if (tempErrors >= tempErrorsBest || !(this.binomP(errorsNewNotOld, errorsNewNotOld + errorsOldNotNew, 0.5) < 0.05)) continue;
                ++this.tempCnt;
                this.tempSubInstances.setSequentialDataset(true);
                tempD_subsetBestInsts = (int[])this.tempSubInstances.m_SequentialInstIndexes.clone();
                tempD_subsetBestAtts = (int[])this.tempSubInstances.m_SequentialAttIndexes.clone();
                tempErrorsBest = tempErrors;
                tempErrorFlagBest = (boolean[])subLocalErrorFlags.clone();
                attributeBest = subAttrIndex;
            }
            if (attributeBest == -1) break;
            ++this.bestCnt;
            this.leftHand.add(testInstance.attribute(attributeBest));
            subInstances.setInsts(tempD_subsetBestInsts, true);
            subInstances.setAtts(tempD_subsetBestAtts, true);
            subInstances.setAttIndex(attributeBest, false);
            localErrors = tempErrorsBest;
            localErrorFlags = tempErrorFlagBest;
        }
        this.localNaiveBayes(subInstances);
        return this.localDistributionForInstance(testInstance, subInstances);
    }

    public String toString() {
        if (this.m_Instances == null) {
            return "Lazy Bayesian Rule: No model built yet.";
        }
        try {
            StringBuffer text = new StringBuffer("=== LBR Run information ===\n\n");
            text.append("Scheme:       weka.classifiers.LBR\n");
            text.append("Relation:     " + this.m_Instances.attribute(this.m_Instances.classIndex()).name() + "\n");
            text.append("Instances:    " + this.m_Instances.numInstances() + "\n");
            text.append("Attributes:   " + this.m_Instances.numAttributes() + "\n");
            return text.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Can't Print Lazy Bayes Rule Classifier!";
        }
    }

    public int leaveOneOut(Indexes instanceIndex, int[][][] counts, int[] priors, boolean[] errorFlags) throws Exception {
        double max = 0.0;
        int maxIndex = 0;
        int errors = 0;
        instanceIndex.setSequentialDataset(true);
        int[] tempAttributeValues = new int[instanceIndex.m_NumSeqAttsSet + 1];
        for (int inst = 0; inst < instanceIndex.m_NumSeqInstsSet; ++inst) {
            int AIndex;
            int attIndex;
            int instIndex = instanceIndex.m_SequentialInstIndexes[inst];
            Instance tempInstance = this.m_Instances.instance(instIndex);
            if (tempInstance.classIsMissing()) continue;
            int tempInstanceClassValue = (int)tempInstance.classValue();
            int[][] countsPointer = counts[tempInstanceClassValue];
            for (attIndex = 0; attIndex < instanceIndex.m_NumSeqAttsSet; ++attIndex) {
                AIndex = instanceIndex.m_SequentialAttIndexes[attIndex];
                tempAttributeValues[attIndex] = (int)tempInstance.value(AIndex);
                int[] nArray = countsPointer[AIndex];
                int n = tempAttributeValues[attIndex];
                nArray[n] = nArray[n] - 1;
            }
            int n = tempInstanceClassValue;
            priors[n] = priors[n] - 1;
            max = 0.0;
            maxIndex = 0;
            double sumForPriors = Utils.sum(priors);
            for (int clss = 0; clss < this.m_numClasses; ++clss) {
                double posteriors = 0.0;
                posteriors = (double)(priors[clss] + 1) / (sumForPriors + (double)this.m_numClasses);
                countsPointer = counts[clss];
                for (attIndex = 0; attIndex < instanceIndex.m_NumSeqAttsSet; ++attIndex) {
                    AIndex = instanceIndex.m_SequentialAttIndexes[attIndex];
                    if (tempInstance.isMissing(AIndex)) continue;
                    double sumForCounts = Utils.sum(countsPointer[AIndex]);
                    posteriors *= (double)(countsPointer[AIndex][tempAttributeValues[attIndex]] + 1) / (sumForCounts + (double)tempInstance.attribute(AIndex).numValues());
                }
                if (!(posteriors > max)) continue;
                maxIndex = clss;
                max = posteriors;
            }
            int tempClassValue = max > 0.0 ? maxIndex : (int)Utils.missingValue();
            if (tempClassValue == tempInstanceClassValue) {
                errorFlags[instIndex] = true;
            } else {
                errorFlags[instIndex] = false;
                ++errors;
            }
            countsPointer = counts[tempInstanceClassValue];
            for (attIndex = 0; attIndex < instanceIndex.m_NumSeqAttsSet; ++attIndex) {
                AIndex = instanceIndex.m_SequentialAttIndexes[attIndex];
                int[] nArray = counts[tempInstanceClassValue][AIndex];
                int n2 = tempAttributeValues[attIndex];
                nArray[n2] = nArray[n2] + 1;
            }
            int n3 = tempInstanceClassValue;
            priors[n3] = priors[n3] + 1;
        }
        return errors;
    }

    public void localNaiveBayes(Indexes instanceIndex) throws Exception {
        int attIndex = 0;
        int attVal = 0;
        int classVal = 0;
        instanceIndex.setSequentialDataset(true);
        for (classVal = 0; classVal < this.m_numClasses; ++classVal) {
            int[][] countsPointer1 = this.m_Counts[classVal];
            for (attIndex = 0; attIndex < this.m_numAtts; ++attIndex) {
                Attribute attribute = this.m_Instances.attribute(attIndex);
                int[] countsPointer2 = countsPointer1[attIndex];
                for (attVal = 0; attVal < attribute.numValues(); ++attVal) {
                    countsPointer2[attVal] = 0;
                }
            }
            this.m_Priors[classVal] = 0;
        }
        for (int i = 0; i < instanceIndex.m_NumSeqInstsSet; ++i) {
            Instance instance = this.m_Instances.instance(instanceIndex.m_SequentialInstIndexes[i]);
            for (attIndex = 0; attIndex < instanceIndex.m_NumSeqAttsSet; ++attIndex) {
                int AIndex = instanceIndex.m_SequentialAttIndexes[attIndex];
                int[] nArray = this.m_Counts[(int)instance.classValue()][AIndex];
                int n = (int)instance.value(AIndex);
                nArray[n] = nArray[n] + 1;
            }
            int n = (int)instance.classValue();
            this.m_Priors[n] = this.m_Priors[n] + 1;
        }
    }

    public double[] localDistributionForInstance(Instance instance, Indexes instanceIndex) throws Exception {
        double sumForPriors = 0.0;
        double sumForCounts = 0.0;
        int numClassesOfInstance = instance.numClasses();
        sumForPriors = 0.0;
        sumForCounts = 0.0;
        instanceIndex.setSequentialDataset(true);
        sumForPriors = Utils.sum(this.m_Priors) + numClassesOfInstance;
        for (int j = 0; j < numClassesOfInstance; ++j) {
            int[][] countsPointer = this.m_Counts[j];
            this.posteriorsArray[j] = (double)(this.m_Priors[j] + 1) / sumForPriors;
            for (int attIndex = 0; attIndex < instanceIndex.m_NumSeqAttsSet; ++attIndex) {
                int AIndex = instanceIndex.m_SequentialAttIndexes[attIndex];
                sumForCounts = Utils.sum(countsPointer[AIndex]);
                if (instance.isMissing(AIndex)) continue;
                int n = j;
                this.posteriorsArray[n] = this.posteriorsArray[n] * ((double)(countsPointer[AIndex][(int)instance.value(AIndex)] + 1) / (sumForCounts + (double)instance.attribute(AIndex).numValues()));
            }
        }
        Utils.normalize(this.posteriorsArray);
        return this.posteriorsArray;
    }

    public double binomP(double r, double n, double p) throws Exception {
        if (n == r) {
            return 1.0;
        }
        return Statistics.incompleteBeta(n - r, r + 1.0, 1.0 - p);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        LBR.runClassifier(new LBR(), argv);
    }

    public class Indexes
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -2771490019751421307L;
        public boolean[] m_InstIndexes;
        public boolean[] m_AttIndexes;
        private int m_NumInstances;
        private int m_NumAtts;
        public int[] m_SequentialInstIndexes;
        public int[] m_SequentialAttIndexes;
        private boolean m_SequentialInstanceIndex_valid = false;
        private boolean m_SequentialAttIndex_valid = false;
        public int m_NumInstsSet;
        public int m_NumAttsSet;
        public int m_NumSeqInstsSet;
        public int m_NumSeqAttsSet;
        public int m_ClassIndex;

        public Indexes(int numInstances, int numAtts, boolean value, int classIndex) {
            int i;
            this.m_NumInstsSet = this.m_NumInstances = numInstances;
            this.m_NumAttsSet = this.m_NumAtts = numAtts;
            this.m_InstIndexes = new boolean[numInstances];
            for (i = 0; i < numInstances; ++i) {
                this.m_InstIndexes[i] = value;
            }
            this.m_AttIndexes = new boolean[numAtts];
            for (i = 0; i < numAtts; ++i) {
                this.m_AttIndexes[i] = true;
            }
            if (!value) {
                this.m_NumInstsSet = 0;
            }
            this.m_SequentialInstanceIndex_valid = false;
            this.m_SequentialAttIndex_valid = false;
            if (classIndex != -1) {
                this.setAttIndex(classIndex, false);
            }
            this.m_ClassIndex = classIndex;
        }

        public Indexes(Indexes FromIndexes) {
            this.m_NumInstances = FromIndexes.getNumInstances();
            this.m_NumInstsSet = FromIndexes.m_NumInstsSet;
            this.m_NumAtts = FromIndexes.m_NumAtts;
            this.m_NumAttsSet = FromIndexes.m_NumAttsSet;
            this.m_InstIndexes = new boolean[this.m_NumInstances];
            System.arraycopy(FromIndexes.m_InstIndexes, 0, this.m_InstIndexes, 0, this.m_NumInstances);
            this.m_AttIndexes = new boolean[this.m_NumAtts];
            System.arraycopy(FromIndexes.m_AttIndexes, 0, this.m_AttIndexes, 0, this.m_NumAtts);
            this.m_ClassIndex = FromIndexes.m_ClassIndex;
            this.m_SequentialInstanceIndex_valid = false;
            this.m_SequentialAttIndex_valid = false;
        }

        public void setInstanceIndex(int index, boolean value) {
            if (index < 0 || index >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid Instance Index value");
            }
            if (this.m_InstIndexes[index] != value) {
                this.m_InstIndexes[index] = value;
                this.m_SequentialInstanceIndex_valid = false;
                this.m_NumInstsSet = !value ? --this.m_NumInstsSet : ++this.m_NumInstsSet;
            }
        }

        public void setAtts(int[] Attributes, boolean value) {
            int i;
            for (i = 0; i < this.m_NumAtts; ++i) {
                this.m_AttIndexes[i] = !value;
            }
            for (i = 0; i < Attributes.length; ++i) {
                this.m_AttIndexes[Attributes[i]] = value;
            }
            this.m_NumAttsSet = Attributes.length;
            this.m_SequentialAttIndex_valid = false;
        }

        public void setInsts(int[] Instances2, boolean value) {
            this.resetInstanceIndex(!value);
            for (int i = 0; i < Instances2.length; ++i) {
                this.m_InstIndexes[Instances2[i]] = value;
            }
            this.m_NumInstsSet = Instances2.length;
            this.m_SequentialInstanceIndex_valid = false;
        }

        public void setAttIndex(int index, boolean value) {
            if (index < 0 || index >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid Attribute Index value");
            }
            if (this.m_AttIndexes[index] != value) {
                this.m_AttIndexes[index] = value;
                this.m_SequentialAttIndex_valid = false;
                this.m_NumAttsSet = !value ? --this.m_NumAttsSet : ++this.m_NumAttsSet;
            }
        }

        public boolean getInstanceIndex(int index) {
            if (index < 0 || index >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_InstIndexes[index];
        }

        public int getSequentialInstanceIndex(int index) {
            if (index < 0 || index >= this.m_NumInstances) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_SequentialInstIndexes[index];
        }

        public void resetInstanceIndex(boolean value) {
            this.m_NumInstsSet = this.m_NumInstances;
            for (int i = 0; i < this.m_NumInstances; ++i) {
                this.m_InstIndexes[i] = value;
            }
            if (!value) {
                this.m_NumInstsSet = 0;
            }
            this.m_SequentialInstanceIndex_valid = false;
        }

        public void resetDatasetBasedOn(Indexes FromIndexes) {
            this.resetInstanceIndex(false);
            this.resetAttIndexTo(FromIndexes);
        }

        public void resetAttIndex(boolean value) {
            this.m_NumAttsSet = this.m_NumAtts;
            for (int i = 0; i < this.m_NumAtts; ++i) {
                this.m_AttIndexes[i] = value;
            }
            if (this.m_ClassIndex != -1) {
                this.setAttIndex(this.m_ClassIndex, false);
            }
            if (!value) {
                this.m_NumAttsSet = 0;
            }
            this.m_SequentialAttIndex_valid = false;
        }

        public void resetAttIndexTo(Indexes FromIndexes) {
            System.arraycopy(FromIndexes.m_AttIndexes, 0, this.m_AttIndexes, 0, this.m_NumAtts);
            this.m_NumAttsSet = FromIndexes.getNumAttributesSet();
            this.m_ClassIndex = FromIndexes.m_ClassIndex;
            this.m_SequentialAttIndex_valid = false;
        }

        public boolean getAttIndex(int index) {
            if (index < 0 || index >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_AttIndexes[index];
        }

        public int getSequentialAttIndex(int index) {
            if (index < 0 || index >= this.m_NumAtts) {
                throw new IllegalArgumentException("Invalid index value");
            }
            return this.m_SequentialAttIndexes[index];
        }

        public int getNumInstancesSet() {
            return this.m_NumInstsSet;
        }

        public int getNumInstances() {
            return this.m_NumInstances;
        }

        public int getSequentialNumInstances() {
            return this.m_NumSeqInstsSet;
        }

        public int getNumAttributes() {
            return this.m_NumAtts;
        }

        public int getNumAttributesSet() {
            return this.m_NumAttsSet;
        }

        public int getSequentialNumAttributes() {
            return this.m_NumSeqAttsSet;
        }

        public boolean isSequentialInstanceIndexValid() {
            return this.m_SequentialInstanceIndex_valid;
        }

        public boolean isSequentialAttIndexValid() {
            return this.m_SequentialAttIndex_valid;
        }

        public void setSequentialDataset(boolean value) {
            this.setSequentialInstanceIndex(value);
            this.setSequentialAttIndex(value);
        }

        public void setSequentialInstanceIndex(boolean value) {
            if (this.m_SequentialInstanceIndex_valid) {
                return;
            }
            int size = this.m_NumInstsSet;
            this.m_SequentialInstIndexes = new int[size];
            int j = 0;
            for (int i = 0; i < this.m_NumInstances; ++i) {
                if (this.m_InstIndexes[i] != value) continue;
                this.m_SequentialInstIndexes[j] = i;
                ++j;
            }
            this.m_SequentialInstanceIndex_valid = true;
            this.m_NumSeqInstsSet = j;
        }

        public void setSequentialAttIndex(boolean value) {
            if (this.m_SequentialAttIndex_valid) {
                return;
            }
            int size = this.m_NumAttsSet;
            this.m_SequentialAttIndexes = new int[size];
            int j = 0;
            for (int i = 0; i < this.m_NumAtts; ++i) {
                if (this.m_AttIndexes[i] != value) continue;
                this.m_SequentialAttIndexes[j] = i;
                ++j;
            }
            this.m_SequentialAttIndex_valid = true;
            this.m_NumSeqAttsSet = j;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5987 $");
        }
    }
}

