/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class IsotonicRegression
extends AbstractClassifier
implements WeightedInstancesHandler {
    static final long serialVersionUID = 1679336022835454137L;
    private Attribute m_attribute;
    private double[] m_cuts;
    private double[] m_values;
    private double m_minMsq;
    private Classifier m_ZeroR;

    public String globalInfo() {
        return "Learns an isotonic regression model. Picks the attribute that results in the lowest squared error. Missing values are not allowed. Can only deal with numeric attributes.Considers the monotonically increasing case as well as the monotonicallydecreasing case";
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.classifyInstance(inst);
        }
        if (inst.isMissing(this.m_attribute.index())) {
            throw new Exception("IsotonicRegression: No missing values!");
        }
        int index = Arrays.binarySearch(this.m_cuts, inst.value(this.m_attribute));
        if (index < 0) {
            return this.m_values[-index - 1];
        }
        return this.m_values[index + 1];
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    protected void regress(Attribute attribute, Instances insts, boolean ascending) throws Exception {
        boolean violators;
        insts.sort(attribute);
        double[] values = new double[insts.numInstances()];
        double[] weights = new double[insts.numInstances()];
        double[] cuts = new double[insts.numInstances() - 1];
        int size = 0;
        values[0] = insts.instance(0).classValue();
        weights[0] = insts.instance(0).weight();
        for (int i = 1; i < insts.numInstances(); ++i) {
            if (insts.instance(i).value(attribute) > insts.instance(i - 1).value(attribute)) {
                cuts[size] = (insts.instance(i).value(attribute) + insts.instance(i - 1).value(attribute)) / 2.0;
            }
            int n = ++size;
            values[n] = values[n] + insts.instance(i).classValue();
            int n2 = size;
            weights[n2] = weights[n2] + insts.instance(i).weight();
        }
        ++size;
        do {
            violators = false;
            double[] tempValues = new double[size];
            double[] tempWeights = new double[size];
            double[] tempCuts = new double[size - 1];
            int newSize = 0;
            tempValues[0] = values[0];
            tempWeights[0] = weights[0];
            for (int j = 1; j < size; ++j) {
                if (ascending && values[j] / weights[j] > tempValues[newSize] / tempWeights[newSize] || !ascending && values[j] / weights[j] < tempValues[newSize] / tempWeights[newSize]) {
                    tempCuts[newSize] = cuts[j - 1];
                    tempValues[++newSize] = values[j];
                    tempWeights[newSize] = weights[j];
                    continue;
                }
                int n = newSize;
                tempWeights[n] = tempWeights[n] + weights[j];
                int n3 = newSize;
                tempValues[n3] = tempValues[n3] + values[j];
                violators = true;
            }
            values = tempValues;
            weights = tempWeights;
            cuts = tempCuts;
            size = ++newSize;
        } while (violators);
        for (int i = 0; i < size; ++i) {
            int n = i;
            values[n] = values[n] / weights[i];
        }
        Attribute attributeBackedup = this.m_attribute;
        double[] cutsBackedup = this.m_cuts;
        double[] valuesBackedup = this.m_values;
        this.m_attribute = attribute;
        this.m_cuts = cuts;
        this.m_values = values;
        Evaluation eval = new Evaluation(insts);
        eval.evaluateModel(this, insts, new Object[0]);
        double msq = eval.rootMeanSquaredError();
        if (msq < this.m_minMsq) {
            this.m_minMsq = msq;
        } else {
            this.m_attribute = attributeBackedup;
            this.m_cuts = cutsBackedup;
            this.m_values = valuesBackedup;
        }
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        this.getCapabilities().testWithFail(insts);
        insts = new Instances(insts);
        insts.deleteWithMissingClass();
        if (insts.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(insts);
            return;
        }
        this.m_ZeroR = null;
        this.m_minMsq = Double.MAX_VALUE;
        this.m_attribute = null;
        for (int a = 0; a < insts.numAttributes(); ++a) {
            if (a == insts.classIndex()) continue;
            this.regress(insts.attribute(a), insts, true);
            this.regress(insts.attribute(a), insts, false);
        }
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        StringBuffer text = new StringBuffer();
        text.append("Isotonic regression\n\n");
        if (this.m_attribute == null) {
            text.append("No model built yet!");
        } else {
            text.append("Based on attribute: " + this.m_attribute.name() + "\n\n");
            for (int i = 0; i < this.m_values.length; ++i) {
                text.append("prediction: " + Utils.doubleToString(this.m_values[i], 10, 2));
                if (i >= this.m_cuts.length) continue;
                text.append("\t\tcut point: " + Utils.doubleToString(this.m_cuts[i], 10, 2) + "\n");
            }
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        IsotonicRegression.runClassifier(new IsotonicRegression(), argv);
    }
}

