/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeSetEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class SymmetricalUncertAttributeSetEval
extends AttributeSetEvaluator
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 8351377335495873202L;
    private Instances m_trainInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private int m_numClasses;
    private boolean m_missing_merge;

    public String globalInfo() {
        return "SymmetricalUncertAttributeSetEval :\n\nEvaluates the worth of a set attributes by measuring the symmetrical uncertainty with respect to another set of attributes. \n\n SymmU(AttributeSet2, AttributeSet1) = 2 * (H(AttributeSet2) - H(AttributeSet1 | AttributeSet2)) / H(AttributeSet2) + H(AttributeSet1).\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lei Yu and Huan Liu");
        result.setValue(TechnicalInformation.Field.TITLE, "Feature Selection for High-Dimensional Data: A Fast Correlation-Based Filter Solution");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Twentieth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PAGES, "856-863");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return result;
    }

    public SymmetricalUncertAttributeSetEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', options));
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean b) {
        this.m_missing_merge = b;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[1];
        int current = 0;
        if (!this.getMissingMerge()) {
            options[current++] = "-M";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = data;
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        Discretize disTransform = new Discretize();
        disTransform.setUseBetterEncoding(true);
        disTransform.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, disTransform);
        this.m_numClasses = this.m_trainInstances.attribute(this.m_classIndex).numValues();
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missing_merge = true;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        int j;
        int i;
        double sum = 0.0;
        int ni = this.m_trainInstances.attribute(attribute).numValues() + 1;
        int nj = this.m_numClasses + 1;
        double temp = 0.0;
        double[] sumi = new double[ni];
        double[] sumj = new double[nj];
        double[][] counts = new double[ni][nj];
        sumi = new double[ni];
        sumj = new double[nj];
        for (i = 0; i < ni; ++i) {
            sumi[i] = 0.0;
            for (j = 0; j < nj; ++j) {
                sumj[j] = 0.0;
                counts[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.m_numInstances; ++i) {
            Instance inst = this.m_trainInstances.instance(i);
            int ii = inst.isMissing(attribute) ? ni - 1 : (int)inst.value(attribute);
            int jj = inst.isMissing(this.m_classIndex) ? nj - 1 : (int)inst.value(this.m_classIndex);
            double[] dArray = counts[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
        }
        for (i = 0; i < ni; ++i) {
            sumi[i] = 0.0;
            for (j = 0; j < nj; ++j) {
                int n = i;
                sumi[n] = sumi[n] + counts[i][j];
                sum += counts[i][j];
            }
        }
        for (j = 0; j < nj; ++j) {
            sumj[j] = 0.0;
            for (i = 0; i < ni; ++i) {
                int n = j;
                sumj[n] = sumj[n] + counts[i][j];
            }
        }
        if (this.m_missing_merge && sumi[ni - 1] < (double)this.m_numInstances && sumj[nj - 1] < (double)this.m_numInstances) {
            double[] i_copy = new double[sumi.length];
            double[] j_copy = new double[sumj.length];
            double[][] counts_copy = new double[sumi.length][sumj.length];
            for (i = 0; i < ni; ++i) {
                System.arraycopy(counts[i], 0, counts_copy[i], 0, sumj.length);
            }
            System.arraycopy(sumi, 0, i_copy, 0, sumi.length);
            System.arraycopy(sumj, 0, j_copy, 0, sumj.length);
            double total_missing = sumi[ni - 1] + sumj[nj - 1] - counts[ni - 1][nj - 1];
            if (sumi[ni - 1] > 0.0) {
                for (j = 0; j < nj - 1; ++j) {
                    if (!(counts[ni - 1][j] > 0.0)) continue;
                    i = 0;
                    while (i < ni - 1) {
                        temp = i_copy[i] / (sum - i_copy[ni - 1]) * counts[ni - 1][j];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n2 = i++;
                        sumi[n2] = sumi[n2] + temp;
                    }
                    counts[ni - 1][j] = 0.0;
                }
            }
            sumi[ni - 1] = 0.0;
            if (sumj[nj - 1] > 0.0) {
                for (i = 0; i < ni - 1; ++i) {
                    if (!(counts[i][nj - 1] > 0.0)) continue;
                    j = 0;
                    while (j < nj - 1) {
                        temp = j_copy[j] / (sum - j_copy[nj - 1]) * counts[i][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n3 = j++;
                        sumj[n3] = sumj[n3] + temp;
                    }
                    counts[i][nj - 1] = 0.0;
                }
            }
            sumj[nj - 1] = 0.0;
            if (counts[ni - 1][nj - 1] > 0.0 && total_missing != sum) {
                for (i = 0; i < ni - 1; ++i) {
                    j = 0;
                    while (j < nj - 1) {
                        temp = counts_copy[i][j] / (sum - total_missing) * counts_copy[ni - 1][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n4 = i;
                        sumi[n4] = sumi[n4] + temp;
                        int n5 = j++;
                        sumj[n5] = sumj[n5] + temp;
                    }
                }
                counts[ni - 1][nj - 1] = 0.0;
            }
        }
        return ContingencyTables.symmetricalUncertainty(counts);
    }

    @Override
    public double evaluateAttribute(int[] attributes, int[] classAttributes) throws Exception {
        int j;
        int i;
        double sum = 0.0;
        boolean b_missing_attribute = false;
        boolean b_missing_classAtrribute = false;
        if (attributes.length == 0) {
            throw new Exception("the parameter attributes[] is empty;SEQ:W-FS-Eval-SUAS-001");
        }
        if (classAttributes.length == 0) {
            throw new Exception("the parameter classAttributes[] is empty;SEQ:W-FS-Eval-SUAS-002");
        }
        int ni = this.m_trainInstances.attribute(attributes[0]).numValues();
        if (ni == 0) {
            throw new Exception("an attribute is empty;SEQ:W-FS-Eval-SUAS-003;1");
        }
        for (i = 1; i < attributes.length; ++i) {
            if (this.m_trainInstances.attribute(attributes[i]).numValues() == 0) {
                throw new Exception("an attribute is empty;SEQ:W-FS-Eval-SUAS-003;" + (i + 1));
            }
            ni *= this.m_trainInstances.attribute(attributes[i]).numValues();
        }
        ++ni;
        int nj = this.m_trainInstances.attribute(classAttributes[0]).numValues();
        if (nj == 0) {
            throw new Exception("the a classAttribute is empty;SEQ:W-FS-Eval-SUAS-004;1");
        }
        for (i = 1; i < classAttributes.length; ++i) {
            if (this.m_trainInstances.attribute(classAttributes[i]).numValues() == 0) {
                throw new Exception("the a classAttribute is empty;SEQ:W-FS-Eval-SUAS-004;" + (i + 1));
            }
            nj *= this.m_trainInstances.attribute(classAttributes[i]).numValues();
        }
        double temp = 0.0;
        double[] sumi = new double[ni];
        double[] sumj = new double[++nj];
        double[][] counts = new double[ni][nj];
        sumi = new double[ni];
        sumj = new double[nj];
        for (i = 0; i < ni; ++i) {
            sumi[i] = 0.0;
            for (j = 0; j < nj; ++j) {
                sumj[j] = 0.0;
                counts[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.m_numInstances; ++i) {
            int p;
            Instance inst = this.m_trainInstances.instance(i);
            b_missing_attribute = false;
            b_missing_classAtrribute = false;
            int nni = 1;
            int ii = 0;
            for (p = attributes.length - 1; p >= 0; --p) {
                if (inst.isMissing(attributes[p])) {
                    b_missing_attribute = true;
                }
                ii = (int)inst.value(attributes[p]) * nni + ii;
                if (p < attributes.length - 1) {
                    nni *= this.m_trainInstances.attribute(attributes[p]).numValues();
                    continue;
                }
                nni = this.m_trainInstances.attribute(attributes[p]).numValues();
            }
            if (b_missing_attribute) {
                ii = ni - 1;
            }
            int nnj = 1;
            int jj = 0;
            for (p = classAttributes.length - 1; p >= 0; --p) {
                if (inst.isMissing(classAttributes[p])) {
                    b_missing_classAtrribute = true;
                }
                jj = (int)inst.value(classAttributes[p]) * nnj + jj;
                if (p < attributes.length - 1) {
                    nnj *= this.m_trainInstances.attribute(classAttributes[p]).numValues();
                    continue;
                }
                nnj = this.m_trainInstances.attribute(classAttributes[p]).numValues();
            }
            if (b_missing_classAtrribute) {
                jj = nj - 1;
            }
            double[] dArray = counts[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
        }
        for (i = 0; i < ni; ++i) {
            sumi[i] = 0.0;
            for (j = 0; j < nj; ++j) {
                int n = i;
                sumi[n] = sumi[n] + counts[i][j];
                sum += counts[i][j];
            }
        }
        for (j = 0; j < nj; ++j) {
            sumj[j] = 0.0;
            for (i = 0; i < ni; ++i) {
                int n = j;
                sumj[n] = sumj[n] + counts[i][j];
            }
        }
        if (this.m_missing_merge && sumi[ni - 1] < (double)this.m_numInstances && sumj[nj - 1] < (double)this.m_numInstances) {
            double[] i_copy = new double[sumi.length];
            double[] j_copy = new double[sumj.length];
            double[][] counts_copy = new double[sumi.length][sumj.length];
            for (i = 0; i < ni; ++i) {
                System.arraycopy(counts[i], 0, counts_copy[i], 0, sumj.length);
            }
            System.arraycopy(sumi, 0, i_copy, 0, sumi.length);
            System.arraycopy(sumj, 0, j_copy, 0, sumj.length);
            double total_missing = sumi[ni - 1] + sumj[nj - 1] - counts[ni - 1][nj - 1];
            if (sumi[ni - 1] > 0.0) {
                for (j = 0; j < nj - 1; ++j) {
                    if (!(counts[ni - 1][j] > 0.0)) continue;
                    i = 0;
                    while (i < ni - 1) {
                        temp = i_copy[i] / (sum - i_copy[ni - 1]) * counts[ni - 1][j];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n2 = i++;
                        sumi[n2] = sumi[n2] + temp;
                    }
                    counts[ni - 1][j] = 0.0;
                }
            }
            sumi[ni - 1] = 0.0;
            if (sumj[nj - 1] > 0.0) {
                for (i = 0; i < ni - 1; ++i) {
                    if (!(counts[i][nj - 1] > 0.0)) continue;
                    j = 0;
                    while (j < nj - 1) {
                        temp = j_copy[j] / (sum - j_copy[nj - 1]) * counts[i][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n3 = j++;
                        sumj[n3] = sumj[n3] + temp;
                    }
                    counts[i][nj - 1] = 0.0;
                }
            }
            sumj[nj - 1] = 0.0;
            if (counts[ni - 1][nj - 1] > 0.0 && total_missing != sum) {
                for (i = 0; i < ni - 1; ++i) {
                    j = 0;
                    while (j < nj - 1) {
                        temp = counts_copy[i][j] / (sum - total_missing) * counts_copy[ni - 1][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n4 = i;
                        sumi[n4] = sumi[n4] + temp;
                        int n5 = j++;
                        sumj[n5] = sumj[n5] + temp;
                    }
                }
                counts[ni - 1][nj - 1] = 0.0;
            }
        }
        return ContingencyTables.symmetricalUncertainty(counts);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("\tSymmetrical Uncertainty evaluator has not been built");
        } else {
            text.append("\tSymmetrical Uncertainty Ranking Filter");
            if (!this.m_missing_merge) {
                text.append("\n\tMissing values treated as seperate");
            }
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5447 $");
    }

    public static void main(String[] argv) {
        SymmetricalUncertAttributeSetEval.runEvaluator(new SymmetricalUncertAttributeSetEval(), argv);
    }
}

