/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.TreeSet;
import weka.associations.ItemSet;
import weka.associations.PriorEstimation;
import weka.associations.RuleItem;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;

public class RuleGeneration
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8927041669872491432L;
    protected int[] m_items;
    protected int m_counter;
    protected int m_totalTransactions;
    protected boolean m_change = false;
    protected double m_expectation;
    protected static final int MAX_N = 300;
    protected int m_minRuleCount;
    protected double[] m_midPoints;
    protected Hashtable m_priors;
    protected TreeSet m_best;
    protected int m_count;
    protected Instances m_instances;

    public RuleGeneration(ItemSet itemSet) {
        this.m_totalTransactions = itemSet.m_totalTransactions;
        this.m_counter = itemSet.m_counter;
        this.m_items = itemSet.m_items;
    }

    public static final double binomialDistribution(double accuracy, double ruleCount, double premiseCount) {
        if (premiseCount < 300.0) {
            return Math.pow(2.0, Utils.log2(Math.pow(accuracy, ruleCount)) + Utils.log2(Math.pow(1.0 - accuracy, premiseCount - ruleCount)) + PriorEstimation.logbinomialCoefficient((int)premiseCount, (int)ruleCount));
        }
        double mu = premiseCount * accuracy;
        double sigma = Math.sqrt(premiseCount * (1.0 - accuracy) * accuracy);
        return Statistics.normalProbability((ruleCount + 0.5 - mu) / (sigma * Math.sqrt(2.0)));
    }

    public static final double expectation(double ruleCount, int premiseCount, double[] midPoints, Hashtable priors) {
        double numerator = 0.0;
        double denominator = 0.0;
        for (int i = 0; i < midPoints.length; ++i) {
            Double actualPrior = (Double)priors.get(new Double(midPoints[i]));
            if (actualPrior == null || actualPrior == 0.0) continue;
            double addend = actualPrior * RuleGeneration.binomialDistribution(midPoints[i], ruleCount, premiseCount);
            denominator += addend;
            numerator += addend * midPoints[i];
        }
        if (denominator <= 0.0 || Double.isNaN(denominator)) {
            System.out.println("RuleItem denominator: " + denominator);
        }
        if (numerator <= 0.0 || Double.isNaN(numerator)) {
            System.out.println("RuleItem numerator: " + numerator);
        }
        return numerator / denominator;
    }

    public TreeSet generateRules(int numRules, double[] midPoints, Hashtable priors, double expectation, Instances instances, TreeSet best, int genTime) {
        boolean redundant = false;
        FastVector consequences = new FastVector();
        FastVector consequencesMinusOne = new FastVector();
        boolean s = false;
        RuleItem current = null;
        this.m_change = false;
        this.m_midPoints = midPoints;
        this.m_priors = priors;
        this.m_best = best;
        this.m_expectation = expectation;
        this.m_count = genTime;
        this.m_instances = instances;
        ItemSet premise = null;
        premise = new ItemSet(this.m_totalTransactions);
        premise.m_items = new int[this.m_items.length];
        System.arraycopy(this.m_items, 0, premise.m_items, 0, this.m_items.length);
        premise.m_counter = this.m_counter;
        do {
            this.m_minRuleCount = 1;
            while (RuleGeneration.expectation(this.m_minRuleCount, premise.m_counter, this.m_midPoints, this.m_priors) <= this.m_expectation) {
                ++this.m_minRuleCount;
                if (this.m_minRuleCount <= premise.m_counter) continue;
                return this.m_best;
            }
            redundant = false;
            for (int i = 0; i < instances.numAttributes(); ++i) {
                int h;
                if (i == 0) {
                    for (int j = 0; j < this.m_items.length; ++j) {
                        if (this.m_items[j] != -1) continue;
                        consequences = RuleGeneration.singleConsequence(instances, j, consequences);
                    }
                    if (premise == null || consequences.size() == 0) {
                        return this.m_best;
                    }
                }
                FastVector<RuleItem> allRuleItems = new FastVector<RuleItem>();
                int index = 0;
                do {
                    h = 0;
                    while (h < consequences.size()) {
                        RuleItem dummie = new RuleItem();
                        current = dummie.generateRuleItem(premise, (ItemSet)consequences.elementAt(h), instances, this.m_count, this.m_minRuleCount, this.m_midPoints, this.m_priors);
                        if (current != null) {
                            allRuleItems.addElement(current);
                            ++h;
                            continue;
                        }
                        consequences.removeElementAt(h);
                    }
                    if (index == i) break;
                    consequencesMinusOne = consequences;
                    consequences = ItemSet.mergeAllItemSets(consequencesMinusOne, index, instances.numInstances());
                    Hashtable hashtable = ItemSet.getHashtable(consequencesMinusOne, consequencesMinusOne.size());
                    consequences = ItemSet.pruneItemSets(consequences, hashtable);
                    ++index;
                } while (consequences.size() > 0);
                for (h = 0; h < allRuleItems.size(); ++h) {
                    current = (RuleItem)allRuleItems.elementAt(h);
                    ++this.m_count;
                    if (this.m_best.size() < numRules) {
                        this.m_change = true;
                        redundant = this.removeRedundant(current);
                        continue;
                    }
                    if (!(current.accuracy() > this.m_expectation)) continue;
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    boolean remove = this.m_best.remove(this.m_best.first());
                    this.m_change = true;
                    redundant = this.removeRedundant(current);
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    while (RuleGeneration.expectation(this.m_minRuleCount, current.premise().m_counter, this.m_midPoints, this.m_priors) < this.m_expectation) {
                        ++this.m_minRuleCount;
                        if (this.m_minRuleCount <= current.premise().m_counter) continue;
                    }
                }
            }
        } while (redundant);
        return this.m_best;
    }

    public static boolean aSubsumesB(RuleItem a, RuleItem b) {
        if (a.m_accuracy < b.m_accuracy) {
            return false;
        }
        for (int k = 0; k < a.premise().m_items.length; ++k) {
            if (a.premise().m_items[k] != b.premise().m_items[k] && (a.premise().m_items[k] != -1 && b.premise().m_items[k] != -1 || b.premise().m_items[k] == -1)) {
                return false;
            }
            if (a.consequence().m_items[k] == b.consequence().m_items[k] || (a.consequence().m_items[k] == -1 || b.consequence().m_items[k] == -1) && a.consequence().m_items[k] != -1) continue;
            return false;
        }
        return true;
    }

    public static FastVector singleConsequence(Instances instances, int attNum, FastVector consequences) {
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i != attNum) continue;
            int j = 0;
            while (j < instances.attribute(i).numValues()) {
                ItemSet consequence = new ItemSet(instances.numInstances());
                consequence.m_items = new int[instances.numAttributes()];
                for (int k = 0; k < instances.numAttributes(); ++k) {
                    consequence.m_items[k] = -1;
                }
                consequence.m_items[i] = j++;
                consequences.addElement(consequence);
            }
        }
        return consequences;
    }

    public boolean removeRedundant(RuleItem toInsert) {
        boolean redundant = false;
        boolean fSubsumesT = false;
        boolean tSubsumesF = false;
        int subsumes = 0;
        Object[] best = this.m_best.toArray();
        for (int i = 0; i < best.length; ++i) {
            RuleItem first = (RuleItem)best[i];
            fSubsumesT = RuleGeneration.aSubsumesB(first, toInsert);
            tSubsumesF = RuleGeneration.aSubsumesB(toInsert, first);
            if (fSubsumesT) {
                subsumes = 1;
                break;
            }
            if (!tSubsumesF) continue;
            boolean remove = this.m_best.remove(first);
            subsumes = 2;
            redundant = true;
        }
        if (subsumes == 0 || subsumes == 2) {
            this.m_best.add(toInsert);
        }
        return redundant;
    }

    public int count() {
        return this.m_count;
    }

    public boolean change() {
        return this.m_change;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

