/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import weka.associations.AbstractAssociator;
import weka.associations.CARuleMiner;
import weka.associations.CaRuleGeneration;
import weka.associations.ItemSet;
import weka.associations.LabeledItemSet;
import weka.associations.PriorEstimation;
import weka.associations.RuleGeneration;
import weka.associations.RuleItem;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class PredictiveApriori
extends AbstractAssociator
implements OptionHandler,
CARuleMiner,
TechnicalInformationHandler {
    static final long serialVersionUID = 8109088846865075341L;
    protected int m_premiseCount;
    protected int m_numRules;
    protected static final int m_numRandRules = 1000;
    protected static final int m_numIntervals = 100;
    protected FastVector m_Ls;
    protected FastVector m_hashtables;
    protected FastVector[] m_allTheRules;
    protected Instances m_instances;
    protected Hashtable m_priors;
    protected double[] m_midPoints;
    protected double m_expectation;
    protected TreeSet m_best;
    protected boolean m_bestChanged;
    protected int m_count;
    protected PriorEstimation m_priorEstimator;
    protected int m_classIndex;
    protected boolean m_car;

    public String globalInfo() {
        return "Class implementing the predictive apriori algorithm to mine association rules.\nIt searches with an increasing support threshold for the best 'n' rules concerning a support-based corrected confidence value.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "The implementation follows the paper expect for adding a rule to the " + "output of the 'n' best rules. A rule is added if:\n" + "the expected predictive accuracy of this rule is among the 'n' best " + "and it is not subsumed by a rule with at least the same expected " + "predictive accuracy (out of an unpublished manuscript from T. " + "Scheffer).";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tobias Scheffer");
        result.setValue(TechnicalInformation.Field.TITLE, "Finding Association Rules That Trade Support Optimally against Confidence");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "5th European Conference on Principles of Data Mining and Knowledge Discovery");
        result.setValue(TechnicalInformation.Field.YEAR, "2001");
        result.setValue(TechnicalInformation.Field.PAGES, "424-435");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    public PredictiveApriori() {
        this.resetOptions();
    }

    public void resetOptions() {
        this.m_numRules = 105;
        this.m_premiseCount = 1;
        this.m_best = new TreeSet();
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.m_car = false;
        this.m_classIndex = -1;
        this.m_priors = new Hashtable();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildAssociations(Instances instances) throws Exception {
        int temp = this.m_premiseCount;
        int exactNumber = this.m_numRules - 5;
        this.m_premiseCount = 1;
        this.m_best = new TreeSet();
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.m_instances = new Instances(instances);
        if (this.m_classIndex == -1) {
            this.m_instances.setClassIndex(this.m_instances.numAttributes() - 1);
        } else if (this.m_classIndex < this.m_instances.numAttributes() && this.m_classIndex >= 0) {
            this.m_instances.setClassIndex(this.m_classIndex);
        } else {
            throw new Exception("Invalid class index.");
        }
        this.getCapabilities().testWithFail(this.m_instances);
        this.m_priorEstimator = new PriorEstimation(this.m_instances, 1000, 100, this.m_car);
        this.m_priors = this.m_priorEstimator.estimatePrior();
        this.m_midPoints = this.m_priorEstimator.getMidPoints();
        this.m_Ls = new FastVector();
        this.m_hashtables = new FastVector();
        for (int i = 1; i < this.m_instances.numAttributes(); ++i) {
            this.m_bestChanged = false;
            if (!this.m_car) {
                this.findLargeItemSets(i);
                this.findRulesQuickly();
            } else {
                this.findLargeCarItemSets(i);
                this.findCaRulesQuickly();
            }
            if (this.m_bestChanged) {
                temp = this.m_premiseCount;
                while (RuleGeneration.expectation(this.m_premiseCount, this.m_premiseCount, this.m_midPoints, this.m_priors) <= this.m_expectation) {
                    ++this.m_premiseCount;
                    if (this.m_premiseCount <= this.m_instances.numInstances()) continue;
                }
            }
            if (this.m_premiseCount > this.m_instances.numInstances()) {
                this.m_allTheRules = new FastVector[3];
                this.m_allTheRules[0] = new FastVector();
                this.m_allTheRules[1] = new FastVector();
                this.m_allTheRules[2] = new FastVector();
                int k = 0;
                while (this.m_best.size() > 0 && exactNumber > 0) {
                    this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), k);
                    this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), k);
                    this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), k);
                    this.m_best.remove(this.m_best.last());
                    ++k;
                    --exactNumber;
                }
                return;
            }
            if (temp == this.m_premiseCount || this.m_Ls.size() <= 0) continue;
            FastVector kSets = (FastVector)this.m_Ls.lastElement();
            this.m_Ls.removeElementAt(this.m_Ls.size() - 1);
            kSets = ItemSet.deleteItemSets(kSets, this.m_premiseCount, Integer.MAX_VALUE);
            this.m_Ls.addElement(kSets);
        }
        this.m_allTheRules = new FastVector[3];
        this.m_allTheRules[0] = new FastVector();
        this.m_allTheRules[1] = new FastVector();
        this.m_allTheRules[2] = new FastVector();
        int k = 0;
        while (this.m_best.size() > 0 && exactNumber > 0) {
            this.m_allTheRules[0].insertElementAt(((RuleItem)this.m_best.last()).premise(), k);
            this.m_allTheRules[1].insertElementAt(((RuleItem)this.m_best.last()).consequence(), k);
            this.m_allTheRules[2].insertElementAt(new Double(((RuleItem)this.m_best.last()).accuracy()), k);
            this.m_best.remove(this.m_best.last());
            ++k;
            --exactNumber;
        }
    }

    @Override
    public FastVector[] mineCARs(Instances data) throws Exception {
        this.m_car = true;
        this.m_best = new TreeSet();
        this.m_premiseCount = 1;
        this.m_bestChanged = false;
        this.m_expectation = 0.0;
        this.m_count = 1;
        this.buildAssociations(data);
        FastVector[] allCARRules = new FastVector[]{new FastVector(), new FastVector(), new FastVector()};
        for (int k = 0; k < this.m_allTheRules[0].size(); ++k) {
            int[] newPremiseArray = new int[this.m_instances.numAttributes() - 1];
            int help = 0;
            for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                if (j == this.m_instances.classIndex()) continue;
                newPremiseArray[help] = ((ItemSet)this.m_allTheRules[0].elementAt(k)).itemAt(j);
                ++help;
            }
            ItemSet newPremise = new ItemSet(this.m_instances.numInstances(), newPremiseArray);
            newPremise.setCounter(((ItemSet)this.m_allTheRules[0].elementAt(k)).counter());
            allCARRules[0].addElement(newPremise);
            int[] newConsArray = new int[]{((ItemSet)this.m_allTheRules[1].elementAt(k)).itemAt(this.m_instances.classIndex())};
            ItemSet newCons = new ItemSet(this.m_instances.numInstances(), newConsArray);
            newCons.setCounter(((ItemSet)this.m_allTheRules[1].elementAt(k)).counter());
            allCARRules[1].addElement(newCons);
            allCARRules[2].addElement(this.m_allTheRules[2].elementAt(k));
        }
        return allCARRules;
    }

    @Override
    public Instances getInstancesNoClass() {
        Instances noClass = null;
        try {
            noClass = LabeledItemSet.divide(this.m_instances, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n" + e.getMessage());
        }
        return noClass;
    }

    @Override
    public Instances getInstancesOnlyClass() {
        Instances onlyClass = null;
        try {
            onlyClass = LabeledItemSet.divide(this.m_instances, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n" + e.getMessage());
        }
        return onlyClass;
    }

    @Override
    public Enumeration listOptions() {
        String string1 = "\tThe required number of rules. (default = " + (this.m_numRules - 5) + ")";
        String string2 = "\tIf set class association rules are mined. (default = no)";
        String string3 = "\tThe class index. (default = last)";
        FastVector<Option> newVector = new FastVector<Option>(3);
        newVector.addElement(new Option(string1, "N", 1, "-N <required number of rules output>"));
        newVector.addElement(new Option(string2, "A", 0, "-A"));
        newVector.addElement(new Option(string3, "c", 1, "-c <the class index>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String numRulesString = Utils.getOption('N', options);
        this.m_numRules = numRulesString.length() != 0 ? Integer.parseInt(numRulesString) + 5 : Integer.MAX_VALUE;
        String classIndexString = Utils.getOption('c', options);
        if (classIndexString.length() != 0) {
            this.m_classIndex = Integer.parseInt(classIndexString);
        }
        this.m_car = Utils.getFlag('A', options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + (this.m_numRules - 5));
        if (this.m_car) {
            result.add("-A");
        }
        result.add("-c");
        result.add("" + this.m_classIndex);
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_allTheRules[0].size() == 0) {
            return "\nNo large itemsets and rules found!\n";
        }
        text.append("\nPredictiveApriori\n===================\n\n");
        text.append("\nBest rules found:\n\n");
        for (int i = 0; i < this.m_allTheRules[0].size(); ++i) {
            text.append(Utils.doubleToString((double)i + 1.0, (int)(Math.log(this.m_numRules) / Math.log(10.0) + 1.0), 0) + ". " + ((ItemSet)this.m_allTheRules[0].elementAt(i)).toString(this.m_instances) + " ==> " + ((ItemSet)this.m_allTheRules[1].elementAt(i)).toString(this.m_instances) + "    acc:(" + Utils.doubleToString((Double)this.m_allTheRules[2].elementAt(i), 5) + ")");
            text.append('\n');
        }
        return text.toString();
    }

    public String numRulesTipText() {
        return "Number of rules to find.";
    }

    public int getNumRules() {
        return this.m_numRules - 5;
    }

    public void setNumRules(int v) {
        this.m_numRules = v + 5;
    }

    @Override
    public void setClassIndex(int index) {
        this.m_classIndex = index;
    }

    public int getClassIndex() {
        return this.m_classIndex;
    }

    public String classIndexTipText() {
        return "Index of the class attribute.\n If set to -1, the last attribute will be taken as the class attribute.";
    }

    public void setCar(boolean flag) {
        this.m_car = flag;
    }

    public boolean getCar() {
        return this.m_car;
    }

    public String carTipText() {
        return "If enabled class association rules are mined instead of (general) association rules.";
    }

    @Override
    public String metricString() {
        return "acc";
    }

    private void findLargeItemSets(int index) throws Exception {
        FastVector kSets = new FastVector();
        int i = 0;
        if (index == 1) {
            kSets = ItemSet.singletons(this.m_instances);
            ItemSet.upDateCounters(kSets, this.m_instances);
            kSets = ItemSet.deleteItemSets(kSets, this.m_premiseCount, Integer.MAX_VALUE);
            if (kSets.size() == 0) {
                return;
            }
            this.m_Ls.addElement(kSets);
        }
        if (index > 1) {
            if (this.m_Ls.size() > 0) {
                kSets = (FastVector)this.m_Ls.lastElement();
            }
            this.m_Ls.removeAllElements();
            i = index - 2;
            FastVector kMinusOneSets = kSets;
            kSets = ItemSet.mergeAllItemSets(kMinusOneSets, i, this.m_instances.numInstances());
            Hashtable hashtable = ItemSet.getHashtable(kMinusOneSets, kMinusOneSets.size());
            this.m_hashtables.addElement(hashtable);
            kSets = ItemSet.pruneItemSets(kSets, hashtable);
            ItemSet.upDateCounters(kSets, this.m_instances);
            kSets = ItemSet.deleteItemSets(kSets, this.m_premiseCount, Integer.MAX_VALUE);
            if (kSets.size() == 0) {
                return;
            }
            this.m_Ls.addElement(kSets);
        }
    }

    private void findRulesQuickly() throws Exception {
        for (int j = 0; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                RuleGeneration currentItemSet = new RuleGeneration((ItemSet)enumItemSets.nextElement());
                this.m_best = currentItemSet.generateRules(this.m_numRules - 5, this.m_midPoints, this.m_priors, this.m_expectation, this.m_instances, this.m_best, this.m_count);
                this.m_count = currentItemSet.m_count;
                if (!this.m_bestChanged && currentItemSet.m_change) {
                    this.m_bestChanged = true;
                }
                if (this.m_best.size() >= this.m_numRules - 5) {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    continue;
                }
                this.m_expectation = 0.0;
            }
        }
    }

    private void findLargeCarItemSets(int index) throws Exception {
        FastVector kSets = new FastVector();
        int i = 0;
        if (index == 1) {
            kSets = CaRuleGeneration.singletons(this.m_instances);
            ItemSet.upDateCounters(kSets, this.m_instances);
            kSets = ItemSet.deleteItemSets(kSets, this.m_premiseCount, Integer.MAX_VALUE);
            if (kSets.size() == 0) {
                return;
            }
            this.m_Ls.addElement(kSets);
        }
        if (index > 1) {
            if (this.m_Ls.size() > 0) {
                kSets = (FastVector)this.m_Ls.lastElement();
            }
            this.m_Ls.removeAllElements();
            i = index - 2;
            FastVector kMinusOneSets = kSets;
            kSets = ItemSet.mergeAllItemSets(kMinusOneSets, i, this.m_instances.numInstances());
            Hashtable hashtable = ItemSet.getHashtable(kMinusOneSets, kMinusOneSets.size());
            this.m_hashtables.addElement(hashtable);
            kSets = ItemSet.pruneItemSets(kSets, hashtable);
            ItemSet.upDateCounters(kSets, this.m_instances);
            kSets = ItemSet.deleteItemSets(kSets, this.m_premiseCount, Integer.MAX_VALUE);
            if (kSets.size() == 0) {
                return;
            }
            this.m_Ls.addElement(kSets);
        }
    }

    private void findCaRulesQuickly() throws Exception {
        for (int j = 0; j < this.m_Ls.size(); ++j) {
            FastVector currentItemSets = (FastVector)this.m_Ls.elementAt(j);
            Enumeration enumItemSets = currentItemSets.elements();
            while (enumItemSets.hasMoreElements()) {
                CaRuleGeneration currentLItemSet = new CaRuleGeneration((ItemSet)enumItemSets.nextElement());
                this.m_best = currentLItemSet.generateRules(this.m_numRules - 5, this.m_midPoints, this.m_priors, this.m_expectation, this.m_instances, this.m_best, this.m_count);
                this.m_count = currentLItemSet.count();
                if (!this.m_bestChanged && currentLItemSet.change()) {
                    this.m_bestChanged = true;
                }
                if (this.m_best.size() == this.m_numRules - 5) {
                    this.m_expectation = ((RuleItem)this.m_best.first()).accuracy();
                    continue;
                }
                this.m_expectation = 0.0;
            }
        }
    }

    public FastVector[] getAllTheRules() {
        return this.m_allTheRules;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5444 $");
    }

    public static void main(String[] args) {
        PredictiveApriori.runAssociator(new PredictiveApriori(), args);
    }
}

