/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleSelectionLibrary;
import weka.core.Utils;
import weka.gui.ensembleLibraryEditor.LibrarySerialization;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class DefaultModelsPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = -6123488873592563339L;
    public static final String PROPERTY_FILE = "DefaultModels.props";
    protected static Properties DEFAULT_PROPERTIES;
    public String[] EXCLUDE_OPTIONS = new String[]{"Train Time", "Test Time", "File Size"};
    private String[] m_DefaultFileNames;
    private String[] m_LargeFileSizeModels;
    private String[] m_LargeTrainTimeModels;
    private String[] m_LargeTestTimeModels;
    private JComboBox m_ExcludeModelsComboBox;
    private JButton m_ExcludeModelsButton;
    private JComboBox m_DefaultFilesComboBox;
    private JButton m_RefreshButton;
    private ModelList m_ModelList;
    private JButton m_RemoveSelectedButton;
    private JButton m_AddAllButton;
    private JButton m_AddSelectedButton;
    private ListModelsPanel m_ListModelsPanel;
    private boolean m_ListUpdatePending = false;

    public DefaultModelsPanel(ListModelsPanel listModelsPanel) {
        this.m_ListModelsPanel = listModelsPanel;
        this.readProperties();
        this.createDefaultModelsPanel();
    }

    private void readProperties() {
        this.m_DefaultFileNames = DEFAULT_PROPERTIES.getProperty("files").split(", ");
        this.m_LargeTrainTimeModels = DEFAULT_PROPERTIES.getProperty("train_time").split(", ");
        this.m_LargeTestTimeModels = DEFAULT_PROPERTIES.getProperty("test_time").split(", ");
        this.m_LargeFileSizeModels = DEFAULT_PROPERTIES.getProperty("file_size").split(", ");
    }

    private void createDefaultModelsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel defaultFileLabel = new JLabel("Select default set: ");
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)defaultFileLabel, gbc);
        this.m_DefaultFilesComboBox = new JComboBox<String>(this.m_DefaultFileNames);
        this.m_DefaultFilesComboBox.setSelectedItem(this.m_DefaultFileNames[0]);
        this.m_DefaultFilesComboBox.addActionListener(this);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.m_DefaultFilesComboBox, gbc);
        this.m_RefreshButton = new JButton("Reload set");
        this.m_RefreshButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.m_RefreshButton, gbc);
        JLabel excludeModelsLabel = new JLabel("Exclude models w/ large");
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)excludeModelsLabel, gbc);
        this.m_ExcludeModelsComboBox = new JComboBox<String>(this.EXCLUDE_OPTIONS);
        this.m_ExcludeModelsComboBox.setSelectedItem(this.EXCLUDE_OPTIONS[0]);
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.m_ExcludeModelsComboBox, gbc);
        this.m_ExcludeModelsButton = new JButton("Exclude");
        this.m_ExcludeModelsButton.setToolTipText("Exclude this type of models from the current working list");
        this.m_ExcludeModelsButton.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.m_ExcludeModelsButton, gbc);
        JPanel modelListPanel = new JPanel();
        modelListPanel.setBorder(BorderFactory.createTitledBorder("Working set of Default Library Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 4601977182190493654L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] currentModels = DefaultModelsPanel.this.m_ModelList.getSelectedValues();
                ModelList.SortedListModel dataModel = (ModelList.SortedListModel)DefaultModelsPanel.this.m_ModelList.getModel();
                for (int i = 0; i < currentModels.length; ++i) {
                    dataModel.removeElement((EnsembleLibraryModel)currentModels[i]);
                }
                int[] selected = new int[]{DefaultModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                DefaultModelsPanel.this.m_ModelList.setSelectedIndices(selected);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setLayoutOrientation(0);
        ToolTipManager.sharedInstance().registerComponent(this.m_ModelList);
        JScrollPane listView = new JScrollPane(this.m_ModelList);
        listView.setHorizontalScrollBarPolicy(30);
        listView.setPreferredSize(new Dimension(150, 50));
        modelListPanel.setLayout(new BorderLayout());
        modelListPanel.add((Component)listView, "Center");
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        this.add((Component)modelListPanel, gbc);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.addActionListener(this);
        this.m_RemoveSelectedButton.setToolTipText("Remove the selected models from the current default set");
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gbc);
        this.m_AddSelectedButton = new JButton("Add Selected");
        this.m_AddSelectedButton.addActionListener(this);
        this.m_AddSelectedButton.setToolTipText("Add selected models in above list to the library");
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.m_AddSelectedButton, gbc);
        this.m_AddAllButton = new JButton("Add All");
        this.m_AddAllButton.addActionListener(this);
        this.m_AddAllButton.setToolTipText("Add all models in the abovelist to the Libray");
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.m_AddAllButton, gbc);
        this.m_ListUpdatePending = true;
    }

    public void updateDefaultList() {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).clear();
        String ensemblePackageString = DefaultModelsPanel.getPackageName();
        int index = this.m_DefaultFilesComboBox.getSelectedIndex();
        Vector classifiers = null;
        try {
            LibrarySerialization serialization = new LibrarySerialization();
            String defaultFileString = ensemblePackageString + this.m_DefaultFileNames[index].trim() + ".model.xml";
            InputStream is = ClassLoader.getSystemResourceAsStream(defaultFileString);
            if (is == null) {
                File f = new File(defaultFileString);
                if (f.exists()) {
                    System.out.println("file existed: " + f.getPath());
                } else {
                    System.out.println("file didn't exist: " + f.getPath());
                }
            }
            classifiers = (Vector)serialization.read(ClassLoader.getSystemResourceAsStream(defaultFileString));
            Iterator it = classifiers.iterator();
            while (it.hasNext()) {
                EnsembleLibraryModel model = this.m_ListModelsPanel.getLibrary().createModel((Classifier)it.next());
                model.testOptions();
                ((ModelList.SortedListModel)this.m_ModelList.getModel()).add(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModelList.SortedListModel dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        if (e.getSource() == this.m_RefreshButton) {
            this.updateDefaultList();
        } else if (e.getSource() == this.m_DefaultFilesComboBox) {
            this.updateDefaultList();
        } else if (e.getSource() == this.m_RemoveSelectedButton) {
            Object[] currentModels = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < currentModels.length; ++i) {
                dataModel.removeElement(currentModels[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] selected = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(selected);
            }
        } else if (e.getSource() == this.m_AddAllButton) {
            Iterator it = dataModel.iterator();
            while (it.hasNext()) {
                EnsembleLibraryModel currentModel = (EnsembleLibraryModel)it.next();
                this.m_ListModelsPanel.addModel(currentModel);
            }
            dataModel.clear();
        } else if (e.getSource() == this.m_AddSelectedButton) {
            Object[] currentModels = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < currentModels.length; ++i) {
                this.m_ListModelsPanel.addModel((EnsembleLibraryModel)currentModels[i]);
                dataModel.removeElement(currentModels[i]);
            }
        } else if (e.getSource() == this.m_ExcludeModelsButton) {
            if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 0) {
                this.applyTrainTimeFilters();
            } else if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 1) {
                this.applyTestTimeFilters();
            } else if (this.m_ExcludeModelsComboBox.getSelectedIndex() == 2) {
                this.applyFileSizeFilters();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        if (pane.getSelectedComponent().equals(this) && this.m_ListUpdatePending) {
            this.updateDefaultList();
            this.m_ListUpdatePending = false;
        }
    }

    public void applyTrainTimeFilters() {
        Pattern[] patterns = new Pattern[this.m_LargeTrainTimeModels.length];
        for (int i = 0; i < this.m_LargeTrainTimeModels.length; ++i) {
            patterns[i] = Pattern.compile(this.m_LargeTrainTimeModels[i]);
        }
        this.applyFilters(patterns);
    }

    public void applyTestTimeFilters() {
        Pattern[] patterns = new Pattern[this.m_LargeTestTimeModels.length];
        for (int i = 0; i < this.m_LargeTestTimeModels.length; ++i) {
            patterns[i] = Pattern.compile(this.m_LargeTestTimeModels[i]);
        }
        this.applyFilters(patterns);
    }

    public void applyFileSizeFilters() {
        Pattern[] patterns = new Pattern[this.m_LargeFileSizeModels.length];
        for (int i = 0; i < this.m_LargeFileSizeModels.length; ++i) {
            patterns[i] = Pattern.compile(this.m_LargeFileSizeModels[i]);
        }
        this.applyFilters(patterns);
    }

    public void applyFilters(Pattern[] patterns) {
        ModelList.SortedListModel dataModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
        Vector<EnsembleLibraryModel> toRemove = new Vector<EnsembleLibraryModel>();
        Iterator it = dataModel.iterator();
        block0: while (it.hasNext()) {
            EnsembleLibraryModel currentModel = (EnsembleLibraryModel)it.next();
            for (int i = 0; i < patterns.length; ++i) {
                if (!patterns[i].matcher(currentModel.getStringRepresentation()).matches()) continue;
                toRemove.add(currentModel);
                continue block0;
            }
        }
        it = toRemove.iterator();
        while (it.hasNext()) {
            dataModel.removeElement(it.next());
        }
    }

    public static String getPackageName() {
        return EnsembleSelectionLibrary.class.toString().replaceAll("class ", "").replaceAll("EnsembleSelectionLibrary", "").replaceAll("\\.", "/");
    }

    static {
        try {
            System.out.println("package name: " + DefaultModelsPanel.getPackageName());
            DEFAULT_PROPERTIES = Utils.readProperties(DefaultModelsPanel.getPackageName() + PROPERTY_FILE);
            Enumeration<?> keys = DEFAULT_PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                throw new Exception("Failed to read a property file for the generic object editor");
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Could not read a configuration file for the default models\npanel.\n", "DefaultProperties", 0);
        }
    }
}

