/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Normalize
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -7947971807522917395L;
    protected double m_Norm = 1.0;
    protected double m_LNorm = 2.0;

    public String globalInfo() {
        return "An instance filter that normalize instances considering only numeric attributes and ignoring class index.";
    }

    public String LNormTipText() {
        return "The LNorm to use.";
    }

    public String normTipText() {
        return "The norm of the instances after normalization.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tSpecify the norm that each instance must have (default 1.0)", "N", 1, "-N <num>"));
        newVector.addElement(new Option("\tSpecify L-norm to use (default 2.0)", "L", 1, "-L <num>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String normString = Utils.getOption('N', options);
        if (normString.length() != 0) {
            this.setNorm(Double.parseDouble(normString));
        } else {
            this.setNorm(1.0);
        }
        String lNormString = Utils.getOption('L', options);
        if (lNormString.length() != 0) {
            this.setLNorm(Double.parseDouble(lNormString));
        } else {
            this.setLNorm(2.0);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[4];
        int current = 0;
        options[current++] = "-N";
        options[current++] = "" + this.getNorm();
        options[current++] = "-L";
        options[current++] = "" + this.getLNorm();
        return options;
    }

    public double getNorm() {
        return this.m_Norm;
    }

    public void setNorm(double newNorm) {
        this.m_Norm = newNorm;
    }

    public double getLNorm() {
        return this.m_LNorm;
    }

    public void setLNorm(double newLNorm) {
        this.m_LNorm = newLNorm;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) throws Exception {
        int i;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        Instance inst = (Instance)instance.copy();
        double iNorm = 0.0;
        for (i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.getInputFormat().classIndex() == i || !this.getInputFormat().attribute(i).isNumeric()) continue;
            iNorm += Math.pow(Math.abs(inst.value(i)), this.getLNorm());
        }
        iNorm = Math.pow(iNorm, 1.0 / this.getLNorm());
        for (i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            if (this.getInputFormat().classIndex() == i || !this.getInputFormat().attribute(i).isNumeric()) continue;
            inst.setValue(i, inst.value(i) / iNorm * this.getNorm());
        }
        this.push(inst);
        return true;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5499 $");
    }

    public static void main(String[] argv) {
        Normalize.runFilter(new Normalize(), argv);
    }
}

