/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.experiment.Stats;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class EMImputation
extends SimpleBatchFilter
implements UnsupervisedFilter {
    static final long serialVersionUID = -2519262133734188184L;
    private int m_numIterations = -1;
    private double m_LogLikelihoodThreshold = 1.0E-4;
    private boolean m_ridgePrior = false;
    private double m_ridge = 1.0E-8;
    private int m_numAttributes;
    private double[] m_means = null;
    private double[] m_stdDevs = null;
    private Remove m_unusedAttributeRemover = null;
    private boolean[] m_unusedAtts = null;
    private Matrix m_theta = null;

    @Override
    public String globalInfo() {
        return "Replaces missing numeric values using Expectation Maximization with a multivariate normal model. Described in \" Schafer, J.L. Analysis of Incomplete Multivariate Data, New York: Chapman and Hall, 1997.\"";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> options = new Vector<Option>(4);
        options.addElement(new Option("\tMaximum number of iterations for Expectation \n\tMaximization. (-1 = no maximum)", "N", 1, "-N"));
        options.addElement(new Option("\tThreshold for convergence in Expectation \n\tMaximization. If the change in the observed data \n\tlog-likelihood (posterior density if a ridge prior \n\t is being used) across iterations is no more than \n\tthis value, then convergence is considered to be \n\tachieved and the iterative process is ceased. \n\t(default = 0.0001)", "E", 1, "-E"));
        options.addElement(new Option("\tUse a ridge prior instead of the noninformative \n\tprior. This helps when the data has a singular \n\tcovariance matrix.", "P", 0, "-P"));
        options.addElement(new Option("\tThe ridge parameter for when a ridge prior is \n\tused.", "Q", 1, "-Q"));
        return options.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            this.setNumIterations(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('E', options)).length() != 0) {
            this.setLogLikelihoodThreshold(Double.valueOf(optionString));
        }
        this.setUseRidgePrior(Utils.getFlag('P', options));
        optionString = Utils.getOption('Q', options);
        if (optionString.length() != 0) {
            this.setRidge(Double.valueOf(optionString));
        }
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[7];
        int current = 0;
        options[current++] = "-N";
        options[current++] = "" + this.getNumIterations();
        options[current++] = "-E";
        options[current++] = "" + this.getLogLikelihoodThreshold();
        options[current++] = "-Q";
        options[current++] = "" + this.getRidge();
        if (this.getUseRidgePrior()) {
            options[current++] = "-P";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String numIterationsTipText() {
        return "Maximum number of iterations for Expectation Maximization. EM is used to initialize the parameters of the multivariate normal distribution. (-1 = no maximum)";
    }

    public void setNumIterations(int newIterations) {
        this.m_numIterations = newIterations;
    }

    public int getNumIterations() {
        return this.m_numIterations;
    }

    public String logLikelihoodThresholdTipText() {
        return "Log-likelihood threshold for convergence in Expectation Maximization. If the change in the observed data log-likelihood across iterations is no more than this value, then convergence is considered to be achieved and the iterative process is ceased. (default = 0.0001)";
    }

    public void setLogLikelihoodThreshold(double newThreshold) {
        this.m_LogLikelihoodThreshold = newThreshold;
    }

    public double getLogLikelihoodThreshold() {
        return this.m_LogLikelihoodThreshold;
    }

    public String useRidgePriorTipText() {
        return "Use a ridge prior instead of noninformative prior.";
    }

    public boolean getUseRidgePrior() {
        return this.m_ridgePrior;
    }

    public void setUseRidgePrior(boolean prior) {
        this.m_ridgePrior = prior;
    }

    public String ridgeTipText() {
        return "Ridge parameter for ridge prior.";
    }

    public double getRidge() {
        return this.m_ridge;
    }

    public void setRidge(double ridge) {
        this.m_ridge = ridge;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        return inputFormat;
    }

    @Override
    protected Instances process(Instances instances) throws Exception {
        int numInstances = instances.numInstances();
        int numAttributes = instances.numAttributes();
        int classIndex = instances.classIndex();
        if ((classIndex < 0 || instances.classAttribute().isNumeric()) && numAttributes < 2 || numAttributes < 3) {
            throw new Exception("Must have 2 or more numeric attributes for EM Imputation");
        }
        for (int i = 0; i < numAttributes; ++i) {
            if (instances.attribute(i).isNumeric() || instances.classIndex() == i) continue;
            throw new Exception("EM Imputation can only handle numeric attributes");
        }
        if (this.m_LogLikelihoodThreshold < 0.0) {
            throw new Exception("Log-likelihood threshold must be non-negative.");
        }
        if (this.m_ridgePrior && this.m_ridge <= 0.0) {
            throw new Exception("Ridge parameter should be positive.");
        }
        Instances[] datasets = null;
        if (!this.isFirstBatchDone()) {
            if (numInstances < numAttributes + 2) {
                throw new Exception("EMImputation: Number of instances must be >= number of attributes + 2");
            }
            datasets = this.prepareData(instances, true);
        } else {
            datasets = this.prepareData(instances, false);
        }
        Instances preprocessed = datasets[0];
        Instances dataWithClass = datasets[1];
        if (!this.isFirstBatchDone()) {
            Matrix t_obs = this.getTObs(preprocessed);
            this.m_theta = this.EM(preprocessed, t_obs);
        }
        this.impute(preprocessed, this.m_theta);
        dataWithClass = this.postProcessData(preprocessed, dataWithClass);
        if (dataWithClass.numInstances() != 0) {
            return dataWithClass;
        }
        return instances;
    }

    private void standardize(Instances data) {
        for (int i = 0; i < data.numInstances(); ++i) {
            for (int j = 1; j < this.m_numAttributes + 1; ++j) {
                if (data.instance(i).isMissing(j)) continue;
                double value = data.instance(i).value(j);
                data.instance(i).setValue(j, (value - this.m_means[j - 1]) / this.m_stdDevs[j - 1]);
            }
        }
    }

    private Instances prepareMissing(Instances data) throws Exception {
        int numInstances = data.numInstances();
        int numAttributes = data.numAttributes();
        Instances preprocessed = new Instances(data, data.numInstances());
        preprocessed.insertAttributeAt(new Attribute("NumInPattern"), 0);
        int currentPatternStart = 0;
        int numInCurrentPattern = 0;
        int totalAdded = 0;
        boolean[] addedAlready = new boolean[numInstances];
        boolean[] missing = new boolean[numAttributes];
        while (totalAdded < numInstances) {
            numInCurrentPattern = 0;
            int numMissing = 0;
            int newPatternIndex = -1;
            for (int i = 0; newPatternIndex == -1 && i < numInstances; ++i) {
                if (addedAlready[i]) continue;
                newPatternIndex = i;
                addedAlready[i] = true;
                ++numInCurrentPattern;
                ++totalAdded;
            }
            for (int j = 0; j < numAttributes; ++j) {
                if (this.m_unusedAtts[j]) {
                    ++numMissing;
                    continue;
                }
                if (data.instance(newPatternIndex).isMissing(j)) {
                    missing[j] = true;
                    ++numMissing;
                    continue;
                }
                missing[j] = false;
            }
            if (numMissing == numAttributes) continue;
            double[] attributes = new double[numAttributes + 1];
            for (int j = 0; j < numAttributes; ++j) {
                attributes[j + 1] = data.instance(newPatternIndex).value(j);
            }
            DenseInstance newInstance = new DenseInstance(data.instance(newPatternIndex).weight(), attributes);
            preprocessed.add(newInstance);
            for (int i = 0; i < numInstances; ++i) {
                if (addedAlready[i]) continue;
                boolean match = true;
                for (int j = 0; j < numAttributes && match; ++j) {
                    if (this.m_unusedAtts[j] || data.instance(i).isMissing(j) == missing[j]) continue;
                    match = false;
                }
                if (!match) continue;
                attributes = new double[numAttributes + 1];
                for (int l = 0; l < numAttributes; ++l) {
                    attributes[l + 1] = data.instance(i).value(l);
                }
                newInstance = new DenseInstance(data.instance(i).weight(), attributes);
                preprocessed.add(newInstance);
                addedAlready[i] = true;
                ++numInCurrentPattern;
                ++totalAdded;
            }
            preprocessed.instance(currentPatternStart).setValue(0, (double)numInCurrentPattern);
            currentPatternStart += numInCurrentPattern;
        }
        return preprocessed;
    }

    private Instances[] prepareData(Instances originalData, boolean firstTime) throws Exception {
        int numAttributes = originalData.numAttributes();
        int classIndex = originalData.classIndex();
        if (firstTime) {
            String unusedAttributeIndices = "";
            this.m_unusedAtts = new boolean[numAttributes];
            for (int j = 0; j < numAttributes; ++j) {
                AttributeStats currentStats = originalData.attributeStats(j);
                if (classIndex == j && !originalData.classAttribute().isNumeric() || currentStats.distinctCount < 2) {
                    this.m_unusedAtts[j] = true;
                    unusedAttributeIndices = unusedAttributeIndices + (j + 2) + ",";
                    continue;
                }
                this.m_unusedAtts[j] = false;
            }
            if (!unusedAttributeIndices.contentEquals("")) {
                this.m_unusedAttributeRemover = new Remove();
                this.m_unusedAttributeRemover.setInvertSelection(false);
                this.m_unusedAttributeRemover.setAttributeIndices(unusedAttributeIndices);
            }
        }
        Instances preprocessed = this.prepareMissing(originalData);
        Instances withClass = new Instances(preprocessed, 0, preprocessed.numInstances());
        if (this.m_unusedAttributeRemover != null) {
            this.m_unusedAttributeRemover.setInputFormat(preprocessed);
            preprocessed = Filter.useFilter(preprocessed, this.m_unusedAttributeRemover);
            preprocessed.setClassIndex(-1);
        }
        if (firstTime) {
            this.m_numAttributes = preprocessed.numAttributes() - 1;
            this.m_means = new double[this.m_numAttributes];
            this.m_stdDevs = new double[this.m_numAttributes];
            for (int i = 1; i < this.m_numAttributes + 1; ++i) {
                Stats columnStats = preprocessed.attributeStats((int)i).numericStats;
                columnStats.calculateDerived();
                this.m_means[i - 1] = columnStats.mean;
                this.m_stdDevs[i - 1] = columnStats.stdDev;
            }
        }
        this.standardize(preprocessed);
        Instances[] data = new Instances[]{preprocessed, withClass};
        return data;
    }

    private Instances postProcessData(Instances imputedData, Instances withClass) throws Exception {
        Remove patternRemover = new Remove();
        patternRemover.setInvertSelection(false);
        patternRemover.setAttributeIndices("1");
        patternRemover.setInputFormat(withClass);
        withClass = Filter.useFilter(withClass, patternRemover);
        for (int i = 0; i < withClass.numInstances(); ++i) {
            int usedAttributes = 0;
            for (int j = 0; j < withClass.numAttributes(); ++j) {
                if (this.m_unusedAtts[j]) continue;
                if (withClass.instance(i).isMissing(j)) {
                    withClass.instance(i).setValue(j, imputedData.instance(i).value(usedAttributes + 1) * this.m_stdDevs[usedAttributes] + this.m_means[usedAttributes]);
                }
                ++usedAttributes;
            }
        }
        return withClass;
    }

    private Matrix getTObs(Instances data) throws Exception {
        int numInCurrentPattern;
        int p = this.m_numAttributes;
        Matrix t = new Matrix(p + 1, p + 1);
        for (int currentPatternStart = 0; currentPatternStart < data.numInstances(); currentPatternStart += numInCurrentPattern) {
            numInCurrentPattern = (int)data.instance(currentPatternStart).value(0);
            t.set(0, 0, t.get(0, 0) + (double)numInCurrentPattern);
            for (int i = 1; i < p + 1; ++i) {
                if (data.instance(currentPatternStart).isMissing(i)) continue;
                for (int k = 0; k < numInCurrentPattern; ++k) {
                    t.set(0, i, t.get(0, i) + data.instance(currentPatternStart + k).value(i));
                }
                for (int j = i; j < p + 1; ++j) {
                    if (data.instance(currentPatternStart).isMissing(j)) continue;
                    for (int k = 0; k < numInCurrentPattern; ++k) {
                        t.set(i, j, t.get(i, j) + data.instance(currentPatternStart + k).value(i) * data.instance(currentPatternStart + k).value(j));
                    }
                }
            }
        }
        for (int i = 0; i < p + 1; ++i) {
            for (int j = 1; j < p + 1; ++j) {
                t.set(j, i, t.get(i, j));
            }
        }
        return t;
    }

    private Matrix EM(Instances data, Matrix t_obs) throws Exception {
        int p = this.m_numAttributes;
        Matrix theta = new Matrix(p + 1, p + 1);
        int numIterations = this.m_numIterations;
        if (numIterations < 0) {
            numIterations = Integer.MAX_VALUE;
        }
        theta.set(0, 0, -1.0);
        for (int i = 1; i < data.numAttributes(); ++i) {
            theta.set(0, i, 0.0);
            theta.set(i, 0, 0.0);
            theta.set(i, i, 1.0);
        }
        double likelihood = this.logLikelihood(data, theta);
        double deltaLikelihood = Double.MAX_VALUE;
        for (int i = 0; i < numIterations && deltaLikelihood > this.m_LogLikelihoodThreshold; ++i) {
            theta = this.doEMIteration(data, theta, t_obs);
            double newLikelihood = this.logLikelihood(data, theta);
            deltaLikelihood = newLikelihood - likelihood;
            likelihood = newLikelihood;
        }
        return theta;
    }

    private Matrix doEMIteration(Instances data, Matrix theta, Matrix t_obs) throws Exception {
        int numInCurrentPattern;
        int p = this.m_numAttributes;
        Matrix t = t_obs.copy();
        for (int currentPatternStart = 0; currentPatternStart < data.numInstances(); currentPatternStart += numInCurrentPattern) {
            numInCurrentPattern = (int)data.instance(currentPatternStart).value(0);
            boolean[] r = new boolean[p + 1];
            int[] observedColumns = new int[p + 1];
            int[] missingColumns = new int[p + 1];
            int numMissing = 0;
            int numObserved = 0;
            for (int l = 1; l < p + 1; ++l) {
                if (data.instance(currentPatternStart).isMissing(l)) {
                    missingColumns[numMissing++] = l;
                    continue;
                }
                observedColumns[numObserved++] = l;
                r[l] = true;
            }
            observedColumns[numObserved] = -1;
            missingColumns[numMissing] = -1;
            for (int j = 1; j < p + 1; ++j) {
                if (r[j] && theta.get(j, j) > 0.0) {
                    theta = EMImputation.swp(theta, j);
                    continue;
                }
                if (r[j] || !(theta.get(j, j) < 0.0)) continue;
                theta = EMImputation.rsw(theta, j);
            }
            double[] c = new double[p + 1];
            for (int i = 0; i < numInCurrentPattern; ++i) {
                int k;
                int kCounter;
                int jCounter = 0;
                int j = missingColumns[jCounter];
                while (j != -1) {
                    c[j] = theta.get(0, j);
                    kCounter = 0;
                    k = observedColumns[kCounter];
                    while (k != -1) {
                        int n = j;
                        c[n] = c[n] + theta.get(k, j) * data.instance(currentPatternStart + i).value(k);
                        k = observedColumns[++kCounter];
                    }
                    j = missingColumns[++jCounter];
                }
                jCounter = 0;
                j = missingColumns[jCounter];
                while (j != -1) {
                    t.set(0, j, t.get(0, j) + c[j]);
                    t.set(j, 0, t.get(0, j));
                    kCounter = 0;
                    k = observedColumns[kCounter];
                    while (k != -1) {
                        t.set(k, j, t.get(k, j) + c[j] * data.instance(currentPatternStart + i).value(k));
                        t.set(j, k, t.get(k, j));
                        k = observedColumns[++kCounter];
                    }
                    kCounter = 0;
                    k = missingColumns[kCounter];
                    while (k != -1) {
                        if (k >= j) {
                            t.set(k, j, t.get(k, j) + theta.get(k, j) + c[k] * c[j]);
                            t.set(j, k, t.get(k, j));
                        }
                        k = missingColumns[++kCounter];
                    }
                    j = missingColumns[++jCounter];
                }
            }
        }
        if (this.m_ridgePrior) {
            double n = data.numInstances();
            double m = this.m_ridge;
            Matrix deltaInv = Matrix.identity(this.m_numAttributes, this.m_numAttributes).times(this.m_ridge);
            Matrix t1 = t.getMatrix(1, p, 0, 0);
            Matrix t2 = t.getMatrix(1, p, 1, p);
            Matrix t1Tilde = t1;
            Matrix t2Tilde = t2.minus(t1.times(t1.transpose()).times(1.0 / n));
            t2Tilde = t2Tilde.plus(deltaInv).times(n / (n + m + (double)p + 2.0));
            t2Tilde.plusEquals(t1Tilde.times(t1Tilde.transpose()).times(1.0 / n));
            t.setMatrix(1, p, 0, 0, t1Tilde);
            t.setMatrix(0, 0, 1, p, t1Tilde.transpose());
            t.setMatrix(1, p, 1, p, t2Tilde);
        }
        return EMImputation.swp(t.times(1.0 / (double)data.numInstances()), 0);
    }

    private double logLikelihood(Instances data, Matrix theta) throws Exception {
        int numInCurrentPattern;
        int p = this.m_numAttributes;
        double likelihood = 0.0;
        double d = 0.0;
        double[] c = new double[p + 1];
        for (int j = 1; j < p + 1; ++j) {
            c[j] = theta.get(0, j);
        }
        Matrix sigma = theta.getMatrix(1, p, 1, p);
        for (int currentPatternStart = 0; currentPatternStart < data.numInstances(); currentPatternStart += numInCurrentPattern) {
            numInCurrentPattern = (int)data.instance(currentPatternStart).value(0);
            boolean[] r = new boolean[p + 1];
            int[] observedColumns = new int[p + 1];
            int[] missingColumns = new int[p + 1];
            int numMissing = 0;
            int numObserved = 0;
            for (int l = 1; l < p + 1; ++l) {
                if (data.instance(currentPatternStart).isMissing(l)) {
                    missingColumns[numMissing++] = l;
                    continue;
                }
                observedColumns[numObserved++] = l;
                r[l] = true;
            }
            observedColumns[numObserved] = -1;
            missingColumns[numMissing] = -1;
            for (int j = 1; j < p + 1; ++j) {
                if (r[j] && theta.get(j, j) > 0.0) {
                    d += Math.log(theta.get(j, j));
                    theta = EMImputation.swp(theta, j);
                    continue;
                }
                if (r[j] || !(theta.get(j, j) < 0.0)) continue;
                theta = EMImputation.rsw(theta, j);
                d -= Math.log(theta.get(j, j));
            }
            Matrix m = new Matrix(p + 1, p + 1);
            for (int i = 0; i < numInCurrentPattern; ++i) {
                int jCounter = 0;
                int j = observedColumns[jCounter];
                while (j != -1) {
                    int kCounter = jCounter;
                    int k = observedColumns[kCounter];
                    while (k != -1) {
                        m.set(j, k, m.get(j, k) + (data.instance(currentPatternStart + i).value(j) - c[j]) * (data.instance(currentPatternStart + i).value(k) - c[k]));
                        m.set(k, j, m.get(j, k));
                        k = observedColumns[++kCounter];
                    }
                    j = observedColumns[++jCounter];
                }
            }
            double t = 0.0;
            int jCounter = 0;
            int j = observedColumns[jCounter];
            while (j != -1) {
                int kCounter = 0;
                int k = observedColumns[kCounter];
                while (k != -1) {
                    t -= theta.get(j, k) * m.get(j, k);
                    k = observedColumns[++kCounter];
                }
                j = observedColumns[++jCounter];
            }
            likelihood -= ((double)numInCurrentPattern * d + t) / 2.0;
        }
        if (this.m_ridgePrior) {
            Matrix deltaInv = Matrix.identity(p, p).times(this.m_ridge);
            double m = this.m_ridge;
            double logPi = 0.0;
            Matrix M0 = deltaInv;
            logPi = Math.log(Math.abs(sigma.det()));
            logPi *= -0.5 * (m + (double)p + 2.0);
            likelihood += (logPi -= 0.5 * sigma.inverse().times(M0).trace());
        }
        return likelihood;
    }

    private void impute(Instances data, Matrix theta) throws Exception {
        int numInCurrentPattern;
        int p = this.m_numAttributes;
        for (int currentPatternStart = 0; currentPatternStart < data.numInstances(); currentPatternStart += numInCurrentPattern) {
            numInCurrentPattern = (int)data.instance(currentPatternStart).value(0);
            boolean[] r = new boolean[p + 1];
            int[] observedColumns = new int[p + 1];
            int[] missingColumns = new int[p + 1];
            int numMissing = 0;
            int numObserved = 0;
            for (int l = 1; l < p + 1; ++l) {
                if (data.instance(currentPatternStart).isMissing(l)) {
                    missingColumns[numMissing++] = l;
                    continue;
                }
                observedColumns[numObserved++] = l;
                r[l] = true;
            }
            observedColumns[numObserved] = -1;
            missingColumns[numMissing] = -1;
            for (int j = 1; j < p + 1; ++j) {
                if (r[j] && theta.get(j, j) > 0.0) {
                    theta = EMImputation.swp(theta, j);
                    continue;
                }
                if (r[j] || !(theta.get(j, j) < 0.0)) continue;
                theta = EMImputation.rsw(theta, j);
            }
            for (int i = 0; i < numInCurrentPattern; ++i) {
                int jCounter = 0;
                int j = missingColumns[jCounter];
                while (j != -1) {
                    data.instance(currentPatternStart + i).setValue(j, theta.get(0, j));
                    int kCounter = 0;
                    int k = observedColumns[kCounter];
                    while (k != -1) {
                        double y_ij = data.instance(currentPatternStart + i).value(j);
                        double y_ik = data.instance(currentPatternStart + i).value(k);
                        double theta_kj = theta.get(k, j);
                        data.instance(currentPatternStart + i).setValue(j, y_ij + theta_kj * y_ik);
                        k = observedColumns[++kCounter];
                    }
                    j = missingColumns[++jCounter];
                }
            }
        }
    }

    private static Matrix doSweep(Matrix g, int k, int dir) throws Exception {
        int p = g.getRowDimension();
        if (k < 0 || k >= p) {
            throw new Exception("Position to be swept on must be within range.");
        }
        if (dir != 1 && dir != -1) {
            throw new Exception("Sweep direction must be 1 or -1.");
        }
        Matrix h = g.copy();
        double kkValue = g.get(k, k);
        if (kkValue == 0.0) {
            throw new Exception("Sweep: Division by zero (pivot value).");
        }
        for (int i = 0; i < p; ++i) {
            for (int j = i; j < p; ++j) {
                if (i == k && j == k) {
                    h.set(i, j, -1.0 / kkValue);
                    continue;
                }
                if (i == k || j == k) {
                    h.set(i, j, (double)dir * g.get(i, j) / kkValue);
                    h.set(j, i, h.get(i, j));
                    continue;
                }
                h.set(i, j, g.get(i, j) - g.get(i, k) * g.get(k, j) / kkValue);
                h.set(j, i, h.get(i, j));
            }
        }
        return h;
    }

    private static Matrix swp(Matrix g, int k) throws Exception {
        return EMImputation.doSweep(g, k, 1);
    }

    private static Matrix rsw(Matrix g, int k) throws Exception {
        return EMImputation.doSweep(g, k, -1);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] argv) {
        EMImputation.runFilter(new EMImputation(), argv);
    }
}

