/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.scripting;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.scripting.Jython;

public class JythonClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = -9078371491735496175L;
    protected File m_JythonModule = new File(System.getProperty("user.dir"));
    protected String[] m_JythonOptions = new String[0];
    protected File[] m_JythonPaths = new File[0];
    protected transient Classifier m_JythonObject = null;

    public String globalInfo() {
        return "A wrapper class for Jython code. Even though the classifier is serializable, the trained classifier cannot be stored persistently. I.e., one cannot store a model file and re-load it at a later point in time again to make predictions.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe Jython module to load (full path)\n\tOptions after '--' will be passed on to the Jython module.", "J", 1, "-J <filename>"));
        result.addElement(new Option("\tThe paths to add to 'sys.path' (comma-separated list).", "P", 1, "-P <directory[,directory,...]>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.m_JythonOptions = new String[0];
        this.setJythonPaths(Utils.getOption('P', options));
        String tmpStr = Utils.getOption('J', options);
        if (tmpStr.length() != 0) {
            this.setJythonModule(new File(tmpStr));
        } else {
            this.setJythonModule(new File(System.getProperty("user.dir")));
        }
        this.setJythonOptions(Utils.joinOptions((String[])Utils.partitionOptions(options).clone()));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        if (this.getJythonPaths().length() > 0) {
            result.add("-P");
            result.add("" + this.getJythonPaths());
        }
        result.add("-J");
        result.add("" + this.getJythonModule().getAbsolutePath());
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.m_JythonOptions.length > 0) {
            options = this.m_JythonOptions;
            result.add("--");
            for (i = 0; i < options.length; ++i) {
                result.add(options[i]);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String jythonModuleTipText() {
        return "The Jython module to load and execute.";
    }

    public void setJythonModule(File value) {
        this.m_JythonModule = value;
        this.initJythonObject();
    }

    public File getJythonModule() {
        return this.m_JythonModule;
    }

    public String jythonOptionsTipText() {
        return "The options for the Jython module.";
    }

    public void setJythonOptions(String value) {
        try {
            this.m_JythonOptions = (String[])Utils.splitOptions(value).clone();
            this.initJythonObject();
        }
        catch (Exception e) {
            this.m_JythonOptions = new String[0];
            e.printStackTrace();
        }
    }

    public String getJythonOptions() {
        return Utils.joinOptions(this.m_JythonOptions);
    }

    public String jythonPathsTipText() {
        return "Comma-separated list of additional paths that get added to 'sys.path'.";
    }

    public void setJythonPaths(String value) {
        if (value.length() == 0) {
            this.m_JythonPaths = new File[0];
        } else {
            String[] paths = value.split(",");
            this.m_JythonPaths = new File[paths.length];
            for (int i = 0; i < this.m_JythonPaths.length; ++i) {
                this.m_JythonPaths[i] = new File(paths[i]);
            }
        }
    }

    public String getJythonPaths() {
        String result = "";
        for (int i = 0; i < this.m_JythonPaths.length; ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + this.m_JythonPaths[i].getAbsolutePath();
        }
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.m_JythonObject == null) {
            result = new Capabilities(this);
            result.disableAll();
        } else {
            result = this.m_JythonObject.getCapabilities();
        }
        result.enableAllAttributeDependencies();
        result.enableAllClassDependencies();
        return result;
    }

    protected void initJythonObject() {
        try {
            this.m_JythonObject = this.m_JythonModule.isFile() ? (Classifier)Jython.newInstance(this.m_JythonModule, Classifier.class, this.m_JythonPaths) : null;
            if (this.m_JythonObject != null) {
                ((OptionHandler)((Object)this.m_JythonObject)).setOptions((String[])this.m_JythonOptions.clone());
            }
        }
        catch (Exception e) {
            this.m_JythonObject = null;
            e.printStackTrace();
        }
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        if (!Jython.isPresent()) {
            throw new Exception("Jython classes not in CLASSPATH!");
        }
        this.initJythonObject();
        if (this.m_JythonObject != null) {
            this.m_JythonObject.buildClassifier(instances);
        } else {
            System.err.println("buildClassifier: No Jython object present!");
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.classifyInstance(instance);
        }
        return Utils.missingValue();
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.distributionForInstance(instance);
        }
        return new double[instance.numClasses()];
    }

    public String toString() {
        if (this.m_JythonObject != null) {
            return this.m_JythonObject.toString();
        }
        return "No Jython module loaded.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        JythonClassifier.runClassifier(new JythonClassifier(), args);
    }
}

