/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.misc.monotone.Coordinates;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.classifiers.misc.monotone.DiscreteDistribution;
import weka.classifiers.misc.monotone.DistributionUtils;
import weka.classifiers.misc.monotone.EnumerationIterator;
import weka.classifiers.misc.monotone.NominalLossFunction;
import weka.classifiers.misc.monotone.ZeroOneLossFunction;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public abstract class OSDLCore
extends AbstractClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -9209888846680062897L;
    public static final int CT_REGRESSION = 0;
    public static final int CT_WEIGHTED_SUM = 1;
    public static final int CT_MAXPROB = 2;
    public static final int CT_MEDIAN = 3;
    public static final int CT_MEDIAN_REAL = 4;
    public static final Tag[] TAGS_CLASSIFICATIONTYPES = new Tag[]{new Tag(0, "REG", "Regression"), new Tag(1, "WSUM", "Weighted Sum"), new Tag(2, "MAX", "Maximum probability"), new Tag(3, "MED", "Median"), new Tag(4, "RMED", "Median without rounding")};
    private int m_ctype = 3;
    private Instances m_train;
    private Map m_estimatedDistributions;
    private Map m_estimatedCumulativeDistributions;
    private double m_s = 0.5;
    private double m_sLower = 0.0;
    private double m_sUpper = 1.0;
    private int m_sNrParts = 10;
    private boolean m_tuneInterpolationParameter = false;
    private boolean m_interpolationParameterValid = false;
    private boolean m_balanced = false;
    private boolean m_weighted = false;
    private Coordinates smallestElement;
    private Coordinates biggestElement;

    public String globalInfo() {
        return "This class is an implementation of the Ordinal Stochastic Dominance Learner.\nFurther information regarding the OSDL-algorithm can be found in:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "For more information about supervised ranking, see\n\n" + "http://users.ugent.be/~slievens/supervised_ranking.php";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "S. Lievens and B. De Baets and K. Cao-Van");
        result.setValue(TechnicalInformation.Field.YEAR, "2006");
        result.setValue(TechnicalInformation.Field.TITLE, "A Probabilistic Framework for the Design of Instance-Based Supervised Ranking Algorithms in an Ordinal Setting");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Annals of Operations Research");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.PHDTHESIS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Kim Cao-Van");
        additional.setValue(TechnicalInformation.Field.YEAR, "2003");
        additional.setValue(TechnicalInformation.Field.TITLE, "Supervised ranking: from semantics to algorithms");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        additional = result.add(TechnicalInformation.Type.MASTERSTHESIS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Stijn Lievens");
        additional.setValue(TechnicalInformation.Field.YEAR, "2004");
        additional.setValue(TechnicalInformation.Field.TITLE, "Studie en implementatie van instantie-gebaseerde algoritmen voor gesuperviseerd rangschikken");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "Ghent University");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        try {
            return this.classifyInstance(instance, this.m_s, this.m_ctype);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private double classifyInstance(Instance instance, double s, int ctype) throws IllegalArgumentException, IllegalStateException {
        if (s < 0.0 || s > 1.0) {
            throw new IllegalArgumentException("Interpolation parameter is not valid " + s);
        }
        DiscreteDistribution dist = null;
        dist = !this.m_balanced ? this.distributionForInstance(instance, s) : this.distributionForInstanceBalanced(instance, s);
        if (dist == null) {
            throw new IllegalStateException("Null distribution predicted");
        }
        double value = 0.0;
        switch (ctype) {
            case 0: 
            case 1: {
                value = dist.mean();
                if (ctype != 1) break;
                value = Math.round(value);
                break;
            }
            case 2: {
                value = dist.modes()[0];
                break;
            }
            case 3: 
            case 4: {
                value = dist.median();
                if (ctype != 3) break;
                value = Math.round(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid classification type!");
            }
        }
        return value;
    }

    @Override
    public double[] distributionForInstance(Instance instance) {
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        if (!this.m_balanced) {
            return this.distributionForInstance(instance, this.m_s).toArray();
        }
        return this.distributionForInstanceBalanced(instance, this.m_s).toArray();
    }

    public double[] cumulativeDistributionForInstance(Instance instance) {
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        if (!this.m_balanced) {
            return this.cumulativeDistributionForInstance(instance, this.m_s).toArray();
        }
        return this.cumulativeDistributionForInstanceBalanced(instance, this.m_s).toArray();
    }

    private DiscreteDistribution distributionForInstance(Instance instance, double s) {
        return new DiscreteDistribution(this.cumulativeDistributionForInstance(instance, s));
    }

    private DiscreteDistribution distributionForInstanceBalanced(Instance instance, double s) {
        return new DiscreteDistribution(this.cumulativeDistributionForInstanceBalanced(instance, s));
    }

    private CumulativeDiscreteDistribution cumulativeDistributionForInstance(Instance instance, double s) {
        Coordinates xc = new Coordinates(instance);
        int n = instance.numClasses();
        int nrSmaller = 0;
        int nrGreater = 0;
        if (!this.containsSmallestElement()) {
            nrSmaller = 1;
        }
        if (!this.containsBiggestElement()) {
            nrGreater = 1;
        }
        CumulativeDiscreteDistribution fMin = DistributionUtils.getMinimalCumulativeDiscreteDistribution(n);
        CumulativeDiscreteDistribution fMax = DistributionUtils.getMaximalCumulativeDiscreteDistribution(n);
        for (Coordinates yc : this.m_estimatedCumulativeDistributions.keySet()) {
            CumulativeDiscreteDistribution cdf = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(yc);
            if (yc.equals(xc)) {
                ++nrSmaller;
                fMin = DistributionUtils.takeMin(fMin, cdf);
                ++nrGreater;
                fMax = DistributionUtils.takeMax(fMax, cdf);
                continue;
            }
            if (yc.strictlySmaller(xc)) {
                ++nrSmaller;
                fMin = DistributionUtils.takeMin(fMin, cdf);
                continue;
            }
            if (!xc.strictlySmaller(yc)) continue;
            ++nrGreater;
            fMax = DistributionUtils.takeMax(fMax, cdf);
        }
        if (this.m_weighted) {
            s = (double)nrSmaller / (double)(nrSmaller + nrGreater);
            if (this.m_Debug) {
                System.err.println("Weighted OSDL: interpolation parameter is s = " + s);
            }
        }
        return DistributionUtils.interpolate(fMin, fMax, 1.0 - s);
    }

    private boolean containsSmallestElement() {
        return this.m_estimatedCumulativeDistributions.containsKey(this.smallestElement);
    }

    private boolean containsBiggestElement() {
        return this.m_estimatedCumulativeDistributions.containsKey(this.biggestElement);
    }

    private CumulativeDiscreteDistribution cumulativeDistributionForInstanceBalanced(Instance instance, double s) {
        Coordinates xc = new Coordinates(instance);
        int n = instance.numClasses();
        int[] n_m = new int[n];
        int[] n_M = new int[n];
        CumulativeDiscreteDistribution fMin = DistributionUtils.getMinimalCumulativeDiscreteDistribution(n);
        CumulativeDiscreteDistribution fMax = DistributionUtils.getMaximalCumulativeDiscreteDistribution(n);
        for (Coordinates yc : this.m_estimatedCumulativeDistributions.keySet()) {
            DiscreteEstimator df;
            CumulativeDiscreteDistribution cdf = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(yc);
            if (yc.equals(xc)) {
                df = (DiscreteEstimator)this.m_estimatedDistributions.get(yc);
                this.updateN_m(n_m, df);
                this.updateN_M(n_M, df);
                fMin = DistributionUtils.takeMin(fMin, cdf);
                fMax = DistributionUtils.takeMax(fMax, cdf);
                continue;
            }
            if (yc.strictlySmaller(xc)) {
                df = (DiscreteEstimator)this.m_estimatedDistributions.get(yc);
                this.updateN_m(n_m, df);
                fMin = DistributionUtils.takeMin(fMin, cdf);
                continue;
            }
            if (!xc.strictlySmaller(yc)) continue;
            df = (DiscreteEstimator)this.m_estimatedDistributions.get(yc);
            this.updateN_M(n_M, df);
            fMax = DistributionUtils.takeMax(fMax, cdf);
        }
        double[] dd = new double[n];
        for (int i = 0; i < n; ++i) {
            double fmin = fMin.getCumulativeProbability(i);
            double fmax = fMax.getCumulativeProbability(i);
            if (this.m_weighted) {
                if (fmin < fmax) {
                    dd[i] = ((double)n_m[i] * fmin + (double)n_M[i] * fmax) / (double)(n_m[i] + n_M[i]);
                    continue;
                }
                if (n_m[i] + n_M[i] == 0) {
                    dd[i] = s * fmin + (1.0 - s) * fmax;
                    continue;
                }
                dd[i] = ((double)n_M[i] * fmin + (double)n_m[i] * fmax) / (double)(n_m[i] + n_M[i]);
                continue;
            }
            dd[i] = fmin < fmax ? ((double)n_m[i] * fmin + (double)n_M[i] * fmax) / (double)(n_m[i] + n_M[i]) : s * fmin + (1.0 - s) * fmax;
        }
        try {
            return new CumulativeDiscreteDistribution(dd);
        }
        catch (IllegalArgumentException e) {
            System.err.println("We tried to create a cumulative discrete distribution from the following array");
            for (int i = 0; i < dd.length; ++i) {
                System.err.print(dd[i] + " ");
            }
            System.err.println();
            throw new AssertionError(dd);
        }
    }

    private void updateN_m(int[] n_m, DiscreteEstimator de) {
        int[] tmp = new int[n_m.length];
        tmp[0] = (int)de.getSumOfCounts() - (int)de.getCount(0.0);
        n_m[0] = n_m[0] + tmp[0];
        for (int i = 1; i < n_m.length; ++i) {
            tmp[i] = tmp[i - 1] - (int)de.getCount(i);
            int n = i;
            n_m[n] = n_m[n] + tmp[i];
        }
        if (n_m[n_m.length - 1] != 0) {
            System.err.println("******** Problem with n_m in " + this.m_train.relationName());
            System.err.println("Last argument is non-zero, namely : " + n_m[n_m.length - 1]);
        }
    }

    private void updateN_M(int[] n_M, DiscreteEstimator de) {
        int n = n_M.length;
        int[] tmp = new int[n];
        tmp[n - 1] = (int)de.getSumOfCounts();
        int n2 = n - 1;
        n_M[n2] = n_M[n2] + tmp[n - 1];
        for (int i = n - 2; i >= 0; --i) {
            tmp[i] = tmp[i + 1] - (int)de.getCount(i + 1);
            int n3 = i;
            n_M[n3] = n_M[n3] + tmp[i];
        }
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        Instance instance;
        this.getCapabilities().testWithFail(instances);
        this.m_train = new Instances(instances);
        this.m_train.deleteWithMissingClass();
        this.m_estimatedDistributions = new HashMap(this.m_train.numInstances() / 2);
        Iterator it = new EnumerationIterator(instances.enumerateInstances());
        while (it.hasNext()) {
            instance = (Instance)it.next();
            Coordinates c = new Coordinates(instance);
            DiscreteEstimator df = (DiscreteEstimator)this.m_estimatedDistributions.get(c);
            if (df == null) {
                df = new DiscreteEstimator(instances.numClasses(), 0.0);
            }
            df.addValue(instance.classValue(), instance.weight());
            this.m_estimatedDistributions.put(c, df);
        }
        this.m_estimatedCumulativeDistributions = new HashMap(this.m_estimatedDistributions.size() / 2);
        for (Coordinates c : this.m_estimatedDistributions.keySet()) {
            DiscreteEstimator df = (DiscreteEstimator)this.m_estimatedDistributions.get(c);
            this.m_estimatedCumulativeDistributions.put(c, new CumulativeDiscreteDistribution(df));
        }
        if (this.m_tuneInterpolationParameter && !this.m_interpolationParameterValid) {
            this.tuneInterpolationParameter();
        }
        double[] tmpAttValues = new double[instances.numAttributes()];
        instance = new DenseInstance(1.0, tmpAttValues);
        instance.setDataset(instances);
        this.smallestElement = new Coordinates(instance);
        if (this.m_Debug) {
            System.err.println("minimal element of data space = " + this.smallestElement);
        }
        for (int i = 0; i < tmpAttValues.length; ++i) {
            tmpAttValues[i] = instances.attribute(i).numValues() - 1;
        }
        instance = new DenseInstance(1.0, tmpAttValues);
        instance.setDataset(instances);
        this.biggestElement = new Coordinates(instance);
        if (this.m_Debug) {
            System.err.println("maximal element of data space = " + this.biggestElement);
        }
    }

    public String classificationTypeTipText() {
        return "Sets the way in which a single label will be extracted from the estimated distribution.";
    }

    public void setClassificationType(SelectedTag value) {
        if (value.getTags() == TAGS_CLASSIFICATIONTYPES) {
            this.m_ctype = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getClassificationType() {
        return new SelectedTag(this.m_ctype, TAGS_CLASSIFICATIONTYPES);
    }

    public String tuneInterpolationParameterTipText() {
        return "Whether to tune the interpolation parameter based on the bounds.";
    }

    public void setTuneInterpolationParameter(boolean value) {
        this.m_tuneInterpolationParameter = value;
    }

    public boolean getTuneInterpolationParameter() {
        return this.m_tuneInterpolationParameter;
    }

    public String interpolationParameterLowerBoundTipText() {
        return "Sets the lower bound for the interpolation parameter tuning (0 <= x < 1).";
    }

    public void setInterpolationParameterLowerBound(double value) {
        if (value < 0.0 || value >= 1.0 || value > this.getInterpolationParameterUpperBound()) {
            throw new IllegalArgumentException("Illegal lower bound");
        }
        this.m_sLower = value;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public double getInterpolationParameterLowerBound() {
        return this.m_sLower;
    }

    public String interpolationParameterUpperBoundTipText() {
        return "Sets the upper bound for the interpolation parameter tuning (0 < x <= 1).";
    }

    public void setInterpolationParameterUpperBound(double value) {
        if (value <= 0.0 || value > 1.0 || value < this.getInterpolationParameterLowerBound()) {
            throw new IllegalArgumentException("Illegal upper bound");
        }
        this.m_sUpper = value;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public double getInterpolationParameterUpperBound() {
        return this.m_sUpper;
    }

    public void setInterpolationParameterBounds(double sLow, double sUp) throws IllegalArgumentException {
        if (sLow < 0.0 || sUp > 1.0 || sLow > sUp) {
            throw new IllegalArgumentException("Illegal upper and lower bounds");
        }
        this.m_sLower = sLow;
        this.m_sUpper = sUp;
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = false;
    }

    public String interpolationParameterTipText() {
        return "Sets the value of the interpolation parameter s;Estimated distribution is s * f_min + (1 - s) *  f_max. ";
    }

    public void setInterpolationParameter(double s) throws IllegalArgumentException {
        if (0.0 > s || s > 1.0) {
            throw new IllegalArgumentException("Interpolationparameter exceeds bounds");
        }
        this.m_tuneInterpolationParameter = false;
        this.m_interpolationParameterValid = false;
        this.m_s = s;
    }

    public double getInterpolationParameter() {
        return this.m_s;
    }

    public String numberOfPartsForInterpolationParameterTipText() {
        return "Sets the granularity for tuning the interpolation parameter; For instance if the value is 32 then 33 values for the interpolation are checked.";
    }

    public void setNumberOfPartsForInterpolationParameter(int sParts) throws IllegalArgumentException {
        if (sParts <= 0) {
            throw new IllegalArgumentException("Number of parts is negative");
        }
        this.m_tuneInterpolationParameter = true;
        if (this.m_sNrParts != sParts) {
            this.m_interpolationParameterValid = false;
            this.m_sNrParts = sParts;
        }
    }

    public int getNumberOfPartsForInterpolationParameter() {
        return this.m_sNrParts;
    }

    public String balancedTipText() {
        return "If true, the balanced version of the OSDL-algorithm is used\nThis means that distinction is made between the normal and reversed preference situation.";
    }

    public void setBalanced(boolean balanced) {
        this.m_balanced = balanced;
    }

    public boolean getBalanced() {
        return this.m_balanced;
    }

    public String weightedTipText() {
        return "If true, the weighted version of the OSDL-algorithm is used";
    }

    public void setWeighted(boolean weighted) {
        this.m_weighted = weighted;
    }

    public boolean getWeighted() {
        return this.m_weighted;
    }

    public double getLowerBound() {
        return this.m_sLower;
    }

    public double getUpperBound() {
        return this.m_sUpper;
    }

    public int getNumInstances() {
        return this.m_train.numInstances();
    }

    public double tuneInterpolationParameter() {
        try {
            return this.tuneInterpolationParameter(this.m_sLower, this.m_sUpper, this.m_sNrParts, this.m_ctype);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public double tuneInterpolationParameter(double sLow, double sUp, int sParts, int ctype) throws IllegalArgumentException {
        this.setInterpolationParameterBounds(sLow, sUp);
        this.setNumberOfPartsForInterpolationParameter(sParts);
        this.setClassificationType(new SelectedTag(ctype, TAGS_CLASSIFICATIONTYPES));
        this.m_s = this.crossValidate(sLow, sUp, sParts, ctype);
        this.m_tuneInterpolationParameter = true;
        this.m_interpolationParameterValid = true;
        return this.m_s;
    }

    public double crossValidate() throws IllegalArgumentException {
        return this.crossValidate(this.m_sLower, this.m_sUpper, this.m_sNrParts, this.m_ctype);
    }

    public double crossValidate(double sLow, double sUp, int sNrParts, int ctype) throws IllegalArgumentException {
        double[] performanceStats = new double[sNrParts + 1];
        return this.crossValidate(sLow, sUp, sNrParts, ctype, performanceStats, new ZeroOneLossFunction());
    }

    public double crossValidate(double sLow, double sUp, int sNrParts, int ctype, double[] performanceStats, NominalLossFunction lossFunction) throws IllegalArgumentException {
        if (performanceStats.length < sNrParts + 1) {
            throw new IllegalArgumentException("Length of array is not sufficient");
        }
        if (!this.interpolationParametersValid(sLow, sUp, sNrParts)) {
            throw new IllegalArgumentException("Interpolation parameters are not valid");
        }
        if (!this.classificationTypeValid(ctype)) {
            throw new IllegalArgumentException("Not a valid classification type " + ctype);
        }
        Arrays.fill(performanceStats, 0, sNrParts + 1, 0.0);
        EnumerationIterator it = new EnumerationIterator(this.m_train.enumerateInstances());
        while (it.hasNext()) {
            Instance instance = (Instance)it.next();
            double classValue = instance.classValue();
            this.removeInstance(instance);
            double s = sLow;
            double step = (sUp - sLow) / (double)sNrParts;
            int i = 0;
            while (i <= sNrParts) {
                try {
                    int n = i;
                    performanceStats[n] = performanceStats[n] + lossFunction.loss(classValue, this.classifyInstance(instance, s, ctype));
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    System.exit(1);
                }
                ++i;
                s += step;
            }
            this.addInstance(instance);
        }
        double[] tmp = performanceStats;
        if (performanceStats.length > sNrParts + 1) {
            tmp = new double[sNrParts + 1];
            System.arraycopy(performanceStats, 0, tmp, 0, tmp.length);
        }
        int[] sort = Utils.stableSort(tmp);
        int minIndex = 0;
        while (minIndex + 1 < tmp.length && tmp[sort[minIndex + 1]] == tmp[sort[minIndex]]) {
            ++minIndex;
        }
        minIndex = sort[minIndex / 2];
        return sLow + (double)minIndex * (sUp - sLow) / (double)sNrParts;
    }

    private boolean classificationTypeValid(int ctype) {
        return ctype == 0 || ctype == 1 || ctype == 2 || ctype == 3 || ctype == 4;
    }

    private boolean interpolationParametersValid(double sLow, double sUp, int sNrParts) {
        return sLow >= 0.0 && sUp <= 1.0 && sLow < sUp && sNrParts > 0 || sLow == sUp && sNrParts == 0;
    }

    private void removeInstance(Instance instance) {
        Coordinates c = new Coordinates(instance);
        DiscreteEstimator df = (DiscreteEstimator)this.m_estimatedDistributions.get(c);
        df.addValue(instance.classValue(), -instance.weight());
        if (Math.abs(df.getSumOfCounts() - 0.0) < Utils.SMALL) {
            this.m_estimatedDistributions.remove(c);
            this.m_estimatedCumulativeDistributions.remove(c);
        } else {
            this.m_estimatedDistributions.put(c, df);
            this.m_estimatedCumulativeDistributions.put(c, new CumulativeDiscreteDistribution(df));
        }
    }

    private void addInstance(Instance instance) {
        Coordinates c = new Coordinates(instance);
        DiscreteEstimator df = (DiscreteEstimator)this.m_estimatedDistributions.get(c);
        if (df == null) {
            df = new DiscreteEstimator(instance.dataset().numClasses(), 0.0);
        }
        df.addValue(instance.classValue(), instance.weight());
        this.m_estimatedDistributions.put(c, df);
        this.m_estimatedCumulativeDistributions.put(c, new CumulativeDiscreteDistribution(df));
    }

    @Override
    public Enumeration listOptions() {
        Vector options = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            options.addElement(enm.nextElement());
        }
        String description = "\tSets the classification type to be used.\n\t(Default: " + new SelectedTag(3, TAGS_CLASSIFICATIONTYPES) + ")";
        String synopsis = "-C " + Tag.toOptionList(TAGS_CLASSIFICATIONTYPES);
        String name = "C";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tUse the balanced version of the Ordinal Stochastic Dominance Learner";
        synopsis = "-B";
        name = "B";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tUse the weighted version of the Ordinal Stochastic Dominance Learner";
        synopsis = "-W";
        name = "W";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tSets the value of the interpolation parameter (not with -W/T/P/L/U)\n\t(default: 0.5).";
        synopsis = "-S <value of interpolation parameter>";
        name = "S";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tTune the interpolation parameter (not with -W/S)\n\t(default: off)";
        synopsis = "-T";
        name = "T";
        options.addElement(new Option(description, name, 0, synopsis));
        description = "\tLower bound for the interpolation parameter (not with -W/S)\n\t(default: 0)";
        synopsis = "-L <Lower bound for interpolation parameter>";
        name = "L";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tUpper bound for the interpolation parameter (not with -W/S)\n\t(default: 1)";
        synopsis = "-U <Upper bound for interpolation parameter>";
        name = "U";
        options.addElement(new Option(description, name, 1, synopsis));
        description = "\tDetermines the step size for tuning the interpolation\n\tparameter, nl. (U-L)/P (not with -W/S)\n\t(default: 10)";
        synopsis = "-P <Number of parts>";
        name = "P";
        options.addElement(new Option(description, name, 1, synopsis));
        return options.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String args = Utils.getOption('C', options);
        if (args.length() != 0) {
            this.setClassificationType(new SelectedTag(args, TAGS_CLASSIFICATIONTYPES));
        } else {
            this.setClassificationType(new SelectedTag(3, TAGS_CLASSIFICATIONTYPES));
        }
        this.setBalanced(Utils.getFlag('B', options));
        if (Utils.getFlag('W', options)) {
            this.m_weighted = true;
            Utils.getOption('T', options);
            Utils.getOption('S', options);
            Utils.getOption('P', options);
            Utils.getOption('L', options);
            Utils.getOption('U', options);
        } else {
            this.m_tuneInterpolationParameter = Utils.getFlag('T', options);
            if (!this.m_tuneInterpolationParameter) {
                Utils.getOption('P', options);
                Utils.getOption('L', options);
                Utils.getOption('U', options);
                args = Utils.getOption('S', options);
                if (args.length() != 0) {
                    this.setInterpolationParameter(Double.parseDouble(args));
                } else {
                    this.setInterpolationParameter(0.5);
                }
            } else {
                Utils.getOption('S', options);
                args = Utils.getOption('L', options);
                double l = this.m_sLower;
                l = args.length() != 0 ? Double.parseDouble(args) : 0.0;
                args = Utils.getOption('U', options);
                double u = this.m_sUpper;
                u = args.length() != 0 ? Double.parseDouble(args) : 1.0;
                if (this.m_tuneInterpolationParameter) {
                    this.setInterpolationParameterBounds(l, u);
                }
                if ((args = Utils.getOption('P', options)).length() != 0) {
                    this.setNumberOfPartsForInterpolationParameter(Integer.parseInt(args));
                } else {
                    this.setNumberOfPartsForInterpolationParameter(10);
                }
            }
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-C");
        result.add("" + this.getClassificationType());
        if (this.m_balanced) {
            result.add("-B");
        }
        if (this.m_weighted) {
            result.add("-W");
        } else if (!this.m_tuneInterpolationParameter) {
            result.add("-S");
            result.add(Double.toString(this.m_s));
        } else {
            result.add("-T");
            result.add("-L");
            result.add(Double.toString(this.m_sLower));
            result.add("-U");
            result.add(Double.toString(this.m_sUpper));
            result.add("-P");
            result.add(Integer.toString(this.m_sNrParts));
        }
        return result.toArray(new String[result.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_balanced) {
            sb.append("Balanced OSDL\n=============\n\n");
        } else {
            sb.append("Ordinary OSDL\n=============\n\n");
        }
        if (this.m_weighted) {
            sb.append("Weighted variant\n");
        }
        sb.append("Classification type: " + this.getClassificationType() + "\n");
        if (!this.m_weighted) {
            sb.append("Interpolation parameter: " + this.m_s + "\n");
            if (this.m_tuneInterpolationParameter) {
                sb.append("Bounds and stepsize: " + this.m_sLower + " " + this.m_sUpper + " " + this.m_sNrParts + "\n");
                if (!this.m_interpolationParameterValid) {
                    sb.append("Interpolation parameter is not valid");
                }
            }
        }
        if (this.m_Debug && this.m_estimatedCumulativeDistributions != null) {
            for (Coordinates yc : this.m_estimatedCumulativeDistributions.keySet()) {
                CumulativeDiscreteDistribution cdf = (CumulativeDiscreteDistribution)this.m_estimatedCumulativeDistributions.get(yc);
                sb.append("[" + yc.hashCode() + "] " + yc.toString() + " --> " + cdf.toString() + "\n");
            }
        }
        return sb.toString();
    }
}

