/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class FLR
extends AbstractClassifier
implements Serializable,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 3337906540579569626L;
    public static final float EPSILON = 1.0E-6f;
    private Vector learnedCode;
    private double m_Rhoa = 0.5;
    private FuzzyLattice bounds;
    private File m_BoundsFile = new File("");
    private boolean m_showRules = true;
    private int[] index;
    private String[] classNames;

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        for (i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            AttributeStats stats = data.attributeStats(i);
            if (data.numInstances() != stats.missingCount && !Double.isNaN(stats.numericStats.min) && !Double.isInfinite(stats.numericStats.min)) continue;
            throw new Exception("All values are missing!" + data.attribute(i).toString());
        }
        if (!this.m_BoundsFile.canRead()) {
            this.setBounds(data);
        } else {
            try {
                BufferedReader in = new BufferedReader(new FileReader(this.m_BoundsFile));
                String line = in.readLine();
                this.bounds = new FuzzyLattice(line);
            }
            catch (Exception e) {
                throw new Exception("Boundaries File structure error");
            }
        }
        if (this.bounds.length() != data.numAttributes() - 1) {
            throw new Exception("Incompatible bounds file!");
        }
        this.checkBounds();
        this.index = new int[data.numClasses()];
        this.classNames = new String[data.numClasses()];
        for (i = 0; i < data.numClasses(); ++i) {
            this.index[i] = 0;
            this.classNames[i] = "missing Class Name";
        }
        double rhoa = this.m_Rhoa;
        this.learnedCode = new Vector();
        if (data.firstInstance().classIsMissing()) {
            throw new Exception("In first instance, class is missing!");
        }
        FuzzyLattice Code2 = new FuzzyLattice(data.firstInstance(), this.bounds);
        this.learnedCode.addElement(Code2);
        int n = Code2.getCateg();
        this.index[n] = this.index[n] + 1;
        this.classNames[Code2.getCateg()] = data.firstInstance().stringValue(data.firstInstance().classIndex());
        for (int i2 = 1; i2 < data.numInstances(); ++i2) {
            boolean searching;
            Instance inst = data.instance(i2);
            int flag = 0;
            for (int w = 0; w < inst.numAttributes() - 1; ++w) {
                if (w == inst.classIndex() || !inst.isMissing(w)) continue;
                ++flag;
            }
            if (inst.classIsMissing() || flag == inst.numAttributes() - 1) continue;
            FuzzyLattice inputBuffer = new FuzzyLattice(data.instance(i2), this.bounds);
            double[] sigma = new double[this.learnedCode.size()];
            for (int j = 0; j < this.learnedCode.size(); ++j) {
                double numden;
                FuzzyLattice num = (FuzzyLattice)this.learnedCode.get(j);
                FuzzyLattice den = inputBuffer.join(num);
                sigma[j] = numden = num.valuation(this.bounds) / den.valuation(this.bounds);
            }
            do {
                int winner = 0;
                double winnerf = sigma[0];
                for (int j = 1; j < this.learnedCode.size(); ++j) {
                    if (!(winnerf < sigma[j])) continue;
                    winner = j;
                    winnerf = sigma[j];
                }
                FuzzyLattice num = inputBuffer;
                FuzzyLattice winnerBox = (FuzzyLattice)this.learnedCode.get(winner);
                FuzzyLattice den = winnerBox.join(num);
                double numden = num.valuation(this.bounds) / den.valuation(this.bounds);
                if (inputBuffer.getCateg() == winnerBox.getCateg() && rhoa < numden) {
                    this.learnedCode.setElementAt(winnerBox.join(inputBuffer), winner);
                    searching = false;
                    continue;
                }
                sigma[winner] = 0.0;
                rhoa += (double)1.0E-6f;
                searching = false;
                for (int j = 0; j < this.learnedCode.size(); ++j) {
                    if (sigma[j] == 0.0) continue;
                    searching = true;
                }
                if (searching) continue;
                this.learnedCode.addElement(inputBuffer);
                int n2 = inputBuffer.getCateg();
                this.index[n2] = this.index[n2] + 1;
                this.classNames[inputBuffer.getCateg()] = data.instance(i2).stringValue(data.instance(i2).classIndex());
            } while (searching);
        }
    }

    @Override
    public double classifyInstance(Instance instance) {
        FuzzyLattice inputBuffer = new FuzzyLattice(instance, this.bounds);
        double[] sigma = new double[this.learnedCode.size()];
        for (int j = 0; j < this.learnedCode.size(); ++j) {
            FuzzyLattice num = (FuzzyLattice)this.learnedCode.get(j);
            FuzzyLattice den = inputBuffer.join(num);
            sigma[j] = num.valuation(this.bounds) / den.valuation(this.bounds);
        }
        int winner = 0;
        double winnerf = sigma[0];
        for (int j = 1; j < this.learnedCode.size(); ++j) {
            if (!(winnerf < sigma[j])) continue;
            winner = j;
            winnerf = sigma[j];
        }
        FuzzyLattice currentBox = (FuzzyLattice)this.learnedCode.get(winner);
        return currentBox.getCateg();
    }

    public String toString() {
        if (this.learnedCode != null) {
            String output = "";
            output = "FLR classifier\n=======================\n Rhoa = " + this.m_Rhoa;
            if (this.m_showRules) {
                output = output + "\n Extracted Rules (Fuzzy Lattices):\n\n";
                output = output + this.showRules();
                output = output + "\n\n Metric Space:\n" + this.bounds.toString();
            }
            output = output + "\n Total Number of Rules:    " + this.learnedCode.size() + "\n";
            for (int i = 0; i < this.index.length; ++i) {
                output = output + " Rules pointing in Class " + this.classNames[i] + " :" + this.index[i] + "\n";
            }
            return output;
        }
        String output = "FLR classifier\n=======================\n Rhoa = " + this.m_Rhoa;
        output = output + "No model built";
        return output;
    }

    @Override
    public String toSummaryString() {
        String output = "";
        output = this.learnedCode == null ? output + "No model built" : output + "Total Number of Rules: " + this.learnedCode.size();
        return output;
    }

    public String showRules() {
        String output = "";
        for (int i = 0; i < this.learnedCode.size(); ++i) {
            FuzzyLattice Code2 = (FuzzyLattice)this.learnedCode.get(i);
            output = output + "Rule: " + i + " " + Code2.toString();
        }
        return output;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tSet vigilance parameter rhoa.\n\t(a float in range [0,1])", "R", 1, "-R"));
        newVector.addElement(new Option("\tSet boundaries File\n\tNote:  The boundaries file is a simple text file containing \n\ta row with a Fuzzy Lattice defining the metric space.\n\tFor example, the boundaries file could contain the following \n\tthe metric space for the iris dataset:\n\t[ 4.3  7.9 ]  [ 2.0  4.4 ]  [ 1.0  6.9 ]  [ 0.1  2.5 ]  in Class:  -1\n\tThis lattice just contains the min and max value in each \n\tdimension.\n\tIn other kind of problems this may not be just a min-max \n\toperation, but it could contain limits defined by the problem \n\titself.\n\tThus, this option should be set by the user.\n\tIf ommited, the metric space used contains the mins and maxs \n\tof the training split.", "B", 1, "-B"));
        newVector.addElement(new Option("\tShow Rules", "Y", 0, "-Y"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String boundsString;
        this.m_showRules = Utils.getFlag('Y', options);
        String rhoaString = Utils.getOption('R', options);
        if (rhoaString.length() != 0) {
            this.m_Rhoa = Double.parseDouble(rhoaString);
            if (this.m_Rhoa < 0.0 || this.m_Rhoa > 1.0) {
                throw new Exception("Vigilance parameter (rhoa) should be a real number in range [0,1]");
            }
        } else {
            this.m_Rhoa = 0.5;
        }
        if ((boundsString = Utils.getOption('B', options)).length() != 0) {
            this.m_BoundsFile = new File(boundsString);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        options[current++] = "-R";
        options[current++] = "" + this.getRhoa();
        if (this.m_showRules) {
            options[current++] = "-Y";
        }
        if (this.m_BoundsFile.toString() != "") {
            options[current++] = "-B";
            options[current++] = "" + this.getBoundsFile();
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public double getRhoa() {
        return this.m_Rhoa;
    }

    public String getBoundsFile() {
        return this.m_BoundsFile.toString();
    }

    public boolean getShowRules() {
        return this.m_showRules;
    }

    public void setRhoa(double newRhoa) throws Exception {
        if (newRhoa < 0.0 || newRhoa > 1.0) {
            throw new Exception("Vigilance parameter (rhoa) should be a real number in range [0,1]!!!");
        }
        this.m_Rhoa = newRhoa;
    }

    public void setBoundsFile(String newBoundsFile) {
        this.m_BoundsFile = new File(newBoundsFile);
    }

    public void setShowRules(boolean flag) {
        this.m_showRules = flag;
    }

    public void setBounds(Instances data) {
        this.bounds = new FuzzyLattice(data.numAttributes() - 1);
        int k = 0;
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (i == data.classIndex()) continue;
            AttributeStats stats = data.attributeStats(i);
            this.bounds.setMin(k, stats.numericStats.min);
            this.bounds.setMax(k, stats.numericStats.max);
            ++k;
        }
    }

    public void checkBounds() {
        for (int i = 0; i < this.bounds.length(); ++i) {
            if (this.bounds.getMin(i) != this.bounds.getMax(i)) continue;
            this.bounds.setMax(i, this.bounds.getMax(i) + (double)1.0E-6f);
        }
    }

    public String rhoaTipText() {
        return " The vigilance parameter value (default = 0.75)";
    }

    public String boundsFileTipText() {
        return " Point the filename containing the metric space";
    }

    public String showRulesTipText() {
        return " If true, displays the ruleset.";
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (FLR)");
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    public double measureNumRules() {
        if (this.learnedCode == null) {
            return 0.0;
        }
        return this.learnedCode.size();
    }

    public String globalInfo() {
        return "Fuzzy Lattice Reasoning Classifier (FLR) v5.0\n\nThe Fuzzy Lattice Reasoning Classifier uses the notion of Fuzzy Lattices for creating a Reasoning Environment.\nThe current version can be used for classification using numeric predictors.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "I. N. Athanasiadis and V. G. Kaburlasos and P. A. Mitkas and V. Petridis");
        result.setValue(TechnicalInformation.Field.TITLE, "Applying Machine Learning Techniques on Air Quality Data for Real-Time Decision Support");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "1st Intl. NAISO Symposium on Information Technologies in Environmental Engineering (ITEE-2003)");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Gdansk, Poland");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ICSC-NAISO Academic Press");
        result.setValue(TechnicalInformation.Field.NOTE, "Abstract in ICSC-NAISO Academic Press, Canada (ISBN:3906454339), pg.51");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.UNPUBLISHED);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "V. G. Kaburlasos and I. N. Athanasiadis and P. A. Mitkas and V. Petridis");
        additional.setValue(TechnicalInformation.Field.TITLE, "Fuzzy Lattice Reasoning (FLR) Classifier and its Application on Improved Estimation of Ambient Ozone Concentration");
        additional.setValue(TechnicalInformation.Field.YEAR, "2003");
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] args) {
        FLR.runClassifier(new FLR(), args);
    }

    private class FuzzyLattice
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -3568003680327062404L;
        private double[] min;
        private double[] max;
        private int categ;
        private String className;

        public FuzzyLattice(Instance dR, FuzzyLattice bounds) {
            this.min = new double[dR.numAttributes() - 1];
            this.max = new double[dR.numAttributes() - 1];
            int k = 0;
            for (int i = 0; i < dR.numAttributes(); ++i) {
                if (i == dR.classIndex()) continue;
                if (!dR.isMissing(i)) {
                    this.min[k] = dR.value(i) > bounds.getMin(k) ? dR.value(i) : bounds.getMin(k);
                    this.max[k] = dR.value(i) < bounds.getMax(k) ? dR.value(i) : bounds.getMax(k);
                    ++k;
                    continue;
                }
                this.min[k] = bounds.getMax(k);
                this.max[k] = bounds.getMin(k);
                ++k;
            }
            this.categ = (int)dR.value(dR.classIndex());
            this.className = dR.stringValue(dR.classIndex());
        }

        public FuzzyLattice(int length) {
            this.min = new double[length];
            this.max = new double[length];
            for (int i = 0; i < length; ++i) {
                this.min[i] = 0.0;
                this.max[i] = 0.0;
            }
            this.categ = -1;
            this.className = "Metric Space";
        }

        public FuzzyLattice(String rule) {
            int i;
            int size = 0;
            for (i = 0; i < rule.length(); ++i) {
                String s = rule.substring(i, i + 1);
                if (!s.equalsIgnoreCase("[")) continue;
                ++size;
            }
            this.min = new double[size];
            this.max = new double[size];
            i = 0;
            int k = 0;
            String temp = "";
            int s = 0;
            do {
                String character = rule.substring(s, s + 1);
                temp = temp + character;
                if (character.equalsIgnoreCase(" ")) {
                    if (!temp.equalsIgnoreCase(" ")) {
                        if (++k % 4 == 2) {
                            this.min[i] = Double.parseDouble(temp);
                        } else if (k % 4 == 3) {
                            this.max[i] = Double.parseDouble(temp);
                            ++i;
                        }
                    }
                    temp = "";
                }
                ++s;
            } while (i < size);
            this.categ = -1;
            this.className = "Metric Space";
        }

        public double valuation(FuzzyLattice bounds) {
            double resp = 0.0;
            for (int i = 0; i < this.min.length; ++i) {
                resp += 1.0 - (this.min[i] - bounds.getMin(i)) / (bounds.getMax(i) - bounds.getMin(i));
                resp += (this.max[i] - bounds.getMin(i)) / (bounds.getMax(i) - bounds.getMin(i));
            }
            return resp;
        }

        public int length() {
            return this.min.length;
        }

        public FuzzyLattice join(FuzzyLattice lattice) {
            FuzzyLattice b = new FuzzyLattice(lattice.length());
            for (int i = 0; i < lattice.min.length; ++i) {
                b.min[i] = lattice.min[i] < this.min[i] ? lattice.min[i] : this.min[i];
                b.max[i] = lattice.max[i] > this.max[i] ? lattice.max[i] : this.max[i];
            }
            b.categ = this.categ;
            b.className = this.className;
            return b;
        }

        public int getCateg() {
            return this.categ;
        }

        public void setCateg(int i) {
            this.categ = i;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String s) {
            this.className = s;
        }

        public double getMin(int i) {
            return this.min[i];
        }

        public double getMax(int i) {
            return this.max[i];
        }

        public void setMin(int i, double val) {
            this.min[i] = val;
        }

        public void setMax(int i, double val) {
            this.max[i] = val;
        }

        public String toString() {
            String rule = "";
            for (int i = 0; i < this.min.length; ++i) {
                rule = rule + "[ " + this.min[i] + "  " + this.max[i] + " ]  ";
            }
            rule = rule + "in Class:  " + this.className + " \n";
            return rule;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }
}

