/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import weka.core.Optimization;
import weka.core.RevisionUtils;

class TLD_Optm
extends Optimization {
    private double[] num;
    private double[] sSq;
    private double[] xBar;

    TLD_Optm() {
    }

    public void setNum(double[] n) {
        this.num = n;
    }

    public void setSSquare(double[] s) {
        this.sSq = s;
    }

    public void setXBar(double[] x) {
        this.xBar = x;
    }

    public static double diffLnGamma(double b) {
        double[] coef = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double rt = -0.5;
        rt += (b + 1.0) * Math.log(b + 6.0) - (b + 0.5) * Math.log(b + 5.5);
        double series1 = 1.000000000190015;
        double series2 = 1.000000000190015;
        for (int i = 0; i < 6; ++i) {
            series1 += coef[i] / (b + 1.5 + (double)i);
            series2 += coef[i] / (b + 1.0 + (double)i);
        }
        return rt += Math.log(series1 * b) - Math.log(series2 * (b + 0.5));
    }

    protected double diffFstDervLnGamma(double x) {
        double rt = 0.0;
        double series = 1.0;
        int i = 0;
        while (series >= m_Zero * 0.001) {
            series = 0.5 / ((x + (double)i) * (x + (double)i + 0.5));
            rt += series;
            ++i;
        }
        return rt;
    }

    protected double diffSndDervLnGamma(double x) {
        double rt = 0.0;
        double series = 1.0;
        int i = 0;
        while (series >= m_Zero * 0.001) {
            series = (x + (double)i + 0.25) / ((x + (double)i) * (x + (double)i) * (x + (double)i + 0.5) * (x + (double)i + 0.5));
            rt -= series;
            ++i;
        }
        return rt;
    }

    @Override
    protected double objectiveFunction(double[] x) {
        int numExs = this.num.length;
        double NLL = 0.0;
        double a = x[0];
        double b = x[1];
        double w = x[2];
        double m = x[3];
        for (int j = 0; j < numExs; ++j) {
            if (Double.isNaN(this.xBar[j])) continue;
            if (Double.isNaN(NLL += 0.5 * (b + this.num[j]) * Math.log((1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m))) && m_Debug) {
                System.err.println("???????????1: " + a + " " + b + " " + w + " " + m + "|x-: " + this.xBar[j] + "|n: " + this.num[j] + "|S^2: " + this.sSq[j]);
                System.exit(1);
            }
            if (Double.isNaN(NLL -= 0.5 * (b + this.num[j] - 1.0) * Math.log(1.0 + this.num[j] * w)) && m_Debug) {
                System.err.println("???????????2: " + a + " " + b + " " + w + " " + m + "|x-: " + this.xBar[j] + "|n: " + this.num[j] + "|S^2: " + this.sSq[j]);
                System.exit(1);
            }
            int halfNum = (int)this.num[j] / 2;
            for (int z = 1; z <= halfNum; ++z) {
                NLL -= Math.log(0.5 * b + 0.5 * this.num[j] - (double)z);
            }
            if (0.5 * this.num[j] > (double)halfNum) {
                NLL -= TLD_Optm.diffLnGamma(0.5 * b);
            }
            if (Double.isNaN(NLL) && m_Debug) {
                System.err.println("???????????3: " + a + " " + b + " " + w + " " + m + "|x-: " + this.xBar[j] + "|n: " + this.num[j] + "|S^2: " + this.sSq[j]);
                System.exit(1);
            }
            if (!Double.isNaN(NLL -= 0.5 * Math.log(a) * b) || !m_Debug) continue;
            System.err.println("???????????4:" + a + " " + b + " " + w + " " + m);
            System.exit(1);
        }
        if (m_Debug) {
            System.err.println("?????????????5: " + NLL);
        }
        if (Double.isNaN(NLL)) {
            System.exit(1);
        }
        return NLL;
    }

    @Override
    protected double[] evaluateGradient(double[] x) {
        double[] g = new double[x.length];
        int numExs = this.num.length;
        double a = x[0];
        double b = x[1];
        double w = x[2];
        double m = x[3];
        double da = 0.0;
        double db = 0.0;
        double dw = 0.0;
        double dm = 0.0;
        for (int j = 0; j < numExs; ++j) {
            if (Double.isNaN(this.xBar[j])) continue;
            double denorm = (1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m);
            da += 0.5 * (b + this.num[j]) * (1.0 + this.num[j] * w) / denorm - 0.5 * b / a;
            db += 0.5 * Math.log(denorm) - 0.5 * Math.log(1.0 + this.num[j] * w) - 0.5 * Math.log(a);
            int halfNum = (int)this.num[j] / 2;
            for (int z = 1; z <= halfNum; ++z) {
                db -= 1.0 / (b + this.num[j] - 2.0 * (double)z);
            }
            if (this.num[j] / 2.0 > (double)halfNum) {
                db -= 0.5 * this.diffFstDervLnGamma(0.5 * b);
            }
            dw += 0.5 * (b + this.num[j]) * (a + this.sSq[j]) * this.num[j] / denorm - 0.5 * (b + this.num[j] - 1.0) * this.num[j] / (1.0 + this.num[j] * w);
            dm += this.num[j] * (b + this.num[j]) * (m - this.xBar[j]) / denorm;
        }
        g[0] = da;
        g[1] = db;
        g[2] = dw;
        g[3] = dm;
        return g;
    }

    @Override
    protected double[] evaluateHessian(double[] x, int index) {
        double[] h = new double[x.length];
        int numExs = this.num.length;
        switch (index) {
            case 0: {
                double a = x[0];
                double b = x[1];
                double w = x[2];
                double m = x[3];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    double denorm = (1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m);
                    h[0] = h[0] + (0.5 * b / (a * a) - 0.5 * (b + this.num[j]) * (1.0 + this.num[j] * w) * (1.0 + this.num[j] * w) / (denorm * denorm));
                    h[1] = h[1] + (0.5 * (1.0 + this.num[j] * w) / denorm - 0.5 / a);
                    h[2] = h[2] + 0.5 * this.num[j] * this.num[j] * (b + this.num[j]) * (this.xBar[j] - m) * (this.xBar[j] - m) / (denorm * denorm);
                    h[3] = h[3] - this.num[j] * (b + this.num[j]) * (m - this.xBar[j]) * (1.0 + this.num[j] * w) / (denorm * denorm);
                }
                break;
            }
            case 1: {
                double a = x[0];
                double b = x[1];
                double w = x[2];
                double m = x[3];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    double denorm = (1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m);
                    h[0] = h[0] + (0.5 * (1.0 + this.num[j] * w) / denorm - 0.5 / a);
                    int halfNum = (int)this.num[j] / 2;
                    for (int z = 1; z <= halfNum; ++z) {
                        h[1] = h[1] + 1.0 / ((b + this.num[j] - 2.0 * (double)z) * (b + this.num[j] - 2.0 * (double)z));
                    }
                    if (this.num[j] / 2.0 > (double)halfNum) {
                        h[1] = h[1] - 0.25 * this.diffSndDervLnGamma(0.5 * b);
                    }
                    h[2] = h[2] + (0.5 * (a + this.sSq[j]) * this.num[j] / denorm - 0.5 * this.num[j] / (1.0 + this.num[j] * w));
                    h[3] = h[3] + this.num[j] * (m - this.xBar[j]) / denorm;
                }
                break;
            }
            case 2: {
                double a = x[0];
                double b = x[1];
                double w = x[2];
                double m = x[3];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    double denorm = (1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m);
                    h[0] = h[0] + 0.5 * this.num[j] * this.num[j] * (b + this.num[j]) * (this.xBar[j] - m) * (this.xBar[j] - m) / (denorm * denorm);
                    h[1] = h[1] + (0.5 * (a + this.sSq[j]) * this.num[j] / denorm - 0.5 * this.num[j] / (1.0 + this.num[j] * w));
                    h[2] = h[2] + (0.5 * (b + this.num[j] - 1.0) * this.num[j] * this.num[j] / ((1.0 + this.num[j] * w) * (1.0 + this.num[j] * w)) - 0.5 * (b + this.num[j]) * (a + this.sSq[j]) * (a + this.sSq[j]) * this.num[j] * this.num[j] / (denorm * denorm));
                    h[3] = h[3] - this.num[j] * this.num[j] * (b + this.num[j]) * (m - this.xBar[j]) * (a + this.sSq[j]) / (denorm * denorm);
                }
                break;
            }
            case 3: {
                double a = x[0];
                double b = x[1];
                double w = x[2];
                double m = x[3];
                for (int j = 0; j < numExs; ++j) {
                    if (Double.isNaN(this.xBar[j])) continue;
                    double denorm = (1.0 + this.num[j] * w) * (a + this.sSq[j]) + this.num[j] * (this.xBar[j] - m) * (this.xBar[j] - m);
                    h[0] = h[0] - this.num[j] * (b + this.num[j]) * (m - this.xBar[j]) * (1.0 + this.num[j] * w) / (denorm * denorm);
                    h[1] = h[1] + this.num[j] * (m - this.xBar[j]) / denorm;
                    h[2] = h[2] - this.num[j] * this.num[j] * (b + this.num[j]) * (m - this.xBar[j]) * (a + this.sSq[j]) / (denorm * denorm);
                    h[3] = h[3] + this.num[j] * (b + this.num[j]) * ((1.0 + this.num[j] * w) * (a + this.sSq[j]) - this.num[j] * (m - this.xBar[j]) * (m - this.xBar[j])) / (denorm * denorm);
                }
                break;
            }
        }
        return h;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5481 $");
    }
}

