/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableDistributionGenerator;

public class GaussianGenerator
extends RandomizableDistributionGenerator
implements NumericAttributeGenerator {
    private static final long serialVersionUID = 4860675869078046797L;

    @Override
    public String globalInfo() {
        return "An artificial data generator that uses a single Gaussian distribution.\n\nIf a mixture of Gaussians is required, use the EM Generator.";
    }

    @Override
    public double generate() {
        double gaussian = this.m_Random.nextGaussian();
        double value = this.m_Mean + gaussian * this.m_StandardDeviation;
        return value;
    }

    @Override
    public double getProbabilityOf(double valuex) {
        double twopisqrt = Math.sqrt(Math.PI * 2);
        double left = 1.0 / (this.m_StandardDeviation * twopisqrt);
        double diffsquared = Math.pow(valuex - this.m_Mean, 2.0);
        double bottomright = 2.0 * Math.pow(this.m_StandardDeviation, 2.0);
        double brackets = -1.0 * (diffsquared / bottomright);
        double probx = left * Math.exp(brackets);
        return probx;
    }

    @Override
    public double getLogProbabilityOf(double valuex) {
        double twopisqrt = Math.log(Math.sqrt(Math.PI * 2));
        double left = -(Math.log(this.m_StandardDeviation) + twopisqrt);
        double diffsquared = Math.pow(valuex - this.m_Mean, 2.0);
        double bottomright = 2.0 * Math.pow(this.m_StandardDeviation, 2.0);
        double brackets = -1.0 * (diffsquared / bottomright);
        double probx = left + brackets;
        return probx;
    }
}

