/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import weka.associations.tertius.Body;
import weka.associations.tertius.Head;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Literal;
import weka.associations.tertius.LiteralSet;
import weka.associations.tertius.Predicate;
import weka.associations.tertius.SimpleLinkedList;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Rule
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = -7763378359090435505L;
    private Body m_body;
    private Head m_head;
    private boolean m_repeatPredicate;
    private int m_maxLiterals;
    private boolean m_negBody;
    private boolean m_negHead;
    private boolean m_classRule;
    private boolean m_singleHead;
    private int m_numInstances;
    private ArrayList m_counterInstances;
    private int m_counter;
    private double m_confirmation;
    private double m_optimistic;
    public static Comparator confirmationComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double conf2;
            Rule r1 = (Rule)o1;
            Rule r2 = (Rule)o2;
            double conf1 = r1.getConfirmation();
            if (conf1 > (conf2 = r2.getConfirmation())) {
                return -1;
            }
            if (conf1 < conf2) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator observedComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double obs2;
            Rule r1 = (Rule)o1;
            Rule r2 = (Rule)o2;
            double obs1 = r1.getObservedFrequency();
            if (obs1 < (obs2 = r2.getObservedFrequency())) {
                return -1;
            }
            if (obs1 > obs2) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator optimisticComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double opt2;
            Rule r1 = (Rule)o1;
            Rule r2 = (Rule)o2;
            double opt1 = r1.getOptimistic();
            if (opt1 > (opt2 = r2.getOptimistic())) {
                return -1;
            }
            if (opt1 < opt2) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator confirmationThenObservedComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int confirmationComparison = confirmationComparator.compare(o1, o2);
            if (confirmationComparison != 0) {
                return confirmationComparison;
            }
            return observedComparator.compare(o1, o2);
        }
    };
    public static Comparator optimisticThenObservedComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            int optimisticComparison = optimisticComparator.compare(o1, o2);
            if (optimisticComparison != 0) {
                return optimisticComparison;
            }
            return observedComparator.compare(o1, o2);
        }
    };

    public Rule(boolean repeatPredicate, int maxLiterals, boolean negBody, boolean negHead, boolean classRule, boolean horn) {
        this.m_body = new Body();
        this.m_head = new Head();
        this.m_repeatPredicate = repeatPredicate;
        this.m_maxLiterals = maxLiterals;
        this.m_negBody = negBody && !horn;
        this.m_negHead = negHead && !horn;
        this.m_classRule = classRule;
        this.m_singleHead = classRule || horn;
    }

    public Rule(Instances instances, boolean repeatPredicate, int maxLiterals, boolean negBody, boolean negHead, boolean classRule, boolean horn) {
        this.m_body = new Body(instances);
        this.m_head = new Head(instances);
        this.m_repeatPredicate = repeatPredicate;
        this.m_maxLiterals = maxLiterals;
        this.m_negBody = negBody && !horn;
        this.m_negHead = negHead && !horn;
        this.m_classRule = classRule;
        this.m_singleHead = classRule || horn;
        this.m_numInstances = instances.numInstances();
        this.m_counterInstances = new ArrayList(this.m_numInstances);
        Enumeration enu = instances.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.m_counterInstances.add(enu.nextElement());
        }
    }

    public Object clone() {
        Object result = null;
        try {
            result = super.clone();
            ((Rule)result).m_body = (Body)this.m_body.clone();
            ((Rule)result).m_head = (Head)this.m_head.clone();
            if (this.m_counterInstances != null) {
                ((Rule)result).m_counterInstances = (ArrayList)this.m_counterInstances.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        return result;
    }

    public boolean counterInstance(Instance instance) {
        return this.m_body.counterInstance(instance) && this.m_head.counterInstance(instance);
    }

    public void upDate(Instances instances) {
        Enumeration enu = instances.enumerateInstances();
        this.m_numInstances = instances.numInstances();
        this.m_counter = 0;
        while (enu.hasMoreElements()) {
            if (!this.counterInstance((Instance)enu.nextElement())) continue;
            ++this.m_counter;
        }
        this.m_head.upDate(instances);
        this.m_body.upDate(instances);
    }

    public double getConfirmation() {
        return this.m_confirmation;
    }

    public double getOptimistic() {
        return this.m_optimistic;
    }

    public double getExpectedNumber() {
        return (double)this.m_body.getCounterInstancesNumber() * (double)this.m_head.getCounterInstancesNumber() / (double)this.m_numInstances;
    }

    public double getExpectedFrequency() {
        return this.getExpectedNumber() / (double)this.m_numInstances;
    }

    public int getObservedNumber() {
        if (this.m_counterInstances != null) {
            return this.m_counterInstances.size();
        }
        return this.m_counter;
    }

    public double getObservedFrequency() {
        return (double)this.getObservedNumber() / (double)this.m_numInstances;
    }

    public double getTPRate() {
        int tp = this.m_body.getCounterInstancesNumber() - this.getObservedNumber();
        int fn = this.m_numInstances - this.m_head.getCounterInstancesNumber() - tp;
        return (double)tp / (double)(tp + fn);
    }

    public double getFPRate() {
        int fp = this.getObservedNumber();
        int tn = this.m_head.getCounterInstancesNumber() - fp;
        return (double)fp / (double)(fp + tn);
    }

    public void calculateConfirmation() {
        double expected = this.getExpectedFrequency();
        double observed = this.getObservedFrequency();
        this.m_confirmation = expected == 0.0 || expected == 1.0 ? 0.0 : (expected - observed) / (Math.sqrt(expected) - expected);
    }

    public void calculateOptimistic() {
        int counterInstances = this.getObservedNumber();
        int body = this.m_body.getCounterInstancesNumber();
        int notHead = this.m_head.getCounterInstancesNumber();
        int n = this.m_numInstances;
        double expectedOptimistic = counterInstances <= body - notHead ? (double)(notHead * (body - counterInstances)) / (double)(n * n) : (counterInstances <= notHead - body ? (double)(body * (notHead - counterInstances)) / (double)(n * n) : (double)((notHead + body - counterInstances) * (notHead + body - counterInstances)) / (double)(4 * n * n));
        this.m_optimistic = expectedOptimistic == 0.0 || expectedOptimistic == 1.0 ? 0.0 : expectedOptimistic / (Math.sqrt(expectedOptimistic) - expectedOptimistic);
    }

    public boolean isEmpty() {
        return this.m_head.isEmpty() && this.m_body.isEmpty();
    }

    public int numLiterals() {
        return this.m_body.numLiterals() + this.m_head.numLiterals();
    }

    private Rule addTermToBody(Literal newLit) {
        if (!this.m_negBody && newLit.negative() || this.m_classRule && newLit.getPredicate().isClass() || newLit instanceof IndividualLiteral && ((IndividualLiteral)newLit).getType() - this.m_body.getType() > 1 && ((IndividualLiteral)newLit).getType() - this.m_head.getType() > 1) {
            return null;
        }
        Rule result = (Rule)this.clone();
        result.m_body.addElement(newLit);
        if (this.m_counterInstances != null) {
            for (int i = result.m_counterInstances.size() - 1; i >= 0; --i) {
                Instance current = (Instance)result.m_counterInstances.get(i);
                if (result.m_body.canKeep(current, newLit)) continue;
                result.m_counterInstances.remove(i);
            }
        }
        return result;
    }

    private Rule addTermToHead(Literal newLit) {
        if (!this.m_negHead && newLit.negative() || this.m_classRule && !newLit.getPredicate().isClass() || this.m_singleHead && !this.m_head.isEmpty() || newLit instanceof IndividualLiteral && ((IndividualLiteral)newLit).getType() != IndividualLiteral.INDIVIDUAL_PROPERTY) {
            return null;
        }
        Rule result = (Rule)this.clone();
        result.m_head.addElement(newLit);
        if (this.m_counterInstances != null) {
            for (int i = result.m_counterInstances.size() - 1; i >= 0; --i) {
                Instance current = (Instance)result.m_counterInstances.get(i);
                if (result.m_head.canKeep(current, newLit)) continue;
                result.m_counterInstances.remove(i);
            }
        }
        return result;
    }

    private SimpleLinkedList refine(Predicate pred, int firstIndex, int lastIndex, boolean addToBody, boolean addToHead) {
        SimpleLinkedList result = new SimpleLinkedList();
        for (int i = firstIndex; i < lastIndex; ++i) {
            Literal negation;
            Rule refinement;
            Literal currentLit = pred.getLiteral(i);
            if (addToBody && (refinement = this.addTermToBody(currentLit)) != null) {
                result.add(refinement);
            }
            if (addToHead && (refinement = this.addTermToHead(currentLit)) != null) {
                result.add(refinement);
            }
            if ((negation = currentLit.getNegation()) == null) continue;
            if (addToBody && (refinement = this.addTermToBody(negation)) != null) {
                result.add(refinement);
            }
            if (!addToHead || (refinement = this.addTermToHead(negation)) == null) continue;
            result.add(refinement);
        }
        return result;
    }

    public SimpleLinkedList refine(ArrayList predicates) {
        SimpleLinkedList result = new SimpleLinkedList();
        if (this.numLiterals() == this.m_maxLiterals) {
            return result;
        }
        if (this.isEmpty()) {
            for (int i = 0; i < predicates.size(); ++i) {
                Predicate currentPred = (Predicate)predicates.get(i);
                result.addAll(this.refine(currentPred, 0, currentPred.numLiterals(), true, true));
            }
        } else if (this.m_body.isEmpty() || this.m_head.isEmpty()) {
            boolean addToHead;
            boolean addToBody;
            LiteralSet side;
            if (this.m_body.isEmpty()) {
                side = this.m_head;
                addToBody = true;
                addToHead = false;
            } else {
                side = this.m_body;
                addToBody = false;
                addToHead = true;
            }
            Literal last = side.getLastLiteral();
            Predicate currentPred = last.getPredicate();
            if (this.m_repeatPredicate) {
                result.addAll(this.refine(currentPred, currentPred.indexOf(last) + 1, currentPred.numLiterals(), addToBody, addToHead));
            }
            for (int i = predicates.indexOf(currentPred) + 1; i < predicates.size(); ++i) {
                currentPred = (Predicate)predicates.get(i);
                result.addAll(this.refine(currentPred, 0, currentPred.numLiterals(), addToBody, addToHead));
            }
        } else {
            Predicate currentPred;
            int j;
            int superiorLit;
            Predicate superiorPred;
            boolean addToHead;
            Literal lastLitBody = this.m_body.getLastLiteral();
            Literal lastLitHead = this.m_head.getLastLiteral();
            Predicate lastPredBody = lastLitBody.getPredicate();
            Predicate lastPredHead = lastLitHead.getPredicate();
            int lastLitBodyIndex = lastPredBody.indexOf(lastLitBody);
            int lastLitHeadIndex = lastPredHead.indexOf(lastLitHead);
            int lastPredBodyIndex = predicates.indexOf(lastPredBody);
            int lastPredHeadIndex = predicates.indexOf(lastPredHead);
            boolean addToBody = this.m_head.numLiterals() == 1 && (lastPredBodyIndex < lastPredHeadIndex || lastPredBodyIndex == lastPredHeadIndex && lastLitBodyIndex < lastLitHeadIndex);
            boolean bl = addToHead = this.m_body.numLiterals() == 1 && (lastPredHeadIndex < lastPredBodyIndex || lastPredHeadIndex == lastPredBodyIndex && lastLitHeadIndex < lastLitBodyIndex);
            if (addToBody || addToHead) {
                int inferiorLit;
                Predicate inferiorPred;
                if (addToBody) {
                    inferiorPred = lastPredBody;
                    inferiorLit = lastLitBodyIndex;
                    superiorPred = lastPredHead;
                    superiorLit = lastLitHeadIndex;
                } else {
                    inferiorPred = lastPredHead;
                    inferiorLit = lastLitHeadIndex;
                    superiorPred = lastPredBody;
                    superiorLit = lastLitBodyIndex;
                }
                if (predicates.indexOf(inferiorPred) < predicates.indexOf(superiorPred)) {
                    if (this.m_repeatPredicate) {
                        result.addAll(this.refine(inferiorPred, inferiorLit + 1, inferiorPred.numLiterals(), addToBody, addToHead));
                    }
                    for (j = predicates.indexOf(inferiorPred) + 1; j < predicates.indexOf(superiorPred); ++j) {
                        currentPred = (Predicate)predicates.get(j);
                        result.addAll(this.refine(currentPred, 0, currentPred.numLiterals(), addToBody, addToHead));
                    }
                    if (this.m_repeatPredicate) {
                        result.addAll(this.refine(superiorPred, 0, superiorLit, addToBody, addToHead));
                    }
                } else if (this.m_repeatPredicate) {
                    result.addAll(this.refine(inferiorPred, inferiorLit + 1, superiorLit, addToBody, addToHead));
                }
            }
            if (predicates.indexOf(lastPredBody) > predicates.indexOf(lastPredHead)) {
                superiorPred = lastPredBody;
                superiorLit = lastPredBody.indexOf(lastLitBody);
            } else if (predicates.indexOf(lastPredBody) < predicates.indexOf(lastPredHead)) {
                superiorPred = lastPredHead;
                superiorLit = lastPredHead.indexOf(lastLitHead);
            } else {
                superiorPred = lastPredBody;
                superiorLit = lastLitBodyIndex > lastLitHeadIndex ? lastPredBody.indexOf(lastLitBody) : lastPredHead.indexOf(lastLitHead);
            }
            if (this.m_repeatPredicate) {
                result.addAll(this.refine(superiorPred, superiorLit + 1, superiorPred.numLiterals(), true, true));
            }
            for (j = predicates.indexOf(superiorPred) + 1; j < predicates.size(); ++j) {
                currentPred = (Predicate)predicates.get(j);
                result.addAll(this.refine(currentPred, 0, currentPred.numLiterals(), true, true));
            }
        }
        return result;
    }

    public boolean subsumes(Rule otherRule) {
        if (this.numLiterals() > otherRule.numLiterals()) {
            return false;
        }
        return this.m_body.isIncludedIn(otherRule) && this.m_head.isIncludedIn(otherRule);
    }

    public boolean sameClauseAs(Rule otherRule) {
        return this.numLiterals() == otherRule.numLiterals() && this.subsumes(otherRule);
    }

    public boolean equivalentTo(Rule otherRule) {
        return this.numLiterals() == otherRule.numLiterals() && this.m_head.negationIncludedIn(otherRule.m_body) && this.m_body.negationIncludedIn(otherRule.m_head);
    }

    public boolean bodyContains(Literal lit) {
        return this.m_body.contains(lit);
    }

    public boolean headContains(Literal lit) {
        return this.m_head.contains(lit);
    }

    public boolean overFrequencyThreshold(double minFrequency) {
        return this.m_body.overFrequencyThreshold(minFrequency) && this.m_head.overFrequencyThreshold(minFrequency);
    }

    public boolean hasTrueBody() {
        return !this.m_body.isEmpty() && this.m_body.hasMaxCounterInstances();
    }

    public boolean hasFalseHead() {
        return !this.m_head.isEmpty() && this.m_head.hasMaxCounterInstances();
    }

    public String valuesToString() {
        StringBuffer text = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        text.append(decimalFormat.format(this.getConfirmation()));
        text.append(" ");
        text.append(decimalFormat.format(this.getObservedFrequency()));
        return text.toString();
    }

    public String rocToString() {
        StringBuffer text = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        text.append(decimalFormat.format(this.getConfirmation()));
        text.append(" ");
        text.append(decimalFormat.format(this.getTPRate()));
        text.append(" ");
        text.append(decimalFormat.format(this.getFPRate()));
        return text.toString();
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.m_body.toString());
        text.append(" ==> ");
        text.append(this.m_head.toString());
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

